/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2Polynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBElement;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nONBField;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra.GF2nPolynomialElement;
import java.security.SecureRandom;
import java.util.Vector;

public class GF2nPolynomialField
extends GF2nField {
    GF2Polynomial[] a;
    private boolean b = false;
    private boolean c = false;
    private int d;
    private int[] e = new int[3];

    public GF2nPolynomialField(int deg, SecureRandom random) {
        super(random);
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        this.computeFieldPolynomial();
        this.a();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int deg, SecureRandom random, boolean file) {
        super(random);
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        if (file) {
            this.computeFieldPolynomial();
        } else {
            this.computeFieldPolynomial2();
        }
        this.a();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public GF2nPolynomialField(int deg, SecureRandom random, GF2Polynomial polynomial) throws RuntimeException {
        super(random);
        if (deg < 3) {
            throw new IllegalArgumentException("degree must be at least 3");
        }
        if (polynomial.getLength() != deg + 1) {
            throw new RuntimeException();
        }
        if (!polynomial.isIrreducible()) {
            throw new RuntimeException();
        }
        this.mDegree = deg;
        this.fieldPolynomial = polynomial;
        this.a();
        int n2 = 2;
        for (int i2 = 1; i2 < this.fieldPolynomial.getLength() - 1; ++i2) {
            if (!this.fieldPolynomial.testBit(i2)) continue;
            if (++n2 == 3) {
                this.d = i2;
            }
            if (n2 > 5) continue;
            this.e[n2 - 3] = i2;
        }
        if (n2 == 3) {
            this.b = true;
        }
        if (n2 == 5) {
            this.c = true;
        }
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    public boolean isTrinomial() {
        return this.b;
    }

    public boolean isPentanomial() {
        return this.c;
    }

    public int getTc() throws RuntimeException {
        if (!this.b) {
            throw new RuntimeException();
        }
        return this.d;
    }

    public int[] getPc() throws RuntimeException {
        if (!this.c) {
            throw new RuntimeException();
        }
        int[] nArray = new int[3];
        System.arraycopy(this.e, 0, nArray, 0, 3);
        return nArray;
    }

    public GF2Polynomial getSquaringVector(int i2) {
        return new GF2Polynomial(this.a[i2]);
    }

    @Override
    protected GF2nElement getRandomRoot(GF2Polynomial polynomial) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(polynomial, this);
        int n2 = gF2nPolynomial.getDegree();
        while (n2 > 1) {
            GF2nPolynomial gF2nPolynomial2;
            int n3;
            do {
                GF2nPolynomialElement gF2nPolynomialElement = new GF2nPolynomialElement(this, this.random);
                GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(2, GF2nPolynomialElement.ZERO(this));
                gF2nPolynomial3.set(1, gF2nPolynomialElement);
                GF2nPolynomial gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial3);
                for (int i2 = 1; i2 <= this.mDegree - 1; ++i2) {
                    gF2nPolynomial4 = gF2nPolynomial4.multiplyAndReduce(gF2nPolynomial4, gF2nPolynomial);
                    gF2nPolynomial4 = gF2nPolynomial4.add(gF2nPolynomial3);
                }
                gF2nPolynomial2 = gF2nPolynomial4.gcd(gF2nPolynomial);
                n3 = gF2nPolynomial2.getDegree();
                n2 = gF2nPolynomial.getDegree();
            } while (n3 == 0 || n3 == n2);
            gF2nPolynomial = n3 << 1 > n2 ? gF2nPolynomial.quotient(gF2nPolynomial2) : new GF2nPolynomial(gF2nPolynomial2);
            n2 = gF2nPolynomial.getDegree();
        }
        return gF2nPolynomial.at(0);
    }

    @Override
    protected void computeCOBMatrix(GF2nField B1) {
        GF2nElement[] gF2nElementArray;
        GF2nElement gF2nElement;
        int n2;
        if (this.mDegree != B1.mDegree) {
            throw new IllegalArgumentException("GF2nPolynomialField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        if (B1 instanceof GF2nONBField) {
            B1.computeCOBMatrix(this);
            return;
        }
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree];
        for (n2 = 0; n2 < this.mDegree; ++n2) {
            gF2PolynomialArray[n2] = new GF2Polynomial(this.mDegree);
        }
        while ((gF2nElement = B1.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        if (gF2nElement instanceof GF2nONBElement) {
            gF2nElementArray = new GF2nONBElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nONBElement.ONE((GF2nONBField)B1);
        } else {
            gF2nElementArray = new GF2nPolynomialElement[this.mDegree];
            gF2nElementArray[this.mDegree - 1] = GF2nPolynomialElement.ONE((GF2nPolynomialField)B1);
        }
        gF2nElementArray[this.mDegree - 2] = gF2nElement;
        for (n2 = this.mDegree - 3; n2 >= 0; --n2) {
            gF2nElementArray[n2] = (GF2nElement)gF2nElementArray[n2 + 1].multiply(gF2nElement);
        }
        if (B1 instanceof GF2nONBField) {
            for (n2 = 0; n2 < this.mDegree; ++n2) {
                for (int i2 = 0; i2 < this.mDegree; ++i2) {
                    if (!gF2nElementArray[n2].a(this.mDegree - i2 - 1)) continue;
                    gF2PolynomialArray[this.mDegree - i2 - 1].setBit(this.mDegree - n2 - 1);
                }
            }
        } else {
            for (n2 = 0; n2 < this.mDegree; ++n2) {
                for (int i3 = 0; i3 < this.mDegree; ++i3) {
                    if (!gF2nElementArray[n2].a(i3)) continue;
                    gF2PolynomialArray[this.mDegree - i3 - 1].setBit(this.mDegree - n2 - 1);
                }
            }
        }
        this.fields.addElement(B1);
        this.matrices.addElement(gF2PolynomialArray);
        B1.fields.addElement(this);
        B1.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
    }

    private void a() {
        int n2;
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree - 1];
        this.a = new GF2Polynomial[this.mDegree];
        for (n2 = 0; n2 < this.a.length; ++n2) {
            this.a[n2] = new GF2Polynomial(this.mDegree, "ZERO");
        }
        for (n2 = 0; n2 < this.mDegree - 1; ++n2) {
            gF2PolynomialArray[n2] = new GF2Polynomial(1, "ONE").shiftLeft(this.mDegree + n2).remainder(this.fieldPolynomial);
        }
        for (n2 = 1; n2 <= Math.abs(this.mDegree >> 1); ++n2) {
            for (int i2 = 1; i2 <= this.mDegree; ++i2) {
                if (!gF2PolynomialArray[this.mDegree - (n2 << 1)].testBit(this.mDegree - i2)) continue;
                this.a[i2 - 1].setBit(this.mDegree - n2);
            }
        }
        for (n2 = Math.abs(this.mDegree >> 1) + 1; n2 <= this.mDegree; ++n2) {
            this.a[(n2 << 1) - this.mDegree - 1].setBit(this.mDegree - n2);
        }
    }

    @Override
    protected void computeFieldPolynomial() {
        if (this.b()) {
            return;
        }
        if (this.c()) {
            return;
        }
        this.d();
    }

    protected void computeFieldPolynomial2() {
        if (this.b()) {
            return;
        }
        if (this.c()) {
            return;
        }
        this.d();
    }

    private boolean b() {
        boolean bl = false;
        int n2 = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i2 = 1; i2 < this.mDegree && !bl; ++i2) {
            this.fieldPolynomial.setBit(i2);
            bl = this.fieldPolynomial.isIrreducible();
            ++n2;
            if (bl) {
                this.b = true;
                this.d = i2;
                return bl;
            }
            this.fieldPolynomial.resetBit(i2);
            bl = this.fieldPolynomial.isIrreducible();
        }
        return bl;
    }

    private boolean c() {
        boolean bl = false;
        int n2 = 0;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        this.fieldPolynomial.setBit(0);
        this.fieldPolynomial.setBit(this.mDegree);
        for (int i2 = 1; i2 <= this.mDegree - 3 && !bl; ++i2) {
            this.fieldPolynomial.setBit(i2);
            for (int i3 = i2 + 1; i3 <= this.mDegree - 2 && !bl; ++i3) {
                this.fieldPolynomial.setBit(i3);
                for (int i4 = i3 + 1; i4 <= this.mDegree - 1 && !bl; ++i4) {
                    this.fieldPolynomial.setBit(i4);
                    if ((this.mDegree & 1) != 0 | (i2 & 1) != 0 | (i3 & 1) != 0 | (i4 & 1) != 0) {
                        bl = this.fieldPolynomial.isIrreducible();
                        ++n2;
                        if (bl) {
                            this.c = true;
                            this.e[0] = i2;
                            this.e[1] = i3;
                            this.e[2] = i4;
                            return bl;
                        }
                    }
                    this.fieldPolynomial.resetBit(i4);
                }
                this.fieldPolynomial.resetBit(i3);
            }
            this.fieldPolynomial.resetBit(i2);
        }
        return bl;
    }

    private boolean d() {
        boolean bl = false;
        this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1);
        int n2 = 0;
        while (!bl) {
            ++n2;
            this.fieldPolynomial.randomize();
            this.fieldPolynomial.setBit(this.mDegree);
            this.fieldPolynomial.setBit(0);
            if (!this.fieldPolynomial.isIrreducible()) continue;
            bl = true;
            return bl;
        }
        return bl;
    }
}

