/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.linearalgebra;

public final class LittleEndianConversions {
    private LittleEndianConversions() {
    }

    public static int OS2IP(byte[] input) {
        return input[0] & 0xFF | (input[1] & 0xFF) << 8 | (input[2] & 0xFF) << 16 | (input[3] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] input, int inOff) {
        int n2 = input[inOff++] & 0xFF;
        n2 |= (input[inOff++] & 0xFF) << 8;
        n2 |= (input[inOff++] & 0xFF) << 16;
        return n2 |= (input[inOff] & 0xFF) << 24;
    }

    public static int OS2IP(byte[] input, int inOff, int inLen) {
        int n2 = 0;
        for (int i2 = inLen - 1; i2 >= 0; --i2) {
            n2 |= (input[inOff + i2] & 0xFF) << 8 * i2;
        }
        return n2;
    }

    public static long OS2LIP(byte[] input, int inOff) {
        long l2 = input[inOff++] & 0xFF;
        l2 |= (long)((input[inOff++] & 0xFF) << 8);
        l2 |= (long)((input[inOff++] & 0xFF) << 16);
        l2 |= ((long)input[inOff++] & 0xFFL) << 24;
        l2 |= ((long)input[inOff++] & 0xFFL) << 32;
        l2 |= ((long)input[inOff++] & 0xFFL) << 40;
        l2 |= ((long)input[inOff++] & 0xFFL) << 48;
        return l2 |= ((long)input[inOff++] & 0xFFL) << 56;
    }

    public static byte[] I2OSP(int x) {
        byte[] byArray = new byte[]{(byte)x, (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24)};
        return byArray;
    }

    public static void I2OSP(int value, byte[] output, int outOff) {
        output[outOff++] = (byte)value;
        output[outOff++] = (byte)(value >>> 8);
        output[outOff++] = (byte)(value >>> 16);
        output[outOff++] = (byte)(value >>> 24);
    }

    public static void I2OSP(int value, byte[] output, int outOff, int outLen) {
        for (int i2 = outLen - 1; i2 >= 0; --i2) {
            output[outOff + i2] = (byte)(value >>> 8 * i2);
        }
    }

    public static byte[] I2OSP(long input) {
        byte[] byArray = new byte[]{(byte)input, (byte)(input >>> 8), (byte)(input >>> 16), (byte)(input >>> 24), (byte)(input >>> 32), (byte)(input >>> 40), (byte)(input >>> 48), (byte)(input >>> 56)};
        return byArray;
    }

    public static void I2OSP(long input, byte[] output, int outOff) {
        output[outOff++] = (byte)input;
        output[outOff++] = (byte)(input >>> 8);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 32);
        output[outOff++] = (byte)(input >>> 40);
        output[outOff++] = (byte)(input >>> 48);
        output[outOff] = (byte)(input >>> 56);
    }

    public static byte[] toByteArray(int[] input, int outLen) {
        int n2 = input.length;
        byte[] byArray = new byte[outLen];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2 - 2) {
            LittleEndianConversions.I2OSP(input[n4], byArray, n3);
            ++n4;
            n3 += 4;
        }
        LittleEndianConversions.I2OSP(input[n2 - 1], byArray, n3, outLen - n3);
        return byArray;
    }

    public static int[] toIntArray(byte[] input) {
        int n2 = (input.length + 3) / 4;
        int n3 = input.length & 3;
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 <= n2 - 2) {
            nArray[n5] = LittleEndianConversions.OS2IP(input, n4);
            ++n5;
            n4 += 4;
        }
        nArray[n2 - 1] = n3 != 0 ? LittleEndianConversions.OS2IP(input, n4, n3) : LittleEndianConversions.OS2IP(input, n4);
        return nArray;
    }
}

