/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial;

import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.LongPolynomial5;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.polynomial.TernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.legacy.math.ntru.util.Util;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DenseTernaryPolynomial
extends IntegerPolynomial
implements TernaryPolynomial {
    DenseTernaryPolynomial(int N) {
        super(N);
        this.c();
    }

    public DenseTernaryPolynomial(IntegerPolynomial intPoly) {
        this(intPoly.coeffs);
    }

    public DenseTernaryPolynomial(int[] coeffs) {
        super(coeffs);
        this.c();
    }

    private void c() {
        for (int i2 = 0; i2 != this.coeffs.length; ++i2) {
            int n2 = this.coeffs[i2];
            if (n2 >= -1 && n2 <= 1) continue;
            throw new IllegalStateException("Illegal value: " + n2 + ", must be one of {-1, 0, 1}");
        }
    }

    public static DenseTernaryPolynomial generateRandom(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int[] nArray = Util.generateRandomTernary(N, numOnes, numNegOnes, random);
        return new DenseTernaryPolynomial(nArray);
    }

    public static DenseTernaryPolynomial generateRandom(int N, SecureRandom random) {
        DenseTernaryPolynomial denseTernaryPolynomial = new DenseTernaryPolynomial(N);
        for (int i2 = 0; i2 < N; ++i2) {
            denseTernaryPolynomial.coeffs[i2] = random.nextInt(3) - 1;
        }
        return denseTernaryPolynomial;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        if (modulus == 2048) {
            IntegerPolynomial integerPolynomial = (IntegerPolynomial)poly2.clone();
            integerPolynomial.modPositive(2048);
            LongPolynomial5 longPolynomial5 = new LongPolynomial5(integerPolynomial);
            return longPolynomial5.mult(this).toIntegerPolynomial();
        }
        return super.mult(poly2, modulus);
    }

    @Override
    public int[] getOnes() {
        int n2 = this.coeffs.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.coeffs[i2];
            if (n4 != 1) continue;
            nArray[n3++] = i2;
        }
        return Arrays.copyOf(nArray, n3);
    }

    @Override
    public int[] getNegOnes() {
        int n2 = this.coeffs.length;
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.coeffs[i2];
            if (n4 != -1) continue;
            nArray[n3++] = i2;
        }
        return Arrays.copyOf(nArray, n3);
    }

    @Override
    public int size() {
        return this.coeffs.length;
    }
}

