/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.ntru.parameters;

import com.enterprisedt.bouncycastle.pqc.math.ntru.Polynomial;

public abstract class NTRUParameterSet {
    private final int a;
    private final int b;
    private final int c;
    private final int d;
    private final int e;

    public NTRUParameterSet(int n2, int logQ, int seedBytes, int prfKeyBytes, int sharedKeyBytes) {
        this.a = n2;
        this.b = logQ;
        this.c = seedBytes;
        this.d = prfKeyBytes;
        this.e = sharedKeyBytes;
    }

    public abstract Polynomial createPolynomial();

    public int n() {
        return this.a;
    }

    public int logQ() {
        return this.b;
    }

    public int q() {
        return 1 << this.b;
    }

    public int seedBytes() {
        return this.c;
    }

    public int prfKeyBytes() {
        return this.d;
    }

    public int sharedKeyBytes() {
        return this.e;
    }

    public int sampleIidBytes() {
        return this.a - 1;
    }

    public int sampleFixedTypeBytes() {
        return (30 * (this.a - 1) + 7) / 8;
    }

    public abstract int sampleFgBytes();

    public abstract int sampleRmBytes();

    public int packDegree() {
        return this.a - 1;
    }

    public int packTrinaryBytes() {
        return (this.packDegree() + 4) / 5;
    }

    public int owcpaMsgBytes() {
        return 2 * this.packTrinaryBytes();
    }

    public int owcpaPublicKeyBytes() {
        return (this.b * this.packDegree() + 7) / 8;
    }

    public int owcpaSecretKeyBytes() {
        return 2 * this.packTrinaryBytes() + this.owcpaPublicKeyBytes();
    }

    public int owcpaBytes() {
        return (this.b * this.packDegree() + 7) / 8;
    }

    public int ntruPublicKeyBytes() {
        return this.owcpaPublicKeyBytes();
    }

    public int ntruSecretKeyBytes() {
        return this.owcpaSecretKeyBytes() + this.d;
    }

    public int ntruCiphertextBytes() {
        return this.owcpaBytes();
    }
}

