/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsCloseable;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHeartbeat;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto a;
    private volatile TlsCloseable b;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.a = crypto;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv13.downTo(ProtocolVersion.TLSv12);
    }

    protected abstract int[] getSupportedCipherSuites();

    @Override
    public void cancel() throws IOException {
        TlsCloseable tlsCloseable = this.b;
        if (null != tlsCloseable) {
            tlsCloseable.close();
        }
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.a;
    }

    @Override
    public void notifyCloseHandle(TlsCloseable closeHandle) {
        this.b = closeHandle;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    @Override
    public int getHandshakeResendTimeMillis() {
        return 1000;
    }

    @Override
    public boolean allowLegacyResumption() {
        return false;
    }

    @Override
    public int getMaxCertificateChainLength() {
        return 10;
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return 32768;
    }

    @Override
    public short[] getPskKeyExchangeModes() {
        return new short[]{1};
    }

    @Override
    public boolean requiresCloseNotify() {
        return true;
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    @Override
    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedPadding() {
        return false;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    @Override
    public void notifyConnectionClosed() {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }

    @Override
    public TlsHeartbeat getHeartbeat() {
        return null;
    }

    @Override
    public short getHeartbeatPolicy() {
        return 2;
    }

    @Override
    public int getRenegotiationPolicy() {
        return 0;
    }
}

