/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.HandshakeMessageInput;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteQueue {
    private byte[] a;
    private int b = 0;
    private int c = 0;
    private boolean d = false;

    public static int nextTwoPow(int i2) {
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public ByteQueue() {
        this(0);
    }

    public ByteQueue(int capacity) {
        this.a = capacity == 0 ? TlsUtils.EMPTY_BYTES : new byte[capacity];
    }

    public ByteQueue(byte[] buf, int off, int len) {
        this.a = buf;
        this.b = off;
        this.c = len;
        this.d = true;
    }

    public void addData(byte[] buf, int off, int len) {
        if (this.d) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.c == 0) {
            if (len > this.a.length) {
                int n2 = ByteQueue.nextTwoPow(len | 0x100);
                this.a = new byte[n2];
            }
            this.b = 0;
        } else if (this.b + this.c + len > this.a.length) {
            int n3 = ByteQueue.nextTwoPow(this.c + len);
            if (n3 > this.a.length) {
                byte[] byArray = new byte[n3];
                System.arraycopy(this.a, this.b, byArray, 0, this.c);
                this.a = byArray;
            } else {
                System.arraycopy(this.a, this.b, this.a, 0, this.c);
            }
            this.b = 0;
        }
        System.arraycopy(buf, off, this.a, this.b + this.c, len);
        this.c += len;
    }

    public int available() {
        return this.c;
    }

    public void copyTo(OutputStream output, int length) throws IOException {
        if (length > this.c) {
            throw new IllegalStateException("Cannot copy " + length + " bytes, only got " + this.c);
        }
        output.write(this.a, this.b, length);
    }

    public void read(byte[] buf, int offset, int len, int skip) {
        if (buf.length - offset < len) {
            throw new IllegalArgumentException("Buffer size of " + buf.length + " is too small for a read of " + len + " bytes");
        }
        if (this.c - skip < len) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.a, this.b + skip, buf, offset, len);
    }

    public void read(ByteBuffer buf, int len, int skip) {
        int n2 = buf.remaining();
        if (n2 < len) {
            throw new IllegalArgumentException("Buffer size of " + n2 + " is too small for a read of " + len + " bytes");
        }
        if (this.c - skip < len) {
            throw new IllegalStateException("Not enough data to read");
        }
        buf.put(this.a, this.b + skip, len);
    }

    HandshakeMessageInput a(int n2) {
        if (n2 > this.c) {
            throw new IllegalStateException("Cannot read " + n2 + " bytes, only got " + this.c);
        }
        int n3 = this.b;
        this.c -= n2;
        this.b += n2;
        return new HandshakeMessageInput(this.a, n3, n2);
    }

    public int readInt32() {
        if (this.c < 4) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readInt32(this.a, this.b);
    }

    public short readUint8(int skip) {
        if (this.c < skip + 1) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readUint8(this.a, this.b + skip);
    }

    public int readUint16(int skip) {
        if (this.c < skip + 2) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readUint16(this.a, this.b + skip);
    }

    public void removeData(int i2) {
        if (i2 > this.c) {
            throw new IllegalStateException("Cannot remove " + i2 + " bytes, only got " + this.c);
        }
        this.c -= i2;
        this.b += i2;
    }

    public void removeData(byte[] buf, int off, int len, int skip) {
        this.read(buf, off, len, skip);
        this.removeData(skip + len);
    }

    public void removeData(ByteBuffer buf, int len, int skip) {
        this.read(buf, len, skip);
        this.removeData(skip + len);
    }

    public byte[] removeData(int len, int skip) {
        byte[] byArray = new byte[len];
        this.removeData(byArray, 0, len, skip);
        return byArray;
    }

    public void shrink() {
        if (this.c == 0) {
            this.a = TlsUtils.EMPTY_BYTES;
            this.b = 0;
        } else {
            int n2 = ByteQueue.nextTwoPow(this.c);
            if (n2 < this.a.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.a, this.b, byArray, 0, this.c);
                this.a = byArray;
                this.b = 0;
            }
        }
    }
}

