/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.CertificateEntry;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class Certificate {
    private static final TlsCertificate[] a = new TlsCertificate[0];
    private static final CertificateEntry[] b = new CertificateEntry[0];
    public static final Certificate EMPTY_CHAIN = new Certificate(a);
    public static final Certificate EMPTY_CHAIN_TLS13 = new Certificate(TlsUtils.EMPTY_BYTES, b);
    protected final byte[] certificateRequestContext;
    protected final CertificateEntry[] certificateEntryList;
    protected final short certificateType;

    private static CertificateEntry[] a(TlsCertificate[] tlsCertificateArray) {
        if (TlsUtils.isNullOrContainsNull(tlsCertificateArray)) {
            throw new NullPointerException("'certificateList' cannot be null or contain any nulls");
        }
        int n2 = tlsCertificateArray.length;
        CertificateEntry[] certificateEntryArray = new CertificateEntry[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            certificateEntryArray[i2] = new CertificateEntry(tlsCertificateArray[i2], null);
        }
        return certificateEntryArray;
    }

    public Certificate(TlsCertificate[] certificateList) {
        this(null, Certificate.a(certificateList));
    }

    public Certificate(byte[] certificateRequestContext, CertificateEntry[] certificateEntryList) {
        this(0, certificateRequestContext, certificateEntryList);
    }

    public Certificate(short certificateType, byte[] certificateRequestContext, CertificateEntry[] certificateEntryList) {
        if (null != certificateRequestContext && !TlsUtils.isValidUint8(certificateRequestContext.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (TlsUtils.isNullOrContainsNull(certificateEntryList)) {
            throw new NullPointerException("'certificateEntryList' cannot be null or contain any nulls");
        }
        this.certificateRequestContext = TlsUtils.clone(certificateRequestContext);
        this.certificateEntryList = certificateEntryList;
        this.certificateType = certificateType;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int index) {
        return this.certificateEntryList[index].getCertificate();
    }

    public CertificateEntry getCertificateEntryAt(int index) {
        return this.certificateEntryList[index];
    }

    public CertificateEntry[] getCertificateEntryList() {
        return this.cloneCertificateEntryList();
    }

    public short getCertificateType() {
        return this.certificateType;
    }

    public int getLength() {
        return this.certificateEntryList.length;
    }

    public boolean isEmpty() {
        return this.certificateEntryList.length == 0;
    }

    public void encode(TlsContext context, OutputStream messageOutput, OutputStream endPointHashOutput) throws IOException {
        Object object;
        Object object2;
        int n2;
        boolean bl;
        if (null != this.certificateRequestContext != (bl = TlsUtils.isTLSv13(context))) {
            throw new IllegalStateException();
        }
        if (bl) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, messageOutput);
        }
        int n3 = this.certificateEntryList.length;
        Vector<byte[]> vector = new Vector<byte[]>(n3);
        Vector<byte[]> vector2 = bl ? new Vector<byte[]>(n3) : null;
        long l2 = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = this.certificateEntryList[n2];
            object = ((CertificateEntry)object2).getCertificate();
            byte[] byArray = object.getEncoded();
            if (n2 == 0 && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, (TlsCertificate)object, byArray, endPointHashOutput);
            }
            vector.addElement(byArray);
            l2 += (long)byArray.length;
            l2 += 3L;
            if (!bl) continue;
            Hashtable hashtable = ((CertificateEntry)object2).getExtensions();
            byte[] byArray2 = null == hashtable ? TlsUtils.EMPTY_BYTES : TlsProtocol.writeExtensionsData(hashtable);
            vector2.addElement(byArray2);
            l2 += (long)byArray2.length;
            l2 += 2L;
        }
        if (bl || this.certificateType != 2) {
            TlsUtils.checkUint24(l2);
            TlsUtils.writeUint24((int)l2, messageOutput);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24((byte[])object2, messageOutput);
            if (!bl) continue;
            object = (byte[])vector2.elementAt(n2);
            TlsUtils.writeOpaque16((byte[])object, messageOutput);
        }
    }

    public static Certificate parse(TlsContext context, InputStream messageInput, OutputStream endPointHashOutput) throws IOException {
        return Certificate.parse(new ParseOptions(), context, messageInput, endPointHashOutput);
    }

    public static Certificate parse(ParseOptions options, TlsContext context, InputStream messageInput, OutputStream endPointHashOutput) throws IOException {
        CertificateEntry[] certificateEntryArray;
        int n2;
        SecurityParameters securityParameters = context.getSecurityParameters();
        boolean bl = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        short s2 = options.getCertificateType();
        byte[] byArray = null;
        if (bl) {
            byArray = TlsUtils.readOpaque8(messageInput);
        }
        if ((n2 = TlsUtils.readUint24(messageInput)) == 0) {
            return !bl ? EMPTY_CHAIN : (byArray.length < 1 ? EMPTY_CHAIN_TLS13 : new Certificate(s2, byArray, b));
        }
        byte[] byArray2 = TlsUtils.readFully(n2, messageInput);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        TlsCrypto tlsCrypto = context.getCrypto();
        int n3 = Math.max(1, options.getMaxChainLength());
        Vector<CertificateEntry> vector = new Vector<CertificateEntry>();
        while (byteArrayInputStream.available() > 0) {
            if (vector.size() >= n3) {
                throw new TlsFatalAlert(80, "Certificate chain longer than maximum (" + n3 + ")");
            }
            if (bl || s2 != 2) {
                certificateEntryArray = (CertificateEntry[])TlsUtils.readOpaque24(byteArrayInputStream, 1);
            } else {
                certificateEntryArray = (CertificateEntry[])byArray2;
                byteArrayInputStream.skip(n2);
            }
            TlsCertificate tlsCertificate = tlsCrypto.createCertificate(s2, (byte[])certificateEntryArray);
            if (vector.isEmpty() && endPointHashOutput != null) {
                Certificate.calculateEndPointHash(context, tlsCertificate, (byte[])certificateEntryArray, endPointHashOutput);
            }
            Hashtable hashtable = null;
            if (bl) {
                byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream);
                hashtable = TlsProtocol.readExtensionsData13(11, byArray3);
            }
            vector.addElement(new CertificateEntry(tlsCertificate, hashtable));
        }
        certificateEntryArray = new CertificateEntry[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            certificateEntryArray[i2] = (CertificateEntry)vector.elementAt(i2);
        }
        return new Certificate(s2, byArray, certificateEntryArray);
    }

    protected static void calculateEndPointHash(TlsContext context, TlsCertificate cert, byte[] encoding, OutputStream output) throws IOException {
        byte[] byArray = TlsUtils.a(context, cert, encoding);
        if (byArray != null && byArray.length > 0) {
            output.write(byArray);
        }
    }

    protected TlsCertificate[] cloneCertificateList() {
        int n2 = this.certificateEntryList.length;
        if (0 == n2) {
            return a;
        }
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            tlsCertificateArray[i2] = this.certificateEntryList[i2].getCertificate();
        }
        return tlsCertificateArray;
    }

    protected CertificateEntry[] cloneCertificateEntryList() {
        int n2 = this.certificateEntryList.length;
        if (0 == n2) {
            return b;
        }
        CertificateEntry[] certificateEntryArray = new CertificateEntry[n2];
        System.arraycopy(this.certificateEntryList, 0, certificateEntryArray, 0, n2);
        return certificateEntryArray;
    }

    public static class ParseOptions {
        private int a = Integer.MAX_VALUE;
        private short b = 0;

        public int getMaxChainLength() {
            return this.a;
        }

        public ParseOptions setMaxChainLength(int maxChainLength) {
            this.a = maxChainLength;
            return this;
        }

        public short getCertificateType() {
            return this.b;
        }

        public ParseOptions setCertificateType(short certificateType) {
            this.b = certificateType;
            return this;
        }
    }
}

