/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ocsp.OCSPResponse;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short statusType, Object response) {
        if (!CertificateStatus.isCorrectType(statusType, response)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.response = response;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public Vector getOCSPResponseList() {
        if (!CertificateStatus.isCorrectType((short)2, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponseList");
        }
        return (Vector)this.response;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                OCSPResponse oCSPResponse = (OCSPResponse)this.response;
                byte[] byArray = oCSPResponse.getEncoded("DER");
                TlsUtils.writeOpaque24(byArray, output);
                break;
            }
            case 2: {
                Object object;
                int n2;
                Vector vector = (Vector)this.response;
                int n3 = vector.size();
                Vector<byte[]> vector2 = new Vector<byte[]>(n3);
                long l2 = 0L;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = (OCSPResponse)vector.elementAt(n2);
                    if (object == null) {
                        vector2.addElement(TlsUtils.EMPTY_BYTES);
                    } else {
                        byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                        vector2.addElement(byArray);
                        l2 += (long)byArray.length;
                    }
                    l2 += 3L;
                }
                TlsUtils.checkUint24(l2);
                TlsUtils.writeUint24((int)l2, output);
                for (n2 = 0; n2 < n3; ++n2) {
                    object = (byte[])vector2.elementAt(n2);
                    TlsUtils.writeOpaque24((byte[])object, output);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(TlsContext context, InputStream input) throws IOException {
        Object object;
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        Certificate certificate = securityParameters.getPeerCertificate();
        if (null == certificate || certificate.isEmpty() || 0 != certificate.getCertificateType()) {
            throw new TlsFatalAlert(80);
        }
        int n2 = certificate.getLength();
        int n3 = securityParameters.getStatusRequestVersion();
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 1: {
                CertificateStatus.requireStatusRequestVersion(1, n3);
                byte[] byArray = TlsUtils.readOpaque24(input, 1);
                object = CertificateStatus.parseOCSPResponse(byArray);
                break;
            }
            case 2: {
                CertificateStatus.requireStatusRequestVersion(2, n3);
                byte[] byArray = TlsUtils.readOpaque24(input, 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Vector<OCSPResponse> vector = new Vector<OCSPResponse>();
                while (byteArrayInputStream.available() > 0) {
                    if (vector.size() >= n2) {
                        throw new TlsFatalAlert(47);
                    }
                    int n4 = TlsUtils.readUint24(byteArrayInputStream);
                    if (n4 < 1) {
                        vector.addElement(null);
                        continue;
                    }
                    byte[] byArray2 = TlsUtils.readFully(n4, (InputStream)byteArrayInputStream);
                    vector.addElement(CertificateStatus.parseOCSPResponse(byArray2));
                }
                vector.trimToSize();
                object = vector;
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(s2, object);
    }

    protected static boolean isCorrectType(short statusType, Object response) {
        switch (statusType) {
            case 1: {
                return response instanceof OCSPResponse;
            }
            case 2: {
                return CertificateStatus.isOCSPResponseList(response);
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }

    protected static boolean isOCSPResponseList(Object response) {
        if (!(response instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)response;
        int n2 = vector.size();
        if (n2 < 1) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = vector.elementAt(i2);
            if (null == e2 || e2 instanceof OCSPResponse) continue;
            return false;
        }
        return true;
    }

    protected static OCSPResponse parseOCSPResponse(byte[] derEncoding) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(derEncoding);
        OCSPResponse oCSPResponse = OCSPResponse.getInstance(aSN1Primitive);
        TlsUtils.requireDEREncoding(oCSPResponse, derEncoding);
        return oCSPResponse;
    }

    protected static void requireStatusRequestVersion(int minVersion, int statusRequestVersion) throws IOException {
        if (statusRequestVersion < minVersion) {
            throw new TlsFatalAlert(50);
        }
    }
}

