/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.OCSPStatusRequest;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertificateStatusRequestItemV2 {
    protected short statusType;
    protected Object request;

    public CertificateStatusRequestItemV2(short statusType, Object request) {
        if (!CertificateStatusRequestItemV2.isCorrectType(statusType, request)) {
            throw new IllegalArgumentException("'request' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.request = request;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getRequest() {
        return this.request;
    }

    public OCSPStatusRequest getOCSPStatusRequest() {
        if (!(this.request instanceof OCSPStatusRequest)) {
            throw new IllegalStateException("'request' is not an OCSPStatusRequest");
        }
        return (OCSPStatusRequest)this.request;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (this.statusType) {
            case 1: 
            case 2: {
                ((OCSPStatusRequest)this.request).encode(byteArrayOutputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque16(byArray, output);
    }

    public static CertificateStatusRequestItemV2 parse(InputStream input) throws IOException {
        OCSPStatusRequest oCSPStatusRequest;
        short s2 = TlsUtils.readUint8(input);
        byte[] byArray = TlsUtils.readOpaque16(input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        switch (s2) {
            case 1: 
            case 2: {
                oCSPStatusRequest = OCSPStatusRequest.parse(byteArrayInputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return new CertificateStatusRequestItemV2(s2, oCSPStatusRequest);
    }

    protected static boolean isCorrectType(short statusType, Object request) {
        switch (statusType) {
            case 1: 
            case 2: {
                return request instanceof OCSPStatusRequest;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

