/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.CertChainType;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.URLAndHash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateURL {
    protected short type;
    protected Vector urlAndHashList;

    public CertificateURL(short type, Vector urlAndHashList) {
        if (!CertChainType.isValid(type)) {
            throw new IllegalArgumentException("'type' is not a valid CertChainType value");
        }
        if (urlAndHashList == null || urlAndHashList.isEmpty()) {
            throw new IllegalArgumentException("'urlAndHashList' must have length > 0");
        }
        if (type == 1 && urlAndHashList.size() != 1) {
            throw new IllegalArgumentException("'urlAndHashList' must contain exactly one entry when type is " + CertChainType.getText(type));
        }
        this.type = type;
        this.urlAndHashList = urlAndHashList;
    }

    public short getType() {
        return this.type;
    }

    public Vector getURLAndHashList() {
        return this.urlAndHashList;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.type, output);
        a a2 = new a();
        for (int i2 = 0; i2 < this.urlAndHashList.size(); ++i2) {
            URLAndHash uRLAndHash = (URLAndHash)this.urlAndHashList.elementAt(i2);
            uRLAndHash.encode(a2);
        }
        a2.a(output);
    }

    public static CertificateURL parse(TlsContext context, InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (!CertChainType.isValid(s2)) {
            throw new TlsFatalAlert(50);
        }
        int n2 = TlsUtils.readUint16(input);
        if (n2 < 1) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n2, input);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<URLAndHash> vector = new Vector<URLAndHash>();
        while (byteArrayInputStream.available() > 0) {
            URLAndHash uRLAndHash = URLAndHash.parse(context, byteArrayInputStream);
            vector.addElement(uRLAndHash);
        }
        if (s2 == 1 && vector.size() != 1) {
            throw new TlsFatalAlert(50);
        }
        return new CertificateURL(s2, vector);
    }

    static class a
    extends ByteArrayOutputStream {
        a() throws IOException {
            TlsUtils.writeUint16(0, this);
        }

        void a(OutputStream outputStream) throws IOException {
            int n2 = this.count - 2;
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, this.buf, 0);
            outputStream.write(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

