/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CertificateVerify {
    private final int a;
    private final byte[] b;

    public CertificateVerify(int algorithm, byte[] signature) {
        if (!TlsUtils.isValidUint16(algorithm)) {
            throw new IllegalArgumentException("'algorithm'");
        }
        if (signature == null) {
            throw new NullPointerException("'signature' cannot be null");
        }
        this.a = algorithm;
        this.b = signature;
    }

    public int getAlgorithm() {
        return this.a;
    }

    public byte[] getSignature() {
        return this.b;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint16(this.a, output);
        TlsUtils.writeOpaque16(this.b, output);
    }

    public static CertificateVerify parse(TlsContext context, InputStream input) throws IOException {
        if (!TlsUtils.isTLSv13(context)) {
            throw new IllegalStateException();
        }
        int n2 = TlsUtils.readUint16(input);
        byte[] byArray = TlsUtils.readOpaque16(input);
        return new CertificateVerify(n2, byArray);
    }
}

