/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ClientHello {
    private final ProtocolVersion a;
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final int[] e;
    private final Hashtable f;
    private final int g;

    public ClientHello(ProtocolVersion version, byte[] random, byte[] sessionID, byte[] cookie, int[] cipherSuites, Hashtable extensions, int bindersSize) {
        this.a = version;
        this.b = random;
        this.c = sessionID;
        this.d = cookie;
        this.e = cipherSuites;
        this.f = extensions;
        this.g = bindersSize;
    }

    public int getBindersSize() {
        return this.g;
    }

    public int[] getCipherSuites() {
        return this.e;
    }

    public ProtocolVersion getClientVersion() {
        return this.a;
    }

    public byte[] getCookie() {
        return this.d;
    }

    public Hashtable getExtensions() {
        return this.f;
    }

    public byte[] getRandom() {
        return this.b;
    }

    public byte[] getSessionID() {
        return this.c;
    }

    public ProtocolVersion getVersion() {
        return this.a;
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        if (this.g < 0) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeVersion(this.a, output);
        output.write(this.b);
        TlsUtils.writeOpaque8(this.c, output);
        if (null != this.d) {
            TlsUtils.writeOpaque8(this.d, output);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.e, output);
        TlsUtils.writeUint8ArrayWithUint8Length(new short[]{0}, output);
        TlsProtocol.writeExtensions(output, this.f, this.g);
    }

    public static ClientHello parse(ByteArrayInputStream messageInput, OutputStream dtlsOutput) throws TlsFatalAlert {
        try {
            return ClientHello.a(messageInput, dtlsOutput);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            throw new TlsFatalAlert(50, (Throwable)iOException);
        }
    }

    private static ClientHello a(ByteArrayInputStream byteArrayInputStream, OutputStream outputStream) throws IOException {
        int n2;
        InputStream inputStream = byteArrayInputStream;
        if (null != outputStream) {
            inputStream = new TeeInputStream(inputStream, outputStream);
        }
        ProtocolVersion protocolVersion = TlsUtils.readVersion(inputStream);
        byte[] byArray = TlsUtils.readFully(32, inputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(inputStream, 0, 32);
        byte[] byArray3 = null;
        if (null != outputStream) {
            n2 = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
            byArray3 = TlsUtils.readOpaque8(byteArrayInputStream, 0, n2);
        }
        if ((n2 = TlsUtils.readUint16(inputStream)) < 2 || (n2 & 1) != 0 || byteArrayInputStream.available() < n2) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n2 / 2, inputStream);
        short[] sArray = TlsUtils.readUint8ArrayWithUint8Length(inputStream, 1);
        if (!Arrays.contains(sArray, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        Hashtable hashtable = null;
        if (byteArrayInputStream.available() > 0) {
            byte[] byArray4 = TlsUtils.readOpaque16(inputStream);
            TlsProtocol.assertEmpty(byteArrayInputStream);
            hashtable = TlsProtocol.readExtensionsDataClientHello(byArray4);
        }
        return new ClientHello(protocolVersion, byArray, byArray2, byArray3, nArray, hashtable, -1);
    }
}

