/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.ClientHello;
import com.enterprisedt.bouncycastle.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.tls.DTLSRequest;
import com.enterprisedt.bouncycastle.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.HeartbeatExtension;
import com.enterprisedt.bouncycastle.tls.KeyExchangeAlgorithm;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.ServerHello;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsHeartbeat;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsServerContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.tls.k;
import com.enterprisedt.bouncycastle.tls.s;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean verifyRequests) {
        this.verifyRequests = verifyRequests;
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport) throws IOException {
        return this.accept(server, transport, null);
    }

    public DTLSTransport accept(TlsServer server, DatagramTransport transport, DTLSRequest request) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        s s2 = new s(server.getCrypto());
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.a = server;
        serverHandshakeState.b = s2;
        server.init(s2);
        s2.a(server);
        SecurityParameters securityParameters = s2.getSecurityParametersHandshake();
        securityParameters.E = server.shouldUseExtendedPadding();
        e e2 = new e(s2, server, transport);
        server.notifyCloseHandle(e2);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, e2, request);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, e2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, e2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, e2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState state, e recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState state, e recordLayer, DTLSRequest request) throws IOException {
        TlsServer tlsServer = state.a;
        s s2 = state.b;
        SecurityParameters securityParameters = s2.getSecurityParametersHandshake();
        f f2 = new f(s2, recordLayer, tlsServer.getHandshakeTimeoutMillis(), tlsServer.getHandshakeResendTimeMillis(), request);
        f.a a2 = null;
        if (null == request) {
            a2 = f2.d();
            if (a2.b() != 1) {
                throw new TlsFatalAlert(10);
            }
            this.processClientHello(state, a2.c());
            a2 = null;
        } else {
            this.processClientHello(state, request.a());
            request = null;
        }
        Object object = this.generateServerHello(state, recordLayer);
        Object object2 = s2.getServerVersion();
        recordLayer.a((ProtocolVersion)object2);
        recordLayer.b((ProtocolVersion)object2);
        f2.a((short)2, (byte[])object);
        f2.b().notifyPRFDetermined();
        if (securityParameters.isResumedSession()) {
            securityParameters.r = state.e;
            recordLayer.a(TlsUtils.c(s2));
            securityParameters.X = TlsUtils.a((TlsContext)s2, f2.b(), true);
            f2.a((short)20, securityParameters.getLocalVerifyData());
            securityParameters.Y = TlsUtils.a((TlsContext)s2, f2.b(), false);
            this.processFinished(f2.a((short)20), securityParameters.getPeerVerifyData());
            f2.e();
            if (securityParameters.isExtendedMasterSecret()) {
                securityParameters.B = securityParameters.getLocalVerifyData();
            }
            securityParameters.R = state.d.getLocalCertificate();
            securityParameters.S = state.d.getPeerCertificate();
            securityParameters.y = state.d.getPSKIdentity();
            securityParameters.z = state.d.getSRPIdentity();
            s2.a(tlsServer, state.c);
            recordLayer.a(state.m, 1 == state.n);
            return new DTLSTransport(recordLayer);
        }
        object = tlsServer.getServerSupplementalData();
        if (object != null) {
            object2 = DTLSServerProtocol.generateSupplementalData((Vector)object);
            f2.a((short)23, (byte[])object2);
        }
        state.j = TlsUtils.a(s2, tlsServer);
        state.k = null;
        if (!KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm())) {
            state.k = TlsUtils.a(tlsServer);
        }
        object2 = null;
        Object object3 = new ByteArrayOutputStream();
        if (state.k == null) {
            state.j.skipServerCredentials();
        } else {
            state.j.processServerCredentials(state.k);
            object2 = state.k.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(s2, f2, (Certificate)object2, (OutputStream)object3);
        }
        securityParameters.A = ((ByteArrayOutputStream)object3).toByteArray();
        if (object2 == null || ((Certificate)object2).isEmpty()) {
            securityParameters.U = 0;
        }
        if (securityParameters.getStatusRequestVersion() > 0 && (object2 = tlsServer.getCertificateStatus()) != null) {
            object3 = this.generateCertificateStatus(state, (CertificateStatus)object2);
            f2.a((short)22, (byte[])object3);
        }
        if ((object2 = (Object)state.j.generateServerKeyExchange()) != null) {
            f2.a((short)12, (byte[])object2);
        }
        if (state.k != null) {
            state.l = tlsServer.getCertificateRequest();
            if (null == state.l) {
                if (!state.j.requiresCertificateVerify()) {
                    throw new TlsFatalAlert(80);
                }
            } else {
                if (TlsUtils.isTLSv12(s2) != (state.l.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                state.l = TlsUtils.a(state.l, state.j);
                TlsUtils.a(securityParameters, state.l);
                if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion())) {
                    TlsUtils.a(f2.b(), securityParameters.getServerSigAlgs());
                    if (s2.getCrypto().hasAnyStreamVerifiers(securityParameters.getServerSigAlgs())) {
                        f2.b().forceBuffering();
                    }
                } else if (s2.getCrypto().hasAnyStreamVerifiersLegacy(state.l.getCertificateTypes())) {
                    f2.b().forceBuffering();
                }
            }
        }
        f2.b().sealHashAlgorithms();
        if (null != state.l) {
            object3 = this.generateCertificateRequest(state, state.l);
            f2.a((short)13, (byte[])object3);
        }
        f2.a((short)14, TlsUtils.EMPTY_BYTES);
        a2 = f2.d();
        if (a2.b() == 23) {
            this.processClientSupplementalData(state, a2.c());
            a2 = f2.d();
        } else {
            tlsServer.processClientSupplementalData(null);
        }
        if (state.l == null) {
            state.j.skipClientCredentials();
        } else if (a2.b() == 11) {
            this.processClientCertificate(state, a2.c());
            a2 = f2.d();
        } else {
            if (TlsUtils.isTLSv12(s2)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(state, Certificate.EMPTY_CHAIN);
        }
        if (a2.b() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(state, a2.c());
        securityParameters.w = TlsUtils.a(f2.b());
        TlsProtocol.establishMasterSecret(s2, state.j);
        recordLayer.a(TlsUtils.c(s2));
        if (this.expectCertificateVerifyMessage(state)) {
            a2 = f2.b((short)15);
            object3 = a2.c();
            this.processCertificateVerify(state, (byte[])object3, f2.b());
            f2.c();
            f2.a(a2);
        } else {
            f2.c();
        }
        a2 = null;
        securityParameters.Y = TlsUtils.a((TlsContext)s2, f2.b(), false);
        this.processFinished(f2.a((short)20), securityParameters.getPeerVerifyData());
        if (state.i) {
            object3 = tlsServer.getNewSessionTicket();
            byte[] byArray = this.generateNewSessionTicket(state, (NewSessionTicket)object3);
            f2.a((short)4, byArray);
        }
        securityParameters.X = TlsUtils.a((TlsContext)s2, f2.b(), true);
        f2.a((short)20, securityParameters.getLocalVerifyData());
        f2.e();
        state.e = securityParameters.getMasterSecret();
        state.d = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(s2.getCrypto().adoptSecret(state.e)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.h).build();
        state.c = TlsUtils.importSession(securityParameters.getSessionID(), state.d);
        securityParameters.B = securityParameters.getPeerVerifyData();
        s2.a(tlsServer, state.c);
        recordLayer.a(state.m, 1 == state.n);
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState state, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(state.b, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState state, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState state, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState state, e recordLayer) throws IOException {
        TlsServer tlsServer = state.a;
        s s2 = state.b;
        SecurityParameters securityParameters = s2.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = tlsServer.getServerVersion();
        if (!ProtocolVersion.contains(s2.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.T = protocolVersion;
        boolean bl = tlsServer.shouldUseGMTUnixTime();
        securityParameters.v = TlsProtocol.createRandomBlock(bl, s2);
        if (!protocolVersion.equals(ProtocolVersion.getLatestDTLS(tlsServer.getProtocolVersions()))) {
            TlsUtils.b(protocolVersion, securityParameters.getServerRandom());
        }
        Hashtable hashtable = state.g.getExtensions();
        TlsSession tlsSession = tlsServer.getSessionToResume(state.g.getSessionID());
        boolean bl2 = this.establishSession(state, tlsSession);
        if (bl2 && !protocolVersion.equals(state.d.getNegotiatedVersion())) {
            bl2 = false;
        }
        boolean bl3 = false;
        if (TlsUtils.a(protocolVersion) && tlsServer.shouldUseExtendedMasterSecret()) {
            if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(hashtable)) {
                bl3 = true;
            } else {
                if (tlsServer.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
                if (bl2) {
                    if (state.d.isExtendedMasterSecret()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for EMS session resumption");
                    }
                    if (!tlsServer.allowLegacyResumption()) {
                        throw new TlsFatalAlert(40, "Extended Master Secret extension is required for legacy session resumption");
                    }
                }
            }
        }
        if (bl2 && bl3 != state.d.isExtendedMasterSecret()) {
            bl2 = false;
        }
        securityParameters.D = bl3;
        if (!bl2) {
            this.cancelSession(state);
            byte[] byArray = tlsServer.getNewSessionID();
            if (null == byArray) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
            state.c = TlsUtils.importSession(byArray, null);
        }
        securityParameters.b = bl2;
        securityParameters.x = state.c.getSessionID();
        tlsServer.notifySession(state.c);
        TlsUtils.a(s2);
        int n2 = DTLSServerProtocol.validateSelectedCipherSuite(tlsServer.getSelectedCipherSuite(), (short)80);
        if (!TlsUtils.a(state.g.getCipherSuites(), n2) || !TlsUtils.isValidVersionForCipherSuite(n2, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.b(securityParameters, n2);
        Object object = bl2 ? state.d.readServerExtensions() : tlsServer.getServerExtensions();
        state.h = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)object);
        tlsServer.getServerExtensionsForConnection(state.h);
        if (securityParameters.isSecureRenegotiation()) {
            boolean bl4;
            object = TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl5 = bl4 = null == object;
            if (bl4) {
                state.h.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(state.h);
        } else {
            state.h.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        if (null != state.m || 1 == state.n) {
            TlsExtensionsUtils.addHeartbeatExtension(state.h, new HeartbeatExtension(state.n));
        }
        securityParameters.G = TlsExtensionsUtils.getALPNExtensionServer(state.h);
        securityParameters.H = true;
        if (ProtocolVersion.DTLSv12.equals(securityParameters.getNegotiatedVersion()) && (object = (Object)TlsExtensionsUtils.getConnectionIDExtension(state.h)) != null) {
            byte[] byArray = TlsExtensionsUtils.getConnectionIDExtension(hashtable);
            if (byArray == null) {
                throw new TlsFatalAlert(80);
            }
            securityParameters.Z = byArray;
            securityParameters.aa = (byte[])object;
        }
        if (!state.h.isEmpty()) {
            securityParameters.C = TlsExtensionsUtils.hasEncryptThenMACExtension(state.h);
            securityParameters.f = TlsUtils.a(bl2 ? null : hashtable, state.h, (short)80);
            securityParameters.F = TlsExtensionsUtils.hasTruncatedHMacExtension(state.h);
            if (!bl2) {
                if (TlsUtils.hasExpectedEmptyExtensionData(state.h, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.U = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(state.h, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.U = 1;
                }
                securityParameters.V = TlsUtils.b(hashtable, state.h, (short)80);
                securityParameters.W = TlsUtils.d(hashtable, state.h, (short)80);
                state.i = TlsUtils.hasExpectedEmptyExtensionData(state.h, TlsProtocol.EXT_SessionTicket, (short)80);
            }
        }
        object = new ServerHello(protocolVersion, securityParameters.getServerRandom(), securityParameters.getSessionID(), securityParameters.getCipherSuite(), state.h);
        state.g = null;
        DTLSServerProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((ServerHello)object).encode(s2, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void cancelSession(ServerHandshakeState state) {
        if (state.e != null) {
            state.e.destroy();
            state.e = null;
        }
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        state.c = null;
    }

    protected boolean establishSession(ServerHandshakeState state, TlsSession sessionToResume) {
        state.c = null;
        state.d = null;
        state.e = null;
        if (null == sessionToResume || !sessionToResume.isResumable()) {
            return false;
        }
        SessionParameters sessionParameters = sessionToResume.exportSessionParameters();
        if (null == sessionParameters) {
            return false;
        }
        ProtocolVersion protocolVersion = sessionParameters.getNegotiatedVersion();
        if (null == protocolVersion || !protocolVersion.isDTLS()) {
            return false;
        }
        boolean bl = sessionParameters.isExtendedMasterSecret();
        if (!TlsUtils.a(protocolVersion) && !bl) {
            return false;
        }
        TlsCrypto tlsCrypto = state.b.getCrypto();
        TlsSecret tlsSecret = TlsUtils.a(tlsCrypto, sessionParameters.getMasterSecret());
        if (null == tlsSecret) {
            return false;
        }
        state.c = sessionToResume;
        state.d = sessionParameters;
        state.e = tlsSecret;
        return true;
    }

    protected void invalidateSession(ServerHandshakeState state) {
        if (state.c != null) {
            state.c.invalidate();
        }
        this.cancelSession(state);
    }

    protected void notifyClientCertificate(ServerHandshakeState state, Certificate clientCertificate) throws IOException {
        if (null == state.l) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a((TlsServerContext)state.b, clientCertificate, state.j, state.a);
    }

    protected void processClientCertificate(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(state.b.getSecurityParametersHandshake().getClientCertificateType()).setMaxChainLength(state.a.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, state.b, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(state, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState state, byte[] body, TlsHandshakeHash handshakeHash) throws IOException {
        if (state.l == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        s s2 = state.b;
        DigitallySigned digitallySigned = DigitallySigned.parse(s2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.a((TlsServerContext)s2, state.l, digitallySigned, handshakeHash);
    }

    protected void processClientHello(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ClientHello clientHello = ClientHello.parse(byteArrayInputStream, k.a);
        this.processClientHello(state, clientHello);
    }

    protected void processClientHello(ServerHandshakeState state, ClientHello clientHello) throws IOException {
        state.g = clientHello;
        ProtocolVersion protocolVersion = clientHello.getVersion();
        int[] nArray = clientHello.getCipherSuites();
        Hashtable hashtable = clientHello.getExtensions();
        TlsServer tlsServer = state.a;
        s s2 = state.b;
        SecurityParameters securityParameters = s2.getSecurityParametersHandshake();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        s2.b(protocolVersion);
        s2.a(TlsExtensionsUtils.getSupportedVersionsExtensionClient(hashtable));
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (null == s2.getClientSupportedVersions()) {
            if (protocolVersion2.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                protocolVersion2 = ProtocolVersion.DTLSv12;
            }
            s2.a(protocolVersion2.downTo(ProtocolVersion.DTLSv10));
        } else {
            protocolVersion2 = ProtocolVersion.getLatestDTLS(s2.getClientSupportedVersions());
        }
        if (!ProtocolVersion.e.isEqualOrEarlierVersionOf(protocolVersion2)) {
            throw new TlsFatalAlert(70);
        }
        s2.a(protocolVersion2);
        tlsServer.notifyClientVersion(s2.getClientVersion());
        securityParameters.u = clientHello.getRandom();
        tlsServer.notifyFallback(Arrays.contains(nArray, 22016));
        tlsServer.notifyOfferedCipherSuites(nArray);
        byte[] byArray = TlsUtils.getExtensionData(hashtable, TlsProtocol.EXT_RenegotiationInfo);
        if (Arrays.contains(nArray, 255)) {
            securityParameters.d = true;
        }
        if (byArray != null) {
            securityParameters.d = true;
            if (!Arrays.constantTimeAreEqual(byArray, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        tlsServer.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (hashtable != null) {
            TlsExtensionsUtils.getPaddingExtension(hashtable);
            securityParameters.J = TlsExtensionsUtils.getServerNameExtensionClient(hashtable);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion2)) {
                TlsUtils.a(securityParameters, hashtable);
            }
            securityParameters.M = TlsExtensionsUtils.getSupportedGroupsExtension(hashtable);
            HeartbeatExtension heartbeatExtension = TlsExtensionsUtils.getHeartbeatExtension(hashtable);
            if (null != heartbeatExtension) {
                if (1 == heartbeatExtension.getMode()) {
                    state.m = tlsServer.getHeartbeat();
                }
                state.n = tlsServer.getHeartbeatPolicy();
            }
            tlsServer.processClientExtensions(hashtable);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.j.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState state) {
        if (null == state.l) {
            return false;
        }
        Certificate certificate = state.b.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == state.j || state.j.requiresCertificateVerify());
    }

    protected static class ServerHandshakeState {
        TlsServer a = null;
        s b = null;
        TlsSession c = null;
        SessionParameters d = null;
        TlsSecret e = null;
        SessionParameters.Builder f = null;
        ClientHello g = null;
        Hashtable h = null;
        boolean i = false;
        TlsKeyExchange j = null;
        TlsCredentials k = null;
        CertificateRequest l = null;
        TlsHeartbeat m = null;
        short n = (short)2;

        protected ServerHandshakeState() {
        }
    }
}

