/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.DTLSRecordCallback;
import com.enterprisedt.bouncycastle.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.e;
import java.io.IOException;
import java.io.InterruptedIOException;

public class DTLSTransport
implements DatagramTransport {
    private final e a;

    DTLSTransport(e recordLayer) {
        this.a = recordLayer;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this.a.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this.a.getSendLimit();
    }

    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        return this.receive(buf, off, len, waitMillis, null);
    }

    public int receive(byte[] buf, int off, int len, int waitMillis, DTLSRecordCallback recordCallback) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        if (waitMillis < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        try {
            return this.a.a(buf, off, len, waitMillis, recordCallback);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (20 == tlsFatalAlert.getAlertDescription()) {
                return -1;
            }
            this.a.a(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.a.a((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.a.a((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    public int receivePending(byte[] buf, int off, int len) throws IOException {
        return this.receivePending(buf, off, len, null);
    }

    public int receivePending(byte[] buf, int off, int len, DTLSRecordCallback recordCallback) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        try {
            return this.a.a(buf, off, len, recordCallback);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            if (20 == tlsFatalAlert.getAlertDescription()) {
                return -1;
            }
            this.a.a(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.a.a((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.a.a((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void send(byte[] buf, int off, int len) throws IOException {
        if (null == buf) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        try {
            this.a.send(buf, off, len);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.a.a(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.a.a((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.a.a((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }
}

