/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSigner;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import java.io.IOException;

public class DefaultTlsCredentialedSigner
implements TlsCredentialedSigner {
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public DefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, TlsSigner signer, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (signer == null) {
            throw new IllegalArgumentException("'signer' cannot be null");
        }
        this.signer = signer;
        this.cryptoParams = cryptoParams;
        this.certificate = certificate;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] generateRawSignature(byte[] hash) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), hash);
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    @Override
    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (signatureAndHashAlgorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return signatureAndHashAlgorithm;
    }
}

