/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.DHStandardGroups;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsDHConfigVerifier
implements TlsDHConfigVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void a(DHGroup dHGroup) {
        DEFAULT_GROUPS.addElement(dHGroup);
    }

    public DefaultTlsDHConfigVerifier() {
        this(2048);
    }

    public DefaultTlsDHConfigVerifier(int minimumPrimeBits) {
        this(DEFAULT_GROUPS, minimumPrimeBits);
    }

    public DefaultTlsDHConfigVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = groups;
        this.minimumPrimeBits = minimumPrimeBits;
    }

    @Override
    public boolean accept(TlsDHConfig dhConfig) {
        return this.checkMinimumPrimeBits(dhConfig) && this.checkGroup(dhConfig);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup a2, DHGroup b2) {
        return a2 == b2 || this.areParametersEqual(a2.getP(), b2.getP()) && this.areParametersEqual(a2.getG(), b2.getG());
    }

    protected boolean areParametersEqual(BigInteger a2, BigInteger b2) {
        return a2 == b2 || a2.equals(b2);
    }

    protected boolean checkGroup(TlsDHConfig dhConfig) {
        if (NamedGroup.refersToASpecificFiniteField(dhConfig.getNamedGroup())) {
            return true;
        }
        DHGroup dHGroup = dhConfig.getExplicitGroup();
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (!this.areGroupsEqual(dHGroup, (DHGroup)this.groups.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(TlsDHConfig dhConfig) {
        int n2 = this.getMinimumPrimeBits();
        int n3 = dhConfig.getNamedGroup();
        if (n3 >= 0) {
            return NamedGroup.getFiniteFieldBits(n3) >= n2;
        }
        DHGroup dHGroup = dhConfig.getExplicitGroup();
        return dHGroup.getP().bitLength() >= n2;
    }

    static {
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc7919_ffdhe8192);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHConfigVerifier.a(DHStandardGroups.rfc3526_8192);
    }
}

