/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DigitallySigned {
    private final SignatureAndHashAlgorithm a;
    private final byte[] b;

    public DigitallySigned(SignatureAndHashAlgorithm algorithm, byte[] signature) {
        if (signature == null) {
            throw new IllegalArgumentException("'signature' cannot be null");
        }
        this.a = algorithm;
        this.b = signature;
    }

    public SignatureAndHashAlgorithm getAlgorithm() {
        return this.a;
    }

    public byte[] getSignature() {
        return this.b;
    }

    public void encode(OutputStream output) throws IOException {
        if (this.a != null) {
            this.a.encode(output);
        }
        TlsUtils.writeOpaque16(this.b, output);
    }

    public static DigitallySigned parse(TlsContext context, InputStream input) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(context) && 0 == (signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(input)).getSignature()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray = TlsUtils.readOpaque16(input);
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }
}

