/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.HeartbeatMessageType;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected byte[] padding;

    public static HeartbeatMessage create(TlsContext context, short type, byte[] payload) {
        return HeartbeatMessage.create(context, type, payload, 16);
    }

    public static HeartbeatMessage create(TlsContext context, short type, byte[] payload, int paddingLength) {
        byte[] byArray = context.getNonceGenerator().generateNonce(paddingLength);
        return new HeartbeatMessage(type, payload, byArray);
    }

    public HeartbeatMessage(short type, byte[] payload, byte[] padding) {
        if (!HeartbeatMessageType.isValid(type)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (null == payload || payload.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (null == padding || padding.length < 16) {
            throw new IllegalArgumentException("'padding' must have length >= 16");
        }
        this.type = type;
        this.payload = payload;
        this.padding = padding;
    }

    public int getPaddingLength() {
        return this.padding.length;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short getType() {
        return this.type;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.type, output);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, output);
        output.write(this.payload);
        output.write(this.padding);
    }

    public static HeartbeatMessage parse(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (!HeartbeatMessageType.isValid(s2)) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16(input);
        a a2 = new a();
        Streams.pipeAll(input, a2);
        byte[] byArray = a2.a(n2);
        if (null == byArray) {
            return null;
        }
        byte[] byArray2 = a2.b(n2);
        return new HeartbeatMessage(s2, byArray, byArray2);
    }

    static class a
    extends ByteArrayOutputStream {
        a() {
        }

        byte[] a(int n2) {
            int n3 = this.count - 16;
            if (n2 > n3) {
                return null;
            }
            return Arrays.copyOf(this.buf, n2);
        }

        byte[] b(int n2) {
            return TlsUtils.copyOfRangeExact(this.buf, n2, this.count);
        }
    }
}

