/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NewSessionTicket {
    protected long ticketLifetimeHint;
    protected byte[] ticket;

    public NewSessionTicket(long ticketLifetimeHint, byte[] ticket) {
        this.ticketLifetimeHint = ticketLifetimeHint;
        this.ticket = ticket;
    }

    public long getTicketLifetimeHint() {
        return this.ticketLifetimeHint;
    }

    public byte[] getTicket() {
        return this.ticket;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint32(this.ticketLifetimeHint, output);
        TlsUtils.writeOpaque16(this.ticket, output);
    }

    public static NewSessionTicket parse(InputStream input) throws IOException {
        long l2 = TlsUtils.readUint32(input);
        byte[] byArray = TlsUtils.readOpaque16(input);
        return new NewSessionTicket(l2, byArray);
    }
}

