/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ocsp.ResponderID;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class OCSPStatusRequest {
    protected Vector responderIDList;
    protected Extensions requestExtensions;

    public OCSPStatusRequest(Vector responderIDList, Extensions requestExtensions) {
        this.responderIDList = responderIDList;
        this.requestExtensions = requestExtensions;
    }

    public Vector getResponderIDList() {
        return this.responderIDList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void encode(OutputStream output) throws IOException {
        Object object;
        if (this.responderIDList == null || this.responderIDList.isEmpty()) {
            TlsUtils.writeUint16(0, output);
        } else {
            object = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < this.responderIDList.size(); ++i2) {
                ResponderID responderID = (ResponderID)this.responderIDList.elementAt(i2);
                byte[] byArray = responderID.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, (OutputStream)object);
            }
            TlsUtils.checkUint16(((ByteArrayOutputStream)object).size());
            TlsUtils.writeUint16(((ByteArrayOutputStream)object).size(), output);
            Streams.writeBufTo((ByteArrayOutputStream)object, output);
        }
        if (this.requestExtensions == null) {
            TlsUtils.writeUint16(0, output);
        } else {
            object = this.requestExtensions.getEncoded("DER");
            TlsUtils.checkUint16(((Object)object).length);
            TlsUtils.writeUint16(((Object)object).length, output);
            output.write((byte[])object);
        }
    }

    public static OCSPStatusRequest parse(InputStream input) throws IOException {
        ASN1Object aSN1Object;
        Object object;
        Object object2;
        Vector<ResponderID> vector = new Vector<ResponderID>();
        Object object3 = TlsUtils.readOpaque16(input);
        if (((byte[])object3).length > 0) {
            object2 = new ByteArrayInputStream((byte[])object3);
            do {
                object = TlsUtils.readOpaque16((InputStream)object2, 1);
                aSN1Object = TlsUtils.readASN1Object(object);
                ResponderID responderID = ResponderID.getInstance(aSN1Object);
                TlsUtils.requireDEREncoding(responderID, object);
                vector.addElement(responderID);
            } while (((ByteArrayInputStream)object2).available() > 0);
        }
        object3 = null;
        object2 = TlsUtils.readOpaque16(input);
        if (((Object)object2).length > 0) {
            object = TlsUtils.readASN1Object((byte[])object2);
            aSN1Object = Extensions.getInstance(object);
            TlsUtils.requireDEREncoding(aSN1Object, (byte[])object2);
            object3 = aSN1Object;
        }
        return new OCSPStatusRequest(vector, (Extensions)object3);
    }
}

