/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.tls.BasicTlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    private static final int[] a = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsCrypto crypto, byte[] identity, byte[] psk) {
        this(crypto, new BasicTlsPSKIdentity(identity, psk));
    }

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        super(crypto);
        this.pskIdentity = pskIdentity;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), a);
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() {
        return this.pskIdentity;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

