/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PskIdentity {
    protected byte[] identity;
    protected long obfuscatedTicketAge;

    public PskIdentity(byte[] identity, long obfuscatedTicketAge) {
        if (null == identity) {
            throw new IllegalArgumentException("'identity' cannot be null");
        }
        if (identity.length < 1 || !TlsUtils.isValidUint16(identity.length)) {
            throw new IllegalArgumentException("'identity' should have length from 1 to 65535");
        }
        if (!TlsUtils.isValidUint32(obfuscatedTicketAge)) {
            throw new IllegalArgumentException("'obfuscatedTicketAge' should be a uint32");
        }
        this.identity = identity;
        this.obfuscatedTicketAge = obfuscatedTicketAge;
    }

    public int getEncodedLength() {
        return 6 + this.identity.length;
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public long getObfuscatedTicketAge() {
        return this.obfuscatedTicketAge;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(this.identity, output);
        TlsUtils.writeUint32(this.obfuscatedTicketAge, output);
    }

    public static PskIdentity parse(InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        long l2 = TlsUtils.readUint32(input);
        return new PskIdentity(byArray, l2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PskIdentity)) {
            return false;
        }
        PskIdentity pskIdentity = (PskIdentity)obj;
        return this.obfuscatedTicketAge == pskIdentity.obfuscatedTicketAge && Arrays.constantTimeAreEqual(this.identity, pskIdentity.identity);
    }

    public int hashCode() {
        return Arrays.hashCode(this.identity) ^ (int)this.obfuscatedTicketAge ^ (int)(this.obfuscatedTicketAge >>> 32);
    }
}

