/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsServer;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsSRPIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.tls.TlsSRPUtils;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsServer
extends AbstractTlsServer {
    private static final int[] a = new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters srpLoginParameters = null;

    public SRPTlsServer(TlsCrypto crypto, TlsSRPIdentityManager srpIdentityManager) {
        super(crypto);
        this.srpIdentityManager = srpIdentityManager;
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), a);
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(clientExtensions);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        int n2 = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(n2)) {
            if (this.srpIdentity != null) {
                this.srpLoginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.srpLoginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return n2;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (n2) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return this.srpLoginParameters;
    }
}

