/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ServerName {
    private final short a;
    private final byte[] b;

    public ServerName(short nameType, byte[] nameData) {
        if (!TlsUtils.isValidUint8(nameType)) {
            throw new IllegalArgumentException("'nameType' must be from 0 to 255");
        }
        if (null == nameData) {
            throw new NullPointerException("'nameData' cannot be null");
        }
        if (nameData.length < 1 || !TlsUtils.isValidUint16(nameData.length)) {
            throw new IllegalArgumentException("'nameData' must have length from 1 to 65535");
        }
        this.a = nameType;
        this.b = nameData;
    }

    public short getNameType() {
        return this.a;
    }

    public byte[] getNameData() {
        return this.b;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.a, output);
        TlsUtils.writeOpaque16(this.b, output);
    }

    public static ServerName parse(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        byte[] byArray = TlsUtils.readOpaque16(input, 1);
        return new ServerName(s2, byArray);
    }
}

