/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class SessionParameters {
    private int a;
    private Certificate b;
    private TlsSecret c;
    private ProtocolVersion d;
    private Certificate e;
    private byte[] f = null;
    private byte[] g = null;
    private byte[] h;
    private boolean i;

    private SessionParameters(int cipherSuite, Certificate localCertificate, TlsSecret masterSecret, ProtocolVersion negotiatedVersion, Certificate peerCertificate, byte[] pskIdentity, byte[] srpIdentity, byte[] encodedServerExtensions, boolean extendedMasterSecret) {
        this.a = cipherSuite;
        this.b = localCertificate;
        this.c = masterSecret;
        this.d = negotiatedVersion;
        this.e = peerCertificate;
        this.f = Arrays.clone(pskIdentity);
        this.g = Arrays.clone(srpIdentity);
        this.h = encodedServerExtensions;
        this.i = extendedMasterSecret;
    }

    public void clear() {
        if (this.c != null) {
            this.c.destroy();
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
    }

    public int getCipherSuite() {
        return this.a;
    }

    public Certificate getLocalCertificate() {
        return this.b;
    }

    public TlsSecret getMasterSecret() {
        return this.c;
    }

    public ProtocolVersion getNegotiatedVersion() {
        return this.d;
    }

    public Certificate getPeerCertificate() {
        return this.e;
    }

    public byte[] getPSKIdentity() {
        return this.f;
    }

    public byte[] getSRPIdentity() {
        return this.g;
    }

    public boolean isExtendedMasterSecret() {
        return this.i;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.h == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.h);
        return TlsProtocol.readExtensions(byteArrayInputStream);
    }

    public static final class Builder {
        private int a = -1;
        private Certificate b = null;
        private TlsSecret c = null;
        private ProtocolVersion d;
        private Certificate e = null;
        private byte[] f = null;
        private byte[] g = null;
        private byte[] h = null;
        private boolean i = false;

        public SessionParameters build() {
            this.a(this.a >= 0, "cipherSuite");
            this.a(this.c != null, "masterSecret");
            return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public Builder setCipherSuite(int cipherSuite) {
            this.a = cipherSuite;
            return this;
        }

        public Builder setExtendedMasterSecret(boolean extendedMasterSecret) {
            this.i = extendedMasterSecret;
            return this;
        }

        public Builder setLocalCertificate(Certificate localCertificate) {
            this.b = localCertificate;
            return this;
        }

        public Builder setMasterSecret(TlsSecret masterSecret) {
            this.c = masterSecret;
            return this;
        }

        public Builder setNegotiatedVersion(ProtocolVersion negotiatedVersion) {
            this.d = negotiatedVersion;
            return this;
        }

        public Builder setPeerCertificate(Certificate peerCertificate) {
            this.e = peerCertificate;
            return this;
        }

        public Builder setPSKIdentity(byte[] pskIdentity) {
            this.f = pskIdentity;
            return this;
        }

        public Builder setSRPIdentity(byte[] srpIdentity) {
            this.g = srpIdentity;
            return this;
        }

        public Builder setServerExtensions(Hashtable serverExtensions) throws IOException {
            if (serverExtensions == null || serverExtensions.isEmpty()) {
                this.h = null;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(byteArrayOutputStream, serverExtensions);
                this.h = byteArrayOutputStream.toByteArray();
            }
            return this;
        }

        private void a(boolean bl, String string) {
            if (!bl) {
                throw new IllegalStateException("Required session parameter '" + string + "' not configured");
            }
        }
    }
}

