/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsSRPIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.tls.crypto.SRP6Group;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] a = Strings.toByteArray("password");
    private static final byte[] b = Strings.toByteArray("salt");
    protected SRP6Group group;
    protected TlsSRP6VerifierGenerator verifierGenerator;
    protected TlsMAC mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(TlsCrypto crypto, SRP6Group group, byte[] seedKey) throws IOException {
        TlsHMAC tlsHMAC = crypto.createHMAC(2);
        tlsHMAC.setKey(seedKey, 0, seedKey.length);
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{group.getN(), group.getG()});
        return new SimulatedTlsSRPIdentityManager(group, crypto.createSRP6VerifierGenerator(tlsSRPConfig), tlsHMAC);
    }

    public SimulatedTlsSRPIdentityManager(SRP6Group group, TlsSRP6VerifierGenerator verifierGenerator, TlsMAC mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(b, 0, b.length);
        this.mac.update(identity, 0, identity.length);
        byte[] byArray = this.mac.calculateMAC();
        this.mac.update(a, 0, a.length);
        this.mac.update(identity, 0, identity.length);
        byte[] byArray2 = this.mac.calculateMAC();
        BigInteger bigInteger = this.verifierGenerator.generateVerifier(byArray, identity, byArray2);
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{this.group.getN(), this.group.getG()});
        return new TlsSRPLoginParameters(identity, tlsSRPConfig, bigInteger, byArray);
    }
}

