/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CertificateVerify;
import com.enterprisedt.bouncycastle.tls.ClientHello;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.HandshakeMessageInput;
import com.enterprisedt.bouncycastle.tls.KeyShareEntry;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.OfferedPsks;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.ServerHello;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContext;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsPSK;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.a;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.j;
import com.enterprisedt.bouncycastle.tls.o;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    o a = null;
    protected Hashtable clientAgreements = null;
    OfferedPsks.a b = null;
    protected ClientHello clientHello = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream input, OutputStream output) {
        super(input, output);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.a = new o(tlsClient.getCrypto());
        tlsClient.init(this.a);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    @Override
    protected void beginHandshake(boolean renegotiation) throws IOException {
        super.beginHandshake(renegotiation);
        this.sendClientHello();
        this.connection_state = 1;
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.clientAgreements = null;
        this.b = null;
        this.clientHello = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.a;
    }

    @Override
    a a() {
        return this.a;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(buf);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(buf, false);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(buf);
                        buf.updateHash(this.e);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(buf);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(buf);
                        buf.updateHash(this.e);
                        this.connection_state = (short)20;
                        byte[] byArray = TlsUtils.a(this.e);
                        this.c.a(false);
                        if (null != this.certificateRequest) {
                            TlsCredentialedSigner tlsCredentialedSigner = TlsUtils.b(this.authentication, this.certificateRequest);
                            Certificate certificate = null;
                            if (null != tlsCredentialedSigner) {
                                certificate = tlsCredentialedSigner.getCertificate();
                            }
                            if (null == certificate) {
                                certificate = Certificate.EMPTY_CHAIN_TLS13;
                            }
                            this.send13CertificateMessage(certificate);
                            this.connection_state = (short)15;
                            if (null != tlsCredentialedSigner) {
                                DigitallySigned digitallySigned = TlsUtils.a((TlsContext)this.a, tlsCredentialedSigner, this.e);
                                this.send13CertificateVerifyMessage(digitallySigned);
                                this.connection_state = (short)17;
                            }
                        }
                        this.send13FinishedMessage();
                        this.connection_state = (short)18;
                        TlsUtils.a((TlsContext)this.a, byArray, this.c);
                        this.c.c();
                        this.c.b(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(buf);
                break;
            }
            case 4: {
                this.receive13NewSessionTicket(buf);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        buf.updateHash(this.e);
                        this.connection_state = (short)4;
                        this.process13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleHandshakeMessage(short type, HandshakeMessageInput buf) throws IOException {
        SecurityParameters securityParameters = this.a.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            if (securityParameters.isResumedSession()) {
                throw new TlsFatalAlert(80);
            }
            this.handle13HandshakeMessage(type, buf);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (securityParameters.isResumedSession() && type != 0) {
            if (type != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(buf);
            buf.updateHash(this.e);
            this.connection_state = (short)20;
            this.sendChangeCipherSpec();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = TlsUtils.a((TlsClientContext)this.a, this.tlsClient, buf, this.serverExtensions);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (securityParameters.getStatusRequestVersion() < 1) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(this.a, buf);
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = this.receiveServerHelloMessage(buf);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.e.notifyPRFDetermined();
                            this.e.sealHashAlgorithms();
                            TlsUtils.b(this.e);
                            buf.updateHash(this.e);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetry();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHello(serverHello);
                        this.e.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            this.e.sealHashAlgorithms();
                        }
                        buf.updateHash(this.e);
                        this.connection_state = (short)4;
                        if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break block0;
                        this.process13ServerHelloCoda(serverHello, false);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(buf));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(buf);
                        this.connection_state = (short)12;
                        TlsCredentials tlsCredentials = null;
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        Certificate certificate = null;
                        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest != null && (tlsCredentials = TlsUtils.a(this.authentication, this.certificateRequest)) != null) {
                            certificate = tlsCredentials.getCertificate();
                            if (tlsCredentials instanceof TlsCredentialedSigner) {
                                tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                signatureAndHashAlgorithm = TlsUtils.a(securityParameters.getNegotiatedVersion(), tlsCredentialedSigner);
                                tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                if (ProtocolVersion.TLSv12.equals(securityParameters.getNegotiatedVersion())) {
                                    TlsUtils.a(securityParameters.getServerSigAlgs(), signatureAndHashAlgorithm, (short)80);
                                    if (tlsStreamSigner == null) {
                                        TlsUtils.a(this.e, signatureAndHashAlgorithm);
                                    }
                                }
                                if (tlsStreamSigner != null) {
                                    this.e.forceBuffering();
                                }
                            }
                        }
                        this.e.sealHashAlgorithms();
                        if (tlsCredentials == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            this.keyExchange.processClientCredentials(tlsCredentials);
                        }
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)14;
                        }
                        if (this.certificateRequest != null) {
                            this.sendCertificateMessage(certificate, null);
                            this.connection_state = (short)15;
                        }
                        this.sendClientKeyExchange();
                        this.connection_state = (short)16;
                        boolean bl = TlsUtils.isSSL(this.a);
                        if (bl) {
                            TlsClientProtocol.establishMasterSecret(this.a, this.keyExchange);
                        }
                        securityParameters.w = TlsUtils.a(this.e);
                        if (!bl) {
                            TlsClientProtocol.establishMasterSecret(this.a, this.keyExchange);
                        }
                        this.c.a(TlsUtils.c(this.a));
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.a(this.a, tlsCredentialedSigner, signatureAndHashAlgorithm, tlsStreamSigner, this.e);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)17;
                        }
                        this.e.stopTracking();
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(buf);
                        TlsClientProtocol.assertEmpty(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        this.receiveCertificateRequest(buf);
                        TlsUtils.a(securityParameters, this.certificateRequest);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        securityParameters.x = TlsUtils.EMPTY_BYTES;
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.receiveNewSessionTicket(buf);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(buf);
                if (!this.b()) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.a(this.a, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector serverSupplementalData) throws IOException {
        this.tlsClient.processServerSupplementalData(serverSupplementalData);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.a((TlsClientContext)this.a, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello helloRetryRequest) throws IOException {
        ProtocolVersion protocolVersion = ProtocolVersion.TLSv12;
        this.c.a(protocolVersion);
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        ProtocolVersion protocolVersion2 = helloRetryRequest.getVersion();
        byte[] byArray = helloRetryRequest.getSessionID();
        int n2 = helloRetryRequest.getCipherSuite();
        if (!(ProtocolVersion.TLSv12.equals(protocolVersion2) && Arrays.areEqual(this.clientHello.getSessionID(), byArray) && TlsUtils.a(this.clientHello.getCipherSuites(), n2))) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = helloRetryRequest.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.a(hashtable, 6, (short)47);
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            Integer n3 = (Integer)object.nextElement();
            if (44 == n3 || null != TlsUtils.getExtensionData(this.clientExtensions, n3)) continue;
            throw new TlsFatalAlert(110);
        }
        object = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == object) {
            throw new TlsFatalAlert(109);
        }
        if (!(ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf((ProtocolVersion)object) && ProtocolVersion.contains(this.a.getClientSupportedVersions(), (ProtocolVersion)object) && TlsUtils.isValidVersionForCipherSuite(n2, (ProtocolVersion)object))) {
            throw new TlsFatalAlert(47);
        }
        if (null != this.b && !Arrays.contains(this.b.b, (short)1)) {
            this.b = null;
            this.tlsClient.notifySelectedPSK(null);
        }
        int n4 = TlsExtensionsUtils.getKeyShareHelloRetryRequest(hashtable);
        if (!TlsUtils.a((ProtocolVersion)object, securityParameters.getClientSupportedGroups(), this.clientAgreements, n4)) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsExtensionsUtils.getCookieExtension(hashtable);
        securityParameters.T = object;
        TlsUtils.c(this.a, this.tlsClient);
        securityParameters.b = false;
        securityParameters.x = TlsUtils.EMPTY_BYTES;
        this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
        TlsUtils.b(securityParameters, n2);
        this.tlsClient.notifySelectedCipherSuite(n2);
        this.clientAgreements = null;
        this.retryCookie = byArray2;
        this.retryGroup = n4;
    }

    protected void process13ServerHello(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = serverHello.getVersion();
        byte[] byArray = serverHello.getSessionID();
        int n2 = serverHello.getCipherSuite();
        if (!ProtocolVersion.TLSv12.equals(protocolVersion) || !Arrays.areEqual(this.clientHello.getSessionID(), byArray)) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = serverHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.a(hashtable, 2, (short)47);
        if (afterHelloRetryRequest) {
            object = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
            if (null == object) {
                throw new TlsFatalAlert(109);
            }
            if (!securityParameters.getNegotiatedVersion().equals((ProtocolVersion)object) || securityParameters.getCipherSuite() != n2) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!TlsUtils.a(this.clientHello.getCipherSuites(), n2) || !TlsUtils.isValidVersionForCipherSuite(n2, securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.b = false;
            securityParameters.x = TlsUtils.EMPTY_BYTES;
            this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
            TlsUtils.b(securityParameters, n2);
            this.tlsClient.notifySelectedCipherSuite(n2);
        }
        this.clientHello = null;
        securityParameters.v = serverHello.getRandom();
        securityParameters.d = false;
        securityParameters.D = true;
        securityParameters.U = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        object = null;
        int n3 = TlsExtensionsUtils.getPreSharedKeyServerHello(hashtable);
        Object object2 = null;
        if (n3 >= 0) {
            if (null == this.b || n3 >= this.b.a.length) {
                throw new TlsFatalAlert(47);
            }
            object2 = this.b.a[n3];
            if (object2.getPRFAlgorithm() != securityParameters.getPRFAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = this.b.c[n3];
            this.selectedPSK13 = true;
        }
        this.tlsClient.notifySelectedPSK((TlsPSK)object2);
        TlsSecret tlsSecret = null;
        object2 = TlsExtensionsUtils.getKeyShareServerHello(hashtable);
        if (null == object2) {
            if (afterHelloRetryRequest || null == object || !Arrays.contains(this.b.b, (short)0)) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (null != object && !Arrays.contains(this.b.b, (short)1)) {
                throw new TlsFatalAlert(47);
            }
            int n4 = ((KeyShareEntry)object2).getNamedGroup();
            TlsAgreement tlsAgreement = (TlsAgreement)this.clientAgreements.get(Integers.valueOf(n4));
            if (null == tlsAgreement) {
                throw new TlsFatalAlert(47);
            }
            tlsAgreement.receivePeerValue(((KeyShareEntry)object2).getKeyExchange());
            tlsSecret = tlsAgreement.calculateSecret();
        }
        this.clientAgreements = null;
        this.b = null;
        TlsUtils.a((TlsContext)this.a, (TlsSecret)object, tlsSecret);
        this.invalidateSession();
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
    }

    protected void process13ServerHelloCoda(ServerHello serverHello, boolean afterHelloRetryRequest) throws IOException {
        byte[] byArray = TlsUtils.a(this.e);
        TlsUtils.b(this.a, byArray, this.c);
        if (!afterHelloRetryRequest) {
            this.c.a(true);
            this.sendChangeCipherSpecMessage();
        }
        this.c.c();
        this.c.b(false);
    }

    protected void processServerHello(ServerHello serverHello) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ProtocolVersion protocolVersion;
        Hashtable hashtable = serverHello.getExtensions();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            protocolVersion = protocolVersion2;
        } else {
            if (!ProtocolVersion.TLSv12.equals(protocolVersion2) || !ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion3)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion3;
        }
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion.equals(securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.contains(this.a.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(70);
            }
            object3 = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
            this.c.a((ProtocolVersion)object3);
            securityParameters.T = protocolVersion;
        }
        TlsUtils.c(this.a, this.tlsClient);
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.process13ServerHello(serverHello, false);
            return;
        }
        object3 = this.clientHello.getCipherSuites();
        this.clientHello = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        securityParameters.v = serverHello.getRandom();
        if (!this.a.getClientVersion().equals(protocolVersion)) {
            TlsUtils.a(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray = serverHello.getSessionID();
        securityParameters.x = byArray;
        this.tlsClient.notifySessionID(byArray);
        boolean bl = securityParameters.b = byArray.length > 0 && this.tlsSession != null && Arrays.areEqual(byArray, this.tlsSession.getSessionID());
        if (securityParameters.isResumedSession() && (serverHello.getCipherSuite() != this.sessionParameters.getCipherSuite() || !securityParameters.getNegotiatedVersion().equals(this.sessionParameters.getNegotiatedVersion()))) {
            throw new TlsFatalAlert(47, "ServerHello parameters do not match resumed session");
        }
        int n2 = serverHello.getCipherSuite();
        if (!TlsUtils.a((int[])object3, n2) || !TlsUtils.isValidVersionForCipherSuite(n2, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47, "ServerHello selected invalid cipher suite");
        }
        TlsUtils.b(securityParameters, n2);
        this.tlsClient.notifySelectedCipherSuite(n2);
        this.serverExtensions = hashtable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (Integer)enumeration.nextElement();
                if (((Integer)object2).equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, (Integer)object2)) {
                    throw new TlsFatalAlert(110);
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        byte[] byArray2 = TlsUtils.getExtensionData(hashtable, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (byArray2 == null) {
                throw new TlsFatalAlert(40);
            }
            object2 = this.a.getSecurityParametersConnection();
            object = TlsUtils.a(((SecurityParameters)object2).getLocalVerifyData(), ((SecurityParameters)object2).getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual(byArray2, TlsClientProtocol.createRenegotiationInfo(object))) {
                throw new TlsFatalAlert(40);
            }
        } else if (byArray2 == null) {
            securityParameters.d = false;
        } else {
            securityParameters.d = true;
            if (!Arrays.constantTimeAreEqual(byArray2, TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl2 = false;
        if (TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.clientExtensions)) {
            bl2 = TlsExtensionsUtils.hasExtendedMasterSecretExtension(hashtable);
            if (TlsUtils.a(protocolVersion)) {
                if (!bl2 && this.tlsClient.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40, "Extended Master Secret extension is required");
                }
            } else if (bl2) {
                throw new TlsFatalAlert(47, "Server sent an unexpected extended_master_secret extension negotiating " + protocolVersion);
            }
        }
        securityParameters.D = bl2;
        if (securityParameters.isResumedSession() && securityParameters.isExtendedMasterSecret() != this.sessionParameters.isExtendedMasterSecret()) {
            throw new TlsFatalAlert(40, "Server resumed session with mismatched extended_master_secret negotiation");
        }
        securityParameters.G = TlsExtensionsUtils.getALPNExtensionServer(hashtable);
        securityParameters.H = true;
        Hashtable hashtable2 = this.clientExtensions;
        object = hashtable;
        if (securityParameters.isResumedSession()) {
            hashtable2 = null;
            object = this.sessionParameters.readServerExtensions();
        }
        if (object != null && !object.isEmpty()) {
            boolean bl3 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)object);
            if (bl3 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.C = bl3;
            securityParameters.f = TlsUtils.a(hashtable2, (Hashtable)object, (short)47);
            securityParameters.F = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)object);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.U = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.U = 1;
                }
                securityParameters.V = TlsUtils.b(hashtable2, (Hashtable)object, (short)47);
                securityParameters.W = TlsUtils.d(hashtable2, (Hashtable)object, (short)47);
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (hashtable2 != null) {
            this.tlsClient.processServerExtensions((Hashtable)object);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        if (securityParameters.isResumedSession()) {
            securityParameters.r = this.sessionMasterSecret;
            this.c.a(TlsUtils.c(this.a));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream buf, boolean postHandshakeAuth) throws IOException {
        if (postHandshakeAuth) {
            throw new TlsFatalAlert(80);
        }
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.a, buf);
        TlsClientProtocol.assertEmpty(buf);
        if (!certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
            throw new TlsFatalAlert(47);
        }
        this.certificateRequest = certificateRequest;
        TlsUtils.a(this.a.getSecurityParametersHandshake(), certificateRequest);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream buf) throws IOException {
        Object object;
        byte[] byArray = TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.serverExtensions = TlsClientProtocol.readExtensionsData13(8, byArray);
        Object object2 = this.serverExtensions.keys();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            if (null != TlsUtils.getExtensionData(this.clientExtensions, (Integer)object)) continue;
            throw new TlsFatalAlert(110);
        }
        object2 = this.a.getSecurityParametersHandshake();
        object = ((SecurityParameters)object2).getNegotiatedVersion();
        ((SecurityParameters)object2).G = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        ((SecurityParameters)object2).H = true;
        Hashtable hashtable = this.clientExtensions;
        Hashtable hashtable2 = this.serverExtensions;
        if (((SecurityParameters)object2).isResumedSession()) {
            hashtable = null;
            hashtable2 = this.sessionParameters.readServerExtensions();
        }
        ((SecurityParameters)object2).f = TlsUtils.a(hashtable, hashtable2, (short)47);
        ((SecurityParameters)object2).C = false;
        ((SecurityParameters)object2).F = false;
        if (!((SecurityParameters)object2).isResumedSession()) {
            ((SecurityParameters)object2).U = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
            ((SecurityParameters)object2).V = TlsUtils.c(hashtable, hashtable2, (short)47);
            ((SecurityParameters)object2).W = TlsUtils.e(hashtable, hashtable2, (short)47);
        }
        this.expectSessionTicket = false;
        if (null != hashtable) {
            this.tlsClient.processServerExtensions(this.serverExtensions);
        }
        this.applyMaxFragmentLengthExtension(((SecurityParameters)object2).getMaxFragmentLength());
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream buf) throws IOException {
        if (!this.b()) {
            throw new TlsFatalAlert(10);
        }
        TlsUtils.readUint32(buf);
        TlsUtils.readUint32(buf);
        TlsUtils.readOpaque8(buf);
        TlsUtils.readOpaque16(buf);
        TlsUtils.readOpaque16(buf);
        TlsClientProtocol.assertEmpty(buf);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream buf) throws IOException {
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.b(this.a, this.tlsClient, buf, this.serverExtensions);
        this.handleServerCertificate();
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream buf) throws IOException {
        Certificate certificate = this.a.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        CertificateVerify certificateVerify = CertificateVerify.parse(this.a, buf);
        TlsClientProtocol.assertEmpty(buf);
        TlsUtils.a((TlsClientContext)this.a, this.e, certificateVerify);
    }

    protected void receive13ServerFinished(ByteArrayInputStream buf) throws IOException {
        this.process13FinishedMessage(buf);
    }

    protected void receiveCertificateRequest(ByteArrayInputStream buf) throws IOException {
        if (null == this.authentication) {
            throw new TlsFatalAlert(40);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.a, buf);
        TlsClientProtocol.assertEmpty(buf);
        this.certificateRequest = TlsUtils.a(certificateRequest, this.keyExchange);
    }

    protected void receiveNewSessionTicket(ByteArrayInputStream buf) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsClientProtocol.assertEmpty(buf);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream buf) throws IOException {
        return ServerHello.parse(buf);
    }

    protected void send13ClientHelloRetry() throws IOException {
        Hashtable hashtable = this.clientHello.getExtensions();
        hashtable.remove(TlsExtensionsUtils.EXT_cookie);
        hashtable.remove(TlsExtensionsUtils.EXT_early_data);
        hashtable.remove(TlsExtensionsUtils.EXT_key_share);
        hashtable.remove(TlsExtensionsUtils.EXT_pre_shared_key);
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(hashtable, this.retryCookie);
            this.retryCookie = null;
        }
        if (null != this.b) {
            this.b = TlsUtils.a((TlsClientContext)this.a, this.b, hashtable);
            if (null == this.b) {
                this.tlsClient.notifySelectedPSK(null);
            }
        }
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        this.clientAgreements = TlsUtils.a((TlsClientContext)this.a, hashtable, this.retryGroup);
        this.c.a(true);
        this.sendChangeCipherSpecMessage();
        this.sendClientHelloMessage();
    }

    protected void sendCertificateVerifyMessage(DigitallySigned certificateVerify) throws IOException {
        j j2 = new j(15);
        certificateVerify.encode(j2);
        j2.a(this);
    }

    protected void sendClientHello() throws IOException {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2;
        ProtocolVersion[] protocolVersionArray;
        SecurityParameters securityParameters = this.a.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            ProtocolVersion protocolVersion3 = this.a.getClientVersion();
            protocolVersionArray = protocolVersion3.only();
            protocolVersion2 = protocolVersion3;
            protocolVersion = protocolVersion3;
        } else {
            protocolVersionArray = this.tlsClient.getProtocolVersions();
            if (ProtocolVersion.contains(protocolVersionArray, ProtocolVersion.SSLv3)) {
                this.c.a(ProtocolVersion.SSLv3);
            } else {
                this.c.a(ProtocolVersion.TLSv10);
            }
            protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
            protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
            if (!ProtocolVersion.c(protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            this.a.a(protocolVersion);
        }
        this.a.a(protocolVersionArray);
        boolean bl = ProtocolVersion.TLSv12.isEqualOrLaterVersionOf(protocolVersion2);
        boolean bl2 = ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion);
        boolean bl3 = !bl2 && this.tlsClient.shouldUseGMTUnixTime();
        securityParameters.u = TlsClientProtocol.createRandomBlock(bl3, this.a);
        TlsSession tlsSession = bl ? this.tlsClient.getSessionToResume() : null;
        boolean bl4 = this.tlsClient.isFallback();
        int[] nArray = this.tlsClient.getCipherSuites();
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        boolean bl5 = this.tlsClient.shouldUseExtendedMasterSecret();
        this.establishSession(tlsSession);
        byte[] byArray = TlsUtils.a(this.tlsSession);
        if (byArray.length > 0 && !Arrays.contains(nArray, this.sessionParameters.getCipherSuite())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        ProtocolVersion protocolVersion4 = null;
        if (byArray.length > 0 && !ProtocolVersion.contains(protocolVersionArray, protocolVersion4 = this.sessionParameters.getNegotiatedVersion())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        if (byArray.length > 0 && TlsUtils.a(protocolVersion4)) {
            if (bl5) {
                if (!this.sessionParameters.isExtendedMasterSecret() && !this.tlsClient.allowLegacyResumption()) {
                    byArray = TlsUtils.EMPTY_BYTES;
                }
            } else if (this.sessionParameters.isExtendedMasterSecret()) {
                byArray = TlsUtils.EMPTY_BYTES;
            }
        }
        if (byArray.length < 1) {
            this.cancelSession();
        }
        this.tlsClient.notifySessionToResume(this.tlsSession);
        ProtocolVersion protocolVersion5 = protocolVersion;
        if (bl2) {
            protocolVersion5 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, protocolVersionArray);
            if (byArray.length < 1 && this.tlsClient.shouldUseCompatibilityMode()) {
                byArray = this.a.getNonceGenerator().generateNonce(32);
            }
        }
        this.a.b(protocolVersion5);
        securityParameters.J = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            TlsUtils.a(securityParameters, this.clientExtensions);
        }
        securityParameters.M = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.b = TlsUtils.a((TlsClientContext)this.a, this.tlsClient, this.clientExtensions, nArray);
        this.clientAgreements = TlsUtils.a((TlsClientContext)this.a, this.tlsClient, this.clientExtensions);
        if (bl5 && TlsUtils.a(protocolVersionArray)) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else {
            this.clientExtensions.remove(TlsExtensionsUtils.EXT_extended_master_secret);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters securityParameters2 = this.a.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(securityParameters2.getLocalVerifyData()));
        } else {
            boolean bl6;
            boolean bl7 = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl8 = bl6 = !Arrays.contains(nArray, 255);
            if (bl7 && bl6) {
                nArray = Arrays.append(nArray, 255);
            }
        }
        if (bl4 && !Arrays.contains(nArray, 22016)) {
            nArray = Arrays.append(nArray, 22016);
        }
        int n2 = null == this.b ? 0 : this.b.d;
        this.clientHello = new ClientHello(protocolVersion5, securityParameters.getClientRandom(), byArray, null, nArray, this.clientExtensions, n2);
        this.sendClientHelloMessage();
    }

    protected void sendClientHelloMessage() throws IOException {
        j j2 = new j(1);
        this.clientHello.encode(this.a, j2);
        j2.a(this.e, this.clientHello.getBindersSize());
        if (null != this.b) {
            OfferedPsks.a(j2, this.a.getCrypto(), this.e, this.b);
        }
        j2.a(this, this.e, this.clientHello.getBindersSize());
    }

    protected void sendClientKeyExchange() throws IOException {
        j j2 = new j(16);
        this.keyExchange.generateClientKeyExchange(j2);
        j2.a(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        this.certificateRequest = null;
    }

    protected void skip13ServerCertificate() throws IOException {
        if (!this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.a(this.a);
    }
}

