/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsDHGroupVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.DHStandardGroups;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class TlsDHUtils {
    public static TlsDHConfig createNamedDHConfig(TlsContext context, int namedGroup) {
        if (namedGroup < 0 || NamedGroup.getFiniteFieldBits(namedGroup) < 1) {
            return null;
        }
        boolean bl = TlsUtils.isTLSv13(context);
        return new TlsDHConfig(namedGroup, bl);
    }

    public static DHGroup getDHGroup(TlsDHConfig dhConfig) {
        int n2 = dhConfig.getNamedGroup();
        if (n2 >= 0) {
            return TlsDHUtils.getNamedDHGroup(n2);
        }
        return dhConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static int getMinimumFiniteFieldBits(int cipherSuite) {
        return TlsDHUtils.isDHCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isDHCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static int getNamedGroupForDHParameters(BigInteger p2, BigInteger g2) {
        int[] nArray = new int[]{256, 257, 258, 259, 260};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            DHGroup dHGroup = TlsDHUtils.getNamedDHGroup(n2);
            if (dHGroup == null || !dHGroup.getP().equals(p2) || !dHGroup.getG().equals(g2)) continue;
            return n2;
        }
        return -1;
    }

    public static DHGroup getStandardGroupForDHParameters(BigInteger p2, BigInteger g2) {
        DHGroup[] dHGroupArray = new DHGroup[]{DHStandardGroups.rfc7919_ffdhe2048, DHStandardGroups.rfc7919_ffdhe3072, DHStandardGroups.rfc7919_ffdhe4096, DHStandardGroups.rfc7919_ffdhe6144, DHStandardGroups.rfc7919_ffdhe8192, DHStandardGroups.rfc3526_1536, DHStandardGroups.rfc3526_2048, DHStandardGroups.rfc3526_3072, DHStandardGroups.rfc3526_4096, DHStandardGroups.rfc3526_6144, DHStandardGroups.rfc3526_8192, DHStandardGroups.rfc5996_768, DHStandardGroups.rfc5996_1024};
        for (int i2 = 0; i2 < dHGroupArray.length; ++i2) {
            DHGroup dHGroup = dHGroupArray[i2];
            if (dHGroup == null || !dHGroup.getP().equals(p2) || !dHGroup.getG().equals(g2)) continue;
            return dHGroup;
        }
        return null;
    }

    public static TlsDHConfig receiveDHConfig(TlsContext context, TlsDHGroupVerifier dhGroupVerifier, InputStream input) throws IOException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(input);
        int n2 = TlsDHUtils.getNamedGroupForDHParameters(bigInteger2, bigInteger = TlsDHUtils.readDHParameter(input));
        if (n2 < 0) {
            DHGroup dHGroup = TlsDHUtils.getStandardGroupForDHParameters(bigInteger2, bigInteger);
            if (null == dHGroup) {
                dHGroup = new DHGroup(bigInteger2, null, bigInteger, 0);
            }
            if (!dhGroupVerifier.accept(dHGroup)) {
                throw new TlsFatalAlert(71);
            }
            return new TlsDHConfig(dHGroup);
        }
        int[] nArray = context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (null == nArray || Arrays.contains(nArray, n2)) {
            return new TlsDHConfig(n2, false);
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input, 1));
    }

    public static void writeDHConfig(TlsDHConfig dhConfig, OutputStream output) throws IOException {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(dhConfig);
        TlsDHUtils.writeDHParameter(dHGroup.getP(), output);
        TlsDHUtils.writeDHParameter(dHGroup.getG(), output);
    }

    public static void writeDHParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x), output);
    }
}

