/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.ServerSRPParams;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsSRPIdentity;
import com.enterprisedt.bouncycastle.tls.TlsSRPLoginParameters;
import com.enterprisedt.bouncycastle.tls.TlsSRPUtils;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Client;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Server;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSRPIdentity srpIdentity;
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected TlsCertificate serverCertificate = null;
    protected byte[] srpSalt = null;
    protected TlsSRP6Client srpClient = null;
    protected TlsSRPLoginParameters srpLoginParameters;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsSRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;

    private static int a(int n2) {
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int keyExchange, TlsSRPIdentity srpIdentity, TlsSRPConfigVerifier srpConfigVerifier) {
        super(TlsSRPKeyExchange.a(keyExchange));
        this.srpIdentity = srpIdentity;
        this.srpConfigVerifier = srpConfigVerifier;
    }

    public TlsSRPKeyExchange(int keyExchange, TlsSRPLoginParameters srpLoginParameters) {
        super(TlsSRPKeyExchange.a(keyExchange));
        this.srpLoginParameters = srpLoginParameters;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 21) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = TlsUtils.c(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        TlsSRPConfig tlsSRPConfig = this.srpLoginParameters.getConfig();
        this.srpServer = this.context.getCrypto().createSRP6Server(tlsSRPConfig, this.srpLoginParameters.getVerifier());
        BigInteger bigInteger = this.srpServer.generateServerCredentials();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        ServerSRPParams serverSRPParams = new ServerSRPParams(bigIntegerArray[0], bigIntegerArray[1], this.srpLoginParameters.getSalt(), bigInteger);
        i i2 = new i();
        serverSRPParams.encode(i2);
        if (this.serverCredentials != null) {
            TlsUtils.a(this.context, this.serverCredentials, null, i2);
        }
        return i2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        i i2 = null;
        InputStream inputStream = input;
        if (this.keyExchange != 21) {
            i2 = new i();
            inputStream = new TeeInputStream(input, i2);
        }
        ServerSRPParams serverSRPParams = ServerSRPParams.parse(inputStream);
        if (i2 != null) {
            TlsUtils.a(this.context, input, this.serverCertificate, null, i2);
        }
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{serverSRPParams.getN(), serverSRPParams.getG()});
        if (!this.srpConfigVerifier.accept(tlsSRPConfig)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = serverSRPParams.getS();
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(serverSRPParams.getN(), serverSRPParams.getB());
        this.srpClient = this.context.getCrypto().createSRP6Client(tlsSRPConfig);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] byArray = this.srpIdentity.getSRPIdentity();
        byte[] byArray2 = this.srpIdentity.getSRPPassword();
        BigInteger bigInteger = this.srpClient.generateClientCredentials(this.srpSalt, byArray, byArray2);
        TlsSRPUtils.writeSRPParameter(bigInteger, output);
        this.context.getSecurityParametersHandshake().z = Arrays.clone(byArray);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(this.srpLoginParameters.getConfig().getExplicitNG()[0], TlsSRPUtils.readSRPParameter(input));
        this.context.getSecurityParametersHandshake().z = Arrays.clone(this.srpLoginParameters.getIdentity());
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        BigInteger bigInteger = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
        return this.context.getCrypto().createSecret(BigIntegers.asUnsignedByteArray(bigInteger));
    }

    protected static BigInteger validatePublicValue(BigInteger N, BigInteger val) throws IOException {
        if ((val = val.mod(N)).equals(BigInteger.ZERO)) {
            throw new TlsFatalAlert(47);
        }
        return val;
    }
}

