/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ASN1InputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.enterprisedt.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CertificateType;
import com.enterprisedt.bouncycastle.tls.CertificateVerify;
import com.enterprisedt.bouncycastle.tls.CipherSuite;
import com.enterprisedt.bouncycastle.tls.CombinedHash;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.ExtensionType;
import com.enterprisedt.bouncycastle.tls.HandshakeMessageInput;
import com.enterprisedt.bouncycastle.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.tls.KeyExchangeAlgorithm;
import com.enterprisedt.bouncycastle.tls.KeyShareEntry;
import com.enterprisedt.bouncycastle.tls.MaxFragmentLength;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.OfferedPsks;
import com.enterprisedt.bouncycastle.tls.PRFAlgorithm;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.PskIdentity;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.SignatureAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContext;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedAgreement;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.TlsPSK;
import com.enterprisedt.bouncycastle.tls.TlsPSKExternal;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsServer;
import com.enterprisedt.bouncycastle.tls.TlsServerContext;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.crypto.Tls13Verifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsEncryptor;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHashOutputStream;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.tls.l;
import com.enterprisedt.bouncycastle.tls.m;
import com.enterprisedt.bouncycastle.tls.r;
import com.enterprisedt.bouncycastle.tls.t;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Shorts;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    private static byte[] a = Hex.decodeStrict("444F574E47524400");
    private static byte[] b = Hex.decodeStrict("444F574E47524401");
    private static final Hashtable c = TlsUtils.a();
    private static final Vector d = TlsUtils.b();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final String[] EMPTY_STRINGS = new String[0];

    private static void a(Hashtable hashtable, ASN1ObjectIdentifier aSN1ObjectIdentifier, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        hashtable.put(aSN1ObjectIdentifier.getId(), signatureAndHashAlgorithm);
    }

    private static void a(Hashtable hashtable, ASN1ObjectIdentifier aSN1ObjectIdentifier, short s2, short s3) {
        TlsUtils.a(hashtable, aSN1ObjectIdentifier, SignatureAndHashAlgorithm.getInstance(s2, s3));
    }

    private static Hashtable a() {
        Hashtable hashtable = new Hashtable();
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha224, (short)3, (short)2);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha256, (short)4, (short)2);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha384, (short)5, (short)2);
        TlsUtils.a(hashtable, NISTObjectIdentifiers.dsa_with_sha512, (short)6, (short)2);
        TlsUtils.a(hashtable, OIWObjectIdentifiers.dsaWithSHA1, (short)2, (short)2);
        TlsUtils.a(hashtable, OIWObjectIdentifiers.sha1WithRSA, (short)2, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5, (short)1);
        TlsUtils.a(hashtable, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6, (short)1);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6, (short)3);
        TlsUtils.a(hashtable, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2, (short)2);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6, (short)3);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2, (short)1);
        TlsUtils.a(hashtable, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4, (short)1);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2, (short)3);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3, (short)3);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4, (short)3);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5, (short)3);
        TlsUtils.a(hashtable, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6, (short)3);
        TlsUtils.a(hashtable, EdECObjectIdentifiers.id_Ed25519, SignatureAndHashAlgorithm.ed25519);
        TlsUtils.a(hashtable, EdECObjectIdentifiers.id_Ed448, SignatureAndHashAlgorithm.ed448);
        TlsUtils.a(hashtable, RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, SignatureAndHashAlgorithm.gostr34102012_256);
        TlsUtils.a(hashtable, RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, SignatureAndHashAlgorithm.gostr34102012_512);
        return hashtable;
    }

    private static Vector b() {
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>();
        vector.addElement(SignatureAndHashAlgorithm.ed25519);
        vector.addElement(SignatureAndHashAlgorithm.ed448);
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)3));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)3));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)3));
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha256);
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha384);
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha512);
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha256);
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha384);
        vector.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha512);
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)1));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)1));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)1));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)2));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)2));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)2));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)3));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)1));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)2));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)3));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)1));
        vector.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)2));
        return vector;
    }

    public static void checkUint8(short i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i2) throws IOException {
        if (!TlsUtils.isValidUint8(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i2) throws IOException {
        if (!TlsUtils.isValidUint16(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i2) throws IOException {
        if (!TlsUtils.isValidUint24(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i2) throws IOException {
        if (!TlsUtils.isValidUint32(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i2) throws IOException {
        if (!TlsUtils.isValidUint48(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i2) throws IOException {
        if (!TlsUtils.isValidUint64(i2)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(int i2) {
        return (i2 & 0xFF) == i2;
    }

    public static boolean isValidUint8(long i2) {
        return (i2 & 0xFFL) == i2;
    }

    public static boolean isValidUint16(int i2) {
        return (i2 & 0xFFFF) == i2;
    }

    public static boolean isValidUint16(long i2) {
        return (i2 & 0xFFFFL) == i2;
    }

    public static boolean isValidUint24(int i2) {
        return (i2 & 0xFFFFFF) == i2;
    }

    public static boolean isValidUint24(long i2) {
        return (i2 & 0xFFFFFFL) == i2;
    }

    public static boolean isValidUint32(long i2) {
        return (i2 & 0xFFFFFFFFL) == i2;
    }

    public static boolean isValidUint48(long i2) {
        return (i2 & 0xFFFFFFFFFFFFL) == i2;
    }

    public static boolean isValidUint64(long i2) {
        return true;
    }

    public static boolean isSSL(TlsContext context) {
        return context.getServerVersion().isSSL();
    }

    public static boolean isTLSv10(ProtocolVersion version) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsContext context) {
        return TlsUtils.isTLSv10(context.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext context) {
        return TlsUtils.isTLSv11(context.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return TlsUtils.isTLSv12(context.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion version) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsContext context) {
        return TlsUtils.isTLSv13(context.getServerVersion());
    }

    public static void writeUint8(short i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(int i2, OutputStream output) throws IOException {
        output.write(i2);
    }

    public static void writeUint8(short i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint8(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)i2;
    }

    public static void writeUint16(int i2, OutputStream output) throws IOException {
        output.write(i2 >>> 8);
        output.write(i2);
    }

    public static void writeUint16(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 8);
        buf[offset + 1] = (byte)i2;
    }

    public static void writeUint24(int i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint24(int i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 16);
        buf[offset + 1] = (byte)(i2 >>> 8);
        buf[offset + 2] = (byte)i2;
    }

    public static void writeUint32(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint32(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 24);
        buf[offset + 1] = (byte)(i2 >>> 16);
        buf[offset + 2] = (byte)(i2 >>> 8);
        buf[offset + 3] = (byte)i2;
    }

    public static void writeUint48(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint48(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 40);
        buf[offset + 1] = (byte)(i2 >>> 32);
        buf[offset + 2] = (byte)(i2 >>> 24);
        buf[offset + 3] = (byte)(i2 >>> 16);
        buf[offset + 4] = (byte)(i2 >>> 8);
        buf[offset + 5] = (byte)i2;
    }

    public static void writeUint64(long i2, OutputStream output) throws IOException {
        output.write((byte)(i2 >>> 56));
        output.write((byte)(i2 >>> 48));
        output.write((byte)(i2 >>> 40));
        output.write((byte)(i2 >>> 32));
        output.write((byte)(i2 >>> 24));
        output.write((byte)(i2 >>> 16));
        output.write((byte)(i2 >>> 8));
        output.write((byte)i2);
    }

    public static void writeUint64(long i2, byte[] buf, int offset) {
        buf[offset] = (byte)(i2 >>> 56);
        buf[offset + 1] = (byte)(i2 >>> 48);
        buf[offset + 2] = (byte)(i2 >>> 40);
        buf[offset + 3] = (byte)(i2 >>> 32);
        buf[offset + 4] = (byte)(i2 >>> 24);
        buf[offset + 5] = (byte)(i2 >>> 16);
        buf[offset + 6] = (byte)(i2 >>> 8);
        buf[offset + 7] = (byte)i2;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque8(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint8(data.length);
        TlsUtils.writeUint8(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 1, data.length);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint16(data.length);
        TlsUtils.writeUint16(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 2, data.length);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint24(data.length);
        TlsUtils.writeUint24(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 3, data.length);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], output);
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint8(uints[i2], buf, offset);
            ++offset;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], output);
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        for (int i2 = 0; i2 < uints.length; ++i2) {
            TlsUtils.writeUint16(uints[i2], buf, offset);
            offset += 2;
        }
    }

    public static void writeUint16ArrayWithUint8Length(int[] uints, byte[] buf, int offset) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint8(n2);
        TlsUtils.writeUint8(n2, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 1);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int n2 = 2 * uints.length;
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static byte[] decodeOpaque8(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque8(buf, 0);
    }

    public static byte[] decodeOpaque8(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 1) {
            throw new TlsFatalAlert(50);
        }
        short s2 = TlsUtils.readUint8(buf, 0);
        if (buf.length != s2 + 1 || s2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.copyOfRangeExact(buf, 1, buf.length);
    }

    public static byte[] decodeOpaque16(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque16(buf, 0);
    }

    public static byte[] decodeOpaque16(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 2) {
            throw new TlsFatalAlert(50);
        }
        int n2 = TlsUtils.readUint16(buf, 0);
        if (buf.length != n2 + 2 || n2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.copyOfRangeExact(buf, 2, buf.length);
    }

    public static short decodeUint8(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(buf, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 1) {
            throw new TlsFatalAlert(50);
        }
        int n2 = TlsUtils.readUint8(buf, 0);
        if (buf.length != n2 + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(buf, i2 + 1);
        }
        return sArray;
    }

    public static int decodeUint16(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint16(buf, 0);
    }

    public static int[] decodeUint16ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        short s2 = TlsUtils.readUint8(buf, 0);
        if (buf.length != s2 + 1 || (s2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n2 = s2 / 2;
        int n3 = 1;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = TlsUtils.readUint16(buf, n3);
            n3 += 2;
        }
        return nArray;
    }

    public static long decodeUint32(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 4) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint32(buf, 0);
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeOpaque16(byte[] buf) throws IOException {
        TlsUtils.checkUint16(buf.length);
        byte[] byArray = new byte[2 + buf.length];
        TlsUtils.writeUint16(buf.length, byArray, 0);
        System.arraycopy(buf, 0, byArray, 2, buf.length);
        return byArray;
    }

    public static byte[] encodeOpaque24(byte[] buf) throws IOException {
        TlsUtils.checkUint24(buf.length);
        byte[] byArray = new byte[3 + buf.length];
        TlsUtils.writeUint24(buf.length, byArray, 0);
        System.arraycopy(buf, 0, byArray, 3, buf.length);
        return byArray;
    }

    public static byte[] encodeUint8(short uint) throws IOException {
        TlsUtils.checkUint8(uint);
        byte[] byArray = new byte[1];
        TlsUtils.writeUint8(uint, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] byArray = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16(int uint) throws IOException {
        TlsUtils.checkUint16(uint);
        byte[] byArray = new byte[2];
        TlsUtils.writeUint16(uint, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint8Length(int[] uints) throws IOException {
        int n2 = 2 * uints.length;
        byte[] byArray = new byte[1 + n2];
        TlsUtils.writeUint16ArrayWithUint8Length(uints, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int n2 = 2 * uints.length;
        byte[] byArray = new byte[2 + n2];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint24(int uint) throws IOException {
        TlsUtils.checkUint24(uint);
        byte[] byArray = new byte[3];
        TlsUtils.writeUint24(uint, byArray, 0);
        return byArray;
    }

    public static byte[] encodeUint32(long uint) throws IOException {
        TlsUtils.checkUint32(uint);
        byte[] byArray = new byte[4];
        TlsUtils.writeUint32(uint, byArray, 0);
        return byArray;
    }

    public static byte[] encodeVersion(ProtocolVersion version) throws IOException {
        return new byte[]{(byte)version.getMajorVersion(), (byte)version.getMinorVersion()};
    }

    public static int readInt32(byte[] buf, int offset) {
        int n2 = buf[offset] << 24;
        n2 |= (buf[++offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static short readUint8(InputStream input) throws IOException {
        int n2 = input.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)n2;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return n2 |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        int n4 = input.read();
        int n5 = input.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (long)(n2 << 24 | n3 << 16 | n4 << 8 | n5) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n2 = (buf[offset] & 0xFF) << 24;
        n2 |= (buf[++offset] & 0xFF) << 16;
        n2 |= (buf[++offset] & 0xFF) << 8;
        return (long)(n2 |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        int n3 = TlsUtils.readUint24(input);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int n2 = TlsUtils.readUint24(buf, offset);
        int n3 = TlsUtils.readUint24(buf, offset + 3);
        return ((long)n2 & 0xFFFFFFFFL) << 24 | (long)n3 & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        int n2 = Streams.readFully(input, byArray);
        if (n2 == 0) {
            return null;
        }
        if (n2 != length) {
            throw new EOFException();
        }
        return byArray;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[length];
        if (length != Streams.readFully(input, byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int n2 = buf.length;
        if (n2 > 0 && n2 != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        return TlsUtils.readFully(s2, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (s2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(s2, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength, int maxLength) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (s2 < minLength || maxLength < s2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(s2, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        return TlsUtils.readFully(n2, input);
    }

    public static byte[] readOpaque16(InputStream input, int minLength) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        if (n2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(n2, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        return TlsUtils.readFully(n2, input);
    }

    public static byte[] readOpaque24(InputStream input, int minLength) throws IOException {
        int n2 = TlsUtils.readUint24(input);
        if (n2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(n2, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] sArray = new short[count];
        for (int i2 = 0; i2 < count; ++i2) {
            sArray[i2] = TlsUtils.readUint8(input);
        }
        return sArray;
    }

    public static short[] readUint8ArrayWithUint8Length(InputStream input, int minLength) throws IOException {
        short s2 = TlsUtils.readUint8(input);
        if (s2 < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8Array(s2, input);
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] nArray = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            nArray[i2] = TlsUtils.readUint16(input);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int n2 = input.read();
        int n3 = input.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(n2, n3);
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(encoding);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (null == aSN1Primitive) {
            throw new TlsFatalAlert(50);
        }
        if (null != aSN1InputStream.readObject()) {
            throw new TlsFatalAlert(50);
        }
        return aSN1Primitive;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(encoding);
        TlsUtils.requireDEREncoding(aSN1Primitive, encoding);
        return aSN1Primitive;
    }

    public static void requireDEREncoding(ASN1Object asn1, byte[] encoding) throws IOException {
        byte[] byArray = asn1.getEncoded("DER");
        if (!Arrays.areEqual(byArray, encoding)) {
            throw new TlsFatalAlert(50);
        }
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(n2 >>> 24);
        buf[offset + 1] = (byte)(n2 >>> 16);
        buf[offset + 2] = (byte)(n2 >>> 8);
        buf[offset + 3] = (byte)n2;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static void addIfSupported(Vector supportedAlgs, TlsCrypto crypto, SignatureAndHashAlgorithm alg) {
        if (crypto.hasSignatureAndHashAlgorithm(alg)) {
            supportedAlgs.addElement(alg);
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int namedGroup) {
        if (crypto.hasNamedGroup(namedGroup)) {
            supportedGroups.addElement(Integers.valueOf(namedGroup));
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int[] namedGroups) {
        for (int i2 = 0; i2 < namedGroups.length; ++i2) {
            TlsUtils.addIfSupported(supportedGroups, crypto, namedGroups[i2]);
        }
    }

    public static boolean addToSet(Vector s2, int i2) {
        boolean bl;
        boolean bl2 = bl = !s2.contains(Integers.valueOf(i2));
        if (bl) {
            s2.add(Integers.valueOf(i2));
        }
        return bl;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)2);
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)3);
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)1);
    }

    public static SignatureAndHashAlgorithm getDefaultSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: {
                return SignatureAndHashAlgorithm.getInstance((short)2, signatureAlgorithm);
            }
        }
        return null;
    }

    public static Vector getDefaultSignatureAlgorithms(short signatureAlgorithm) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getDefaultSignatureAlgorithm(signatureAlgorithm);
        return null == signatureAndHashAlgorithm ? new Vector() : TlsUtils.vectorOfOne(signatureAndHashAlgorithm);
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext context) {
        return TlsUtils.getSupportedSignatureAlgorithms(context, d);
    }

    public static Vector getSupportedSignatureAlgorithms(TlsContext context, Vector candidates) {
        TlsCrypto tlsCrypto = context.getCrypto();
        int n2 = candidates.size();
        Vector vector = new Vector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            TlsUtils.addIfSupported(vector, tlsCrypto, (SignatureAndHashAlgorithm)candidates.elementAt(i2));
        }
        return vector;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsCredentialedSigner signerCredentials) throws IOException {
        return TlsUtils.a(context.getServerVersion(), signerCredentials);
    }

    static SignatureAndHashAlgorithm a(ProtocolVersion protocolVersion, TlsCredentialedSigner tlsCredentialedSigner) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion) && (signatureAndHashAlgorithm = tlsCredentialedSigner.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, extensionType);
        if (byArray == null) {
            return false;
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new t(sessionID, sessionParameters);
    }

    static boolean a(ProtocolVersion protocolVersion) {
        ProtocolVersion protocolVersion2 = protocolVersion.getEquivalentTLSVersion();
        return ProtocolVersion.TLSv12.equals(protocolVersion2) || ProtocolVersion.TLSv11.equals(protocolVersion2) || ProtocolVersion.TLSv10.equals(protocolVersion2);
    }

    static boolean a(ProtocolVersion[] protocolVersionArray) {
        if (protocolVersionArray != null) {
            for (int i2 = 0; i2 < protocolVersionArray.length; ++i2) {
                if (!TlsUtils.a(protocolVersionArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNullOrContainsNull(Object[] array) {
        if (null == array) {
            return true;
        }
        int n2 = array.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (null != array[i2]) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(byte[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(short[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(int[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return null == array || array.length < 1;
    }

    public static boolean isNullOrEmpty(String s2) {
        return null == s2 || s2.length() < 1;
    }

    public static boolean isNullOrEmpty(Vector v2) {
        return null == v2 || v2.isEmpty();
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion version) {
        return null != version && ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static short getLegacyClientCertType(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 64;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClientCert(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: 
            case 4: {
                return 2;
            }
            case 64: 
            case 66: {
                return 3;
            }
            case 1: 
            case 3: 
            case 65: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServer(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 3: 
            case 22: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 5: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServerCert(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 3: 
            case 7: 
            case 22: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static Vector getLegacySupportedSignatureAlgorithms() {
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(3);
        vector.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)2));
        vector.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)3));
        vector.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)1));
        return vector;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int n2 = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, output);
        for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
            if (signatureAndHashAlgorithm.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            signatureAndHashAlgorithm.encode(output);
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(InputStream input) throws IOException {
        int n2 = TlsUtils.readUint16(input);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n3 = n2 / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(input);
            if (0 == signatureAndHashAlgorithm.getSignature()) continue;
            vector.addElement(signatureAndHashAlgorithm);
        }
        return vector;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        TlsUtils.a(supportedSignatureAlgorithms, signatureAlgorithm, (short)47);
    }

    static void a(Vector vector, SignatureAndHashAlgorithm signatureAndHashAlgorithm, short s2) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAndHashAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAndHashAlgorithm.getSignature() == 0 || !TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm)) {
            throw new TlsFatalAlert(s2);
        }
    }

    public static boolean containsSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
            if (!signatureAndHashAlgorithm.equals(signatureAlgorithm)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnySignatureAlgorithm(Vector supportedSignatureAlgorithms, short signatureAlgorithm) {
        for (int i2 = 0; i2 < supportedSignatureAlgorithms.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i2);
            if (signatureAndHashAlgorithm.getSignature() != signatureAlgorithm) continue;
            return true;
        }
        return false;
    }

    public static TlsSecret PRF(SecurityParameters securityParameters, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        return secret.deriveUsingPRF(securityParameters.getPRFAlgorithm(), asciiLabel, seed, length);
    }

    public static TlsSecret PRF(TlsContext context, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        return TlsUtils.PRF(context.getSecurityParametersHandshake(), secret, asciiLabel, seed, length);
    }

    public static byte[] clone(byte[] data) {
        return null == data ? (byte[])null : (data.length == 0 ? EMPTY_BYTES : (byte[])data.clone());
    }

    public static String[] clone(String[] s2) {
        return null == s2 ? (String[])null : (s2.length < 1 ? EMPTY_STRINGS : (String[])s2.clone());
    }

    public static boolean constantTimeAreEqual(int len, byte[] a2, int aOff, byte[] b2, int bOff) {
        int n2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            n2 |= a2[aOff + i2] ^ b2[bOff + i2];
        }
        return 0 == n2;
    }

    public static byte[] copyOfRangeExact(byte[] original, int from, int to) {
        int n2 = to - from;
        byte[] byArray = new byte[n2];
        System.arraycopy(original, from, byArray, 0, n2);
        return byArray;
    }

    static byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static byte[] a(TlsContext tlsContext, TlsCertificate tlsCertificate, byte[] byArray) throws IOException {
        return TlsUtils.a(tlsContext, tlsCertificate, byArray, 0, byArray.length);
    }

    static byte[] a(TlsContext tlsContext, TlsCertificate tlsCertificate, byte[] byArray, int n2, int n3) throws IOException {
        Object object;
        int n4 = 0;
        String string = tlsCertificate.getSigAlgOID();
        if (string != null) {
            if (PKCSObjectIdentifiers.id_RSASSA_PSS.getId().equals(string)) {
                object = RSASSAPSSparams.getInstance(tlsCertificate.getSigAlgParams());
                if (null != object) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = ((RSASSAPSSparams)object).getHashAlgorithm().getAlgorithm();
                    if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
                        n4 = 4;
                    } else if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
                        n4 = 5;
                    } else if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
                        n4 = 6;
                    }
                }
            } else {
                object = (SignatureAndHashAlgorithm)c.get(string);
                if (object != null) {
                    n4 = ((SignatureAndHashAlgorithm)object).getHash();
                }
            }
        }
        switch (n4) {
            case 8: {
                n4 = 0;
                break;
            }
            case 1: 
            case 2: {
                n4 = 4;
            }
        }
        if (0 != n4 && (object = TlsUtils.a(tlsContext.getCrypto(), (short)n4)) != null) {
            object.update(byArray, n2, n3);
            return object.calculateHash();
        }
        return EMPTY_BYTES;
    }

    public static byte[] calculateExporterSeed(SecurityParameters securityParameters, byte[] context) {
        byte[] byArray = securityParameters.getClientRandom();
        byte[] byArray2 = securityParameters.getServerRandom();
        if (null == context) {
            return Arrays.concatenate(byArray, byArray2);
        }
        if (!TlsUtils.isValidUint16(context.length)) {
            throw new IllegalArgumentException("'context' must have length less than 2^16 (or be null)");
        }
        byte[] byArray3 = new byte[2];
        TlsUtils.writeUint16(context.length, byArray3, 0);
        return Arrays.concatenate(byArray, byArray2, byArray3, context);
    }

    private static byte[] a(SecurityParameters securityParameters, TlsSecret tlsSecret, byte[] byArray) throws IOException {
        int n2 = securityParameters.getPRFCryptoHashAlgorithm();
        int n3 = securityParameters.getPRFHashLength();
        return TlsUtils.a(n2, n3, tlsSecret, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] a(int n2, int n3, TlsSecret tlsSecret, byte[] byArray) throws IOException {
        TlsSecret tlsSecret2 = TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n2, "finished", EMPTY_BYTES, n3);
        try {
            byte[] byArray2 = tlsSecret2.calculateHMAC(n2, byArray, 0, byArray.length);
            return byArray2;
        }
        finally {
            tlsSecret2.destroy();
        }
    }

    static TlsSecret a(TlsContext tlsContext, TlsSecret tlsSecret) {
        byte[] byArray;
        String string;
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (securityParameters.isExtendedMasterSecret()) {
            string = "extended master secret";
            byArray = securityParameters.getSessionHash();
        } else {
            string = "master secret";
            byArray = TlsUtils.a(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        }
        return TlsUtils.PRF(securityParameters, tlsSecret, string, byArray, 48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] a(TlsCrypto tlsCrypto, boolean bl, int n2, TlsSecret tlsSecret, byte[] byArray) throws IOException {
        int n3 = TlsCryptoUtils.getHashOutputSize(n2);
        String string = bl ? "ext binder" : "res binder";
        byte[] byArray2 = tlsCrypto.createHash(n2).calculateHash();
        TlsSecret tlsSecret2 = TlsUtils.a(n2, n3, tlsSecret, string, byArray2);
        try {
            byte[] byArray3 = TlsUtils.a(n2, n3, tlsSecret2, byArray);
            return byArray3;
        }
        finally {
            tlsSecret2.destroy();
        }
    }

    static byte[] a(TlsContext tlsContext, TlsHandshakeHash tlsHandshakeHash, boolean bl) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(protocolVersion)) {
            TlsSecret tlsSecret = bl ? securityParameters.getBaseKeyServer() : securityParameters.getBaseKeyClient();
            byte[] byArray = TlsUtils.a(tlsHandshakeHash);
            return TlsUtils.a(securityParameters, tlsSecret, byArray);
        }
        if (protocolVersion.isSSL()) {
            return m.a(tlsHandshakeHash, bl);
        }
        String string = bl ? "server finished" : "client finished";
        byte[] byArray = TlsUtils.a(tlsHandshakeHash);
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        int n2 = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(securityParameters, tlsSecret, string, byArray, n2).extract();
    }

    static void a(TlsContext tlsContext, TlsSecret tlsSecret, TlsSecret tlsSecret2) throws IOException {
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        int n2 = securityParameters.getPRFCryptoHashAlgorithm();
        TlsSecret tlsSecret3 = tlsCrypto.hkdfInit(n2);
        byte[] byArray = tlsCrypto.createHash(n2).calculateHash();
        TlsSecret tlsSecret4 = tlsSecret;
        if (null == tlsSecret4) {
            tlsSecret4 = tlsCrypto.hkdfInit(n2).hkdfExtract(n2, tlsSecret3);
        }
        if (null == tlsSecret2) {
            tlsSecret2 = tlsSecret3;
        }
        TlsSecret tlsSecret5 = TlsUtils.a(securityParameters, tlsSecret4, "derived", byArray).hkdfExtract(n2, tlsSecret2);
        if (tlsSecret2 != tlsSecret3) {
            tlsSecret2.destroy();
        }
        TlsSecret tlsSecret6 = TlsUtils.a(securityParameters, tlsSecret5, "derived", byArray).hkdfExtract(n2, tlsSecret3);
        securityParameters.o = tlsSecret4;
        securityParameters.q = tlsSecret5;
        securityParameters.r = tlsSecret6;
    }

    private static void a(TlsContext tlsContext, byte[] byArray, TlsSecret tlsSecret, String string, String string2, l l2) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        securityParameters.s = TlsUtils.a(securityParameters, tlsSecret, string, byArray);
        if (null != string2) {
            securityParameters.t = TlsUtils.a(securityParameters, tlsSecret, string2, byArray);
        }
        l2.a(TlsUtils.c(tlsContext));
    }

    static void a(TlsContext tlsContext, byte[] byArray, l l2) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        TlsUtils.a(tlsContext, byArray, tlsSecret, "c ap traffic", "s ap traffic", l2);
        securityParameters.p = TlsUtils.a(securityParameters, tlsSecret, "exp master", byArray);
    }

    static void b(TlsContext tlsContext, byte[] byArray, l l2) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        TlsSecret tlsSecret = securityParameters.getHandshakeSecret();
        TlsUtils.a(tlsContext, byArray, tlsSecret, "c hs traffic", "s hs traffic", l2);
        securityParameters.l = securityParameters.getTrafficSecretClient();
        securityParameters.m = securityParameters.getTrafficSecretServer();
    }

    static void a(TlsContext tlsContext) throws IOException {
        TlsUtils.a(tlsContext, tlsContext.isServer());
    }

    static void b(TlsContext tlsContext) throws IOException {
        TlsUtils.a(tlsContext, !tlsContext.isServer());
    }

    private static void a(TlsContext tlsContext, boolean bl) throws IOException {
        TlsSecret tlsSecret;
        SecurityParameters securityParameters = tlsContext.getSecurityParametersConnection();
        if (bl) {
            tlsSecret = securityParameters.getTrafficSecretServer();
            securityParameters.t = TlsUtils.a(securityParameters, tlsSecret);
        } else {
            tlsSecret = securityParameters.getTrafficSecretClient();
            securityParameters.s = TlsUtils.a(securityParameters, tlsSecret);
        }
        if (null != tlsSecret) {
            tlsSecret.destroy();
        }
    }

    private static TlsSecret a(SecurityParameters securityParameters, TlsSecret tlsSecret) throws IOException {
        return TlsCryptoUtils.hkdfExpandLabel(tlsSecret, securityParameters.getPRFCryptoHashAlgorithm(), "traffic upd", EMPTY_BYTES, securityParameters.getPRFHashLength());
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 3: 
            case 5: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    static int a(SecurityParameters securityParameters, int n2) throws IOException {
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        boolean bl = TlsUtils.isTLSv13(protocolVersion);
        boolean bl2 = !bl && TlsUtils.isTLSv12(protocolVersion);
        boolean bl3 = protocolVersion.isSSL();
        switch (n2) {
            case 4865: 
            case 4867: 
            case 4868: 
            case 4869: {
                if (bl) {
                    return 4;
                }
                throw new TlsFatalAlert(47);
            }
            case 4866: {
                if (bl) {
                    return 5;
                }
                throw new TlsFatalAlert(47);
            }
            case 198: 
            case 199: {
                if (bl) {
                    return 7;
                }
                throw new TlsFatalAlert(47);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49258: 
            case 49260: 
            case 49262: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53251: 
            case 53253: {
                if (bl2) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49259: 
            case 49261: 
            case 49263: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: 
            case 53250: {
                if (bl2) {
                    return 3;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (bl) {
                    throw new TlsFatalAlert(47);
                }
                if (bl2) {
                    return 3;
                }
                if (bl3) {
                    return 0;
                }
                return 1;
            }
        }
        if (bl) {
            throw new TlsFatalAlert(47);
        }
        if (bl2) {
            return 2;
        }
        if (bl3) {
            return 0;
        }
        return 1;
    }

    static int a(int n2) {
        switch (n2) {
            case 4865: 
            case 4867: 
            case 4868: 
            case 4869: {
                return 4;
            }
            case 4866: {
                return 5;
            }
            case 198: 
            case 199: {
                return 7;
            }
        }
        return -1;
    }

    static int[] a(int[] nArray) {
        int[] nArray2 = new int[Math.min(3, nArray.length)];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = TlsUtils.a(nArray[i2]);
            if (n3 < 0 || Arrays.contains(nArray2, n3)) continue;
            nArray2[n2++] = n3;
        }
        return TlsUtils.b(nArray2, n2);
    }

    static byte[] a(TlsContext tlsContext, SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, i i2) {
        TlsCrypto tlsCrypto = tlsContext.getCrypto();
        TlsHash tlsHash = signatureAndHashAlgorithm == null ? new CombinedHash(tlsCrypto) : TlsUtils.a(tlsCrypto, signatureAndHashAlgorithm);
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        byte[] byArray2 = Arrays.concatenate(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        tlsHash.update(byArray2, 0, byArray2.length);
        if (null != byArray) {
            tlsHash.update(byArray, 0, byArray.length);
        }
        i2.a(tlsHash);
        return tlsHash.calculateHash();
    }

    static void a(TlsContext tlsContext, byte[] byArray, i i2, OutputStream outputStream) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        byte[] byArray2 = Arrays.concatenate(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        outputStream.write(byArray2);
        if (null != byArray) {
            outputStream.write(byArray);
        }
        i2.a(outputStream);
        outputStream.close();
    }

    static DigitallySigned a(TlsClientContext tlsClientContext, TlsCredentialedSigner tlsCredentialedSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, TlsStreamSigner tlsStreamSigner, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        byte[] byArray;
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        if (tlsStreamSigner != null) {
            tlsHandshakeHash.copyBufferTo(tlsStreamSigner.getOutputStream());
            byArray = tlsStreamSigner.getSignature();
        } else {
            byte[] byArray2 = signatureAndHashAlgorithm == null ? securityParameters.getSessionHash() : tlsHandshakeHash.getFinalHash(SignatureScheme.getCryptoHashAlgorithm(signatureAndHashAlgorithm));
            byArray = tlsCredentialedSigner.generateRawSignature(byArray2);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }

    static DigitallySigned a(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = tlsCredentialedSigner.getSignatureAndHashAlgorithm();
        if (null == signatureAndHashAlgorithm) {
            throw new TlsFatalAlert(80);
        }
        String string = tlsContext.isServer() ? "TLS 1.3, server CertificateVerify" : "TLS 1.3, client CertificateVerify";
        byte[] byArray = TlsUtils.a(tlsContext.getCrypto(), tlsCredentialedSigner, string, tlsHandshakeHash, signatureAndHashAlgorithm);
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }

    private static byte[] a(TlsCrypto tlsCrypto, TlsCredentialedSigner tlsCredentialedSigner, String string, TlsHandshakeHash tlsHandshakeHash, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        TlsStreamSigner tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
        byte[] byArray = TlsUtils.a(string);
        byte[] byArray2 = TlsUtils.a(tlsHandshakeHash);
        if (null != tlsStreamSigner) {
            OutputStream outputStream = tlsStreamSigner.getOutputStream();
            outputStream.write(byArray, 0, byArray.length);
            outputStream.write(byArray2, 0, byArray2.length);
            return tlsStreamSigner.getSignature();
        }
        TlsHash tlsHash = TlsUtils.a(tlsCrypto, signatureAndHashAlgorithm);
        tlsHash.update(byArray, 0, byArray.length);
        tlsHash.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = tlsHash.calculateHash();
        return tlsCredentialedSigner.generateRawSignature(byArray3);
    }

    static void a(TlsServerContext tlsServerContext, CertificateRequest certificateRequest, DigitallySigned digitallySigned, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        boolean bl;
        short s2;
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        Certificate certificate = securityParameters.getPeerCertificate();
        TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (null == signatureAndHashAlgorithm) {
            s2 = tlsCertificate.getLegacySignatureAlgorithm();
            TlsUtils.a(certificateRequest, TlsUtils.getLegacyClientCertType(s2), (short)43);
        } else {
            TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), signatureAndHashAlgorithm);
            s2 = signatureAndHashAlgorithm.getSignature();
            TlsUtils.a(certificateRequest, SignatureAlgorithm.getClientCertificateType(s2), (short)47);
        }
        try {
            TlsVerifier tlsVerifier = tlsCertificate.createVerifier(s2);
            TlsStreamVerifier tlsStreamVerifier = tlsVerifier.getStreamVerifier(digitallySigned);
            if (tlsStreamVerifier != null) {
                tlsHandshakeHash.copyBufferTo(tlsStreamVerifier.getOutputStream());
                bl = tlsStreamVerifier.isVerified();
            } else {
                byte[] byArray = TlsUtils.isTLSv12(tlsServerContext) ? tlsHandshakeHash.getFinalHash(SignatureScheme.getCryptoHashAlgorithm(signatureAndHashAlgorithm)) : securityParameters.getSessionHash();
                bl = tlsVerifier.verifyRawSignature(digitallySigned, byArray);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    static void a(TlsServerContext tlsServerContext, TlsHandshakeHash tlsHandshakeHash, CertificateVerify certificateVerify) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        Vector vector = securityParameters.getServerSigAlgs();
        TlsCertificate tlsCertificate = securityParameters.getPeerCertificate().getCertificateAt(0);
        TlsUtils.a(vector, "TLS 1.3, client CertificateVerify", tlsHandshakeHash, tlsCertificate, certificateVerify);
    }

    static void a(TlsClientContext tlsClientContext, TlsHandshakeHash tlsHandshakeHash, CertificateVerify certificateVerify) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        Vector vector = securityParameters.getClientSigAlgs();
        TlsCertificate tlsCertificate = securityParameters.getPeerCertificate().getCertificateAt(0);
        TlsUtils.a(vector, "TLS 1.3, server CertificateVerify", tlsHandshakeHash, tlsCertificate, certificateVerify);
    }

    private static void a(Vector vector, String string, TlsHandshakeHash tlsHandshakeHash, TlsCertificate tlsCertificate, CertificateVerify certificateVerify) throws IOException {
        boolean bl;
        try {
            int n2 = certificateVerify.getAlgorithm();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureScheme.getSignatureAndHashAlgorithm(n2);
            TlsUtils.verifySupportedSignatureAlgorithm(vector, signatureAndHashAlgorithm);
            Tls13Verifier tls13Verifier = tlsCertificate.createVerifier(n2);
            byte[] byArray = TlsUtils.a(string);
            byte[] byArray2 = TlsUtils.a(tlsHandshakeHash);
            OutputStream outputStream = tls13Verifier.getOutputStream();
            outputStream.write(byArray, 0, byArray.length);
            outputStream.write(byArray2, 0, byArray2.length);
            bl = tls13Verifier.verifySignature(certificateVerify.getSignature());
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    private static byte[] a(String string) {
        int n2;
        int n3 = string.length();
        byte[] byArray = new byte[64 + n3 + 1];
        for (n2 = 0; n2 < 64; ++n2) {
            byArray[n2] = 32;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            byArray[64 + n2] = (byte)c2;
        }
        byArray[64 + n3] = 0;
        return byArray;
    }

    static void a(TlsContext tlsContext, TlsCredentialedSigner tlsCredentialedSigner, byte[] byArray, i i2) throws IOException {
        Object object;
        byte[] byArray2;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.a(tlsContext.getServerVersion(), tlsCredentialedSigner);
        TlsStreamSigner tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
        if (tlsStreamSigner != null) {
            TlsUtils.a(tlsContext, byArray, i2, tlsStreamSigner.getOutputStream());
            byArray2 = tlsStreamSigner.getSignature();
        } else {
            object = TlsUtils.a(tlsContext, signatureAndHashAlgorithm, byArray, i2);
            byArray2 = tlsCredentialedSigner.generateRawSignature((byte[])object);
        }
        object = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        ((DigitallySigned)object).encode(i2);
    }

    static void a(TlsContext tlsContext, InputStream inputStream, TlsCertificate tlsCertificate, byte[] byArray, i i2) throws IOException {
        boolean bl;
        short s2;
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsContext, inputStream);
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        int n2 = securityParameters.getKeyExchangeAlgorithm();
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null) {
            s2 = TlsUtils.getLegacySignatureAlgorithmServer(n2);
        } else {
            s2 = signatureAndHashAlgorithm.getSignature();
            if (!TlsUtils.a(s2, n2)) {
                throw new TlsFatalAlert(47);
            }
            TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getClientSigAlgs(), signatureAndHashAlgorithm);
        }
        TlsVerifier tlsVerifier = tlsCertificate.createVerifier(s2);
        TlsStreamVerifier tlsStreamVerifier = tlsVerifier.getStreamVerifier(digitallySigned);
        if (tlsStreamVerifier != null) {
            TlsUtils.a(tlsContext, byArray, i2, tlsStreamVerifier.getOutputStream());
            bl = tlsStreamVerifier.isVerified();
        } else {
            byte[] byArray2 = TlsUtils.a(tlsContext, signatureAndHashAlgorithm, byArray, i2);
            bl = tlsVerifier.verifyRawSignature(digitallySigned, byArray2);
        }
        if (!bl) {
            throw new TlsFatalAlert(51);
        }
    }

    static void a(TlsHandshakeHash tlsHandshakeHash, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        int n2 = SignatureScheme.getCryptoHashAlgorithm(signatureAndHashAlgorithm);
        if (n2 >= 0) {
            tlsHandshakeHash.trackHashAlgorithm(n2);
        }
    }

    static void a(TlsHandshakeHash tlsHandshakeHash, Vector vector) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
            int n2 = SignatureScheme.getCryptoHashAlgorithm(signatureAndHashAlgorithm);
            if (n2 >= 0) {
                tlsHandshakeHash.trackHashAlgorithm(n2);
                continue;
            }
            if (8 != signatureAndHashAlgorithm.getHash()) continue;
            tlsHandshakeHash.forceBuffering();
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static Vector vectorOfOne(Object obj) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(obj);
        return vector;
    }

    public static int getCipherType(int cipherSuite) {
        int n2 = TlsUtils.getEncryptionAlgorithm(cipherSuite);
        return TlsUtils.getEncryptionAlgorithmType(n2);
    }

    public static int getEncryptionAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 4868: 
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: 
            case 53253: {
                return 15;
            }
            case 4869: 
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: 
            case 53251: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 4865: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 53249: {
                return 10;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 4866: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 53250: {
                return 11;
            }
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: {
                return 22;
            }
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49258: 
            case 49260: 
            case 49262: {
                return 24;
            }
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: {
                return 23;
            }
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49259: 
            case 49261: 
            case 49263: {
                return 25;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 4867: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
            case 199: {
                return 26;
            }
            case 198: {
                return 27;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithmType(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 28: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49222: 
            case 49223: 
            case 49242: 
            case 49243: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49214: 
            case 49215: 
            case 49240: 
            case 49241: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49216: 
            case 49217: 
            case 49236: 
            case 49237: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49218: 
            case 49219: 
            case 49238: 
            case 49239: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49254: 
            case 49255: 
            case 49260: 
            case 49261: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49220: 
            case 49221: 
            case 49234: 
            case 49235: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: {
                return 5;
            }
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49226: 
            case 49227: 
            case 49246: 
            case 49247: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49230: 
            case 49231: 
            case 49250: 
            case 49251: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49224: 
            case 49225: 
            case 49244: 
            case 49245: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: {
                return 17;
            }
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49264: 
            case 49265: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return 24;
            }
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49228: 
            case 49229: 
            case 49248: 
            case 49249: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: {
                return 19;
            }
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: {
                return 0;
            }
            case 44: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49252: 
            case 49253: 
            case 49258: 
            case 49259: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: {
                return 13;
            }
            case 2: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49212: 
            case 49213: 
            case 49232: 
            case 49233: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49256: 
            case 49257: 
            case 49262: 
            case 49263: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        return -1;
    }

    public static Vector getKeyExchangeAlgorithms(int[] cipherSuites) {
        Vector vector = new Vector();
        if (null != cipherSuites) {
            for (int i2 = 0; i2 < cipherSuites.length; ++i2) {
                TlsUtils.addToSet(vector, TlsUtils.getKeyExchangeAlgorithm(cipherSuites[i2]));
            }
            vector.removeElement(Integers.valueOf(-1));
        }
        return vector;
    }

    public static int getMACAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return 0;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int cipherSuite) {
        switch (cipherSuite) {
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: {
                return ProtocolVersion.TLSv13;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49212: 
            case 49213: 
            case 49214: 
            case 49215: 
            case 49216: 
            case 49217: 
            case 49218: 
            case 49219: 
            case 49220: 
            case 49221: 
            case 49222: 
            case 49223: 
            case 49224: 
            case 49225: 
            case 49226: 
            case 49227: 
            case 49228: 
            case 49229: 
            case 49230: 
            case 49231: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49252: 
            case 49253: 
            case 49254: 
            case 49255: 
            case 49256: 
            case 49257: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49264: 
            case 49265: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static Vector getNamedGroupRoles(int[] cipherSuites) {
        return TlsUtils.getNamedGroupRoles(TlsUtils.getKeyExchangeAlgorithms(cipherSuites));
    }

    public static Vector getNamedGroupRoles(Vector keyExchangeAlgorithms) {
        Vector vector = new Vector();
        block6: for (int i2 = 0; i2 < keyExchangeAlgorithms.size(); ++i2) {
            int n2 = (Integer)keyExchangeAlgorithms.elementAt(i2);
            switch (n2) {
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    TlsUtils.addToSet(vector, 1);
                    continue block6;
                }
                case 18: 
                case 19: 
                case 20: 
                case 24: {
                    TlsUtils.addToSet(vector, 2);
                    continue block6;
                }
                case 16: 
                case 17: {
                    TlsUtils.addToSet(vector, 2);
                    TlsUtils.addToSet(vector, 3);
                    continue block6;
                }
                case 0: {
                    TlsUtils.addToSet(vector, 1);
                    TlsUtils.addToSet(vector, 2);
                }
            }
        }
        return vector;
    }

    public static boolean isAEADCipherSuite(int cipherSuite) throws IOException {
        return 2 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isBlockCipherSuite(int cipherSuite) throws IOException {
        return 1 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isStreamCipherSuite(int cipherSuite) throws IOException {
        return 0 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (n2) {
            case 0: 
            case 3: 
            case 5: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return true;
            }
        }
        int n3 = sigAlgs.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            short s2;
            Short s3 = (Short)sigAlgs.elementAt(i2);
            if (null == s3 || !TlsUtils.a(s2 = s3.shortValue(), n2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion version) {
        return TlsUtils.isValidVersionForCipherSuite(cipherSuite, version);
    }

    static boolean a(int[] nArray, int n2) {
        return null != nArray && Arrays.contains(nArray, n2) && 0 != n2 && !CipherSuite.isSCSV(n2);
    }

    static boolean a(ProtocolVersion protocolVersion, int[] nArray, Hashtable hashtable, int n2) {
        return null != nArray && Arrays.contains(nArray, n2) && !hashtable.containsKey(Integers.valueOf(n2)) && NamedGroup.canBeNegotiated(n2, protocolVersion);
    }

    static boolean a(short s2, int n2) {
        switch (n2) {
            case 5: 
            case 19: 
            case 23: {
                switch (s2) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 3: 
            case 22: {
                return 2 == s2;
            }
            case 17: {
                switch (s2) {
                    case 3: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return 0 != s2;
            }
        }
        return false;
    }

    public static boolean isValidSignatureSchemeForServerKeyExchange(int signatureScheme, int keyExchangeAlgorithm) {
        short s2 = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        return TlsUtils.a(s2, keyExchangeAlgorithm);
    }

    public static boolean isValidVersionForCipherSuite(int cipherSuite, ProtocolVersion version) {
        version = version.getEquivalentTLSVersion();
        ProtocolVersion protocolVersion = TlsUtils.getMinimumVersion(cipherSuite);
        if (protocolVersion == version) {
            return true;
        }
        if (!protocolVersion.isEarlierVersionOf(version)) {
            return false;
        }
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion) || ProtocolVersion.TLSv13.isLaterVersionOf(version);
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext context, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        return TlsUtils.chooseSignatureAndHashAlgorithm(context.getServerVersion(), sigHashAlgs, signatureAlgorithm);
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(ProtocolVersion negotiatedVersion, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        if (!TlsUtils.isTLSv12(negotiatedVersion)) {
            return null;
        }
        if (sigHashAlgs == null) {
            sigHashAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        for (int i2 = 0; i2 < sigHashAlgs.size(); ++i2) {
            short s2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm2 = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i2);
            if (signatureAndHashAlgorithm2.getSignature() != signatureAlgorithm || (s2 = signatureAndHashAlgorithm2.getHash()) < 2) continue;
            if (signatureAndHashAlgorithm == null) {
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            short s3 = signatureAndHashAlgorithm.getHash();
            if (s3 < 4) {
                if (s2 <= s3) continue;
                signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
                continue;
            }
            if (s2 < 4 || s2 >= s3) continue;
            signatureAndHashAlgorithm = signatureAndHashAlgorithm2;
        }
        if (signatureAndHashAlgorithm == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            Vector<Short> vector = new Vector<Short>(3);
            vector.addElement(Shorts.valueOf((short)1));
            vector.addElement(Shorts.valueOf((short)2));
            vector.addElement(Shorts.valueOf((short)3));
            return vector;
        }
        Vector<Short> vector = new Vector<Short>();
        for (int i2 = 0; i2 < sigHashAlgs.size(); ++i2) {
            Short s2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i2);
            if (signatureAndHashAlgorithm.getHash() < 2 || vector.contains(s2 = Shorts.valueOf(signatureAndHashAlgorithm.getSignature()))) continue;
            vector.addElement(s2);
        }
        return vector;
    }

    public static int getCommonCipherSuite13(ProtocolVersion negotiatedVersion, int[] peerCipherSuites, int[] localCipherSuites, boolean useLocalOrder) {
        int[] nArray = peerCipherSuites;
        int[] nArray2 = localCipherSuites;
        if (useLocalOrder) {
            nArray = localCipherSuites;
            nArray2 = peerCipherSuites;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!Arrays.contains(nArray2, n2) || !TlsUtils.isValidVersionForCipherSuite(n2, negotiatedVersion)) continue;
            return n2;
        }
        return -1;
    }

    public static int[] getCommonCipherSuites(int[] peerCipherSuites, int[] localCipherSuites, boolean useLocalOrder) {
        int[] nArray = peerCipherSuites;
        int[] nArray2 = localCipherSuites;
        if (useLocalOrder) {
            nArray = localCipherSuites;
            nArray2 = peerCipherSuites;
        }
        int n2 = 0;
        int n3 = Math.min(nArray.length, nArray2.length);
        int[] nArray3 = new int[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            if (TlsUtils.a(nArray3, 0, n2, n4) || !Arrays.contains(nArray2, n4)) continue;
            nArray3[n2++] = n4;
        }
        if (n2 < n3) {
            nArray3 = Arrays.copyOf(nArray3, n2);
        }
        return nArray3;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites) {
        return TlsUtils.getSupportedCipherSuites(crypto, suites, 0, suites.length);
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites, int suitesCount) {
        return TlsUtils.getSupportedCipherSuites(crypto, suites, 0, suitesCount);
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites, int suitesOff, int suitesCount) {
        int[] nArray = new int[suitesCount];
        int n2 = 0;
        for (int i2 = 0; i2 < suitesCount; ++i2) {
            int n3 = suites[suitesOff + i2];
            if (!TlsUtils.isSupportedCipherSuite(crypto, n3)) continue;
            nArray[n2++] = n3;
        }
        if (n2 < suitesCount) {
            nArray = Arrays.copyOf(nArray, n2);
        }
        return nArray;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto crypto, int cipherSuite) {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        if (!TlsUtils.isSupportedKeyExchange(crypto, n2)) {
            return false;
        }
        int n3 = TlsUtils.getEncryptionAlgorithm(cipherSuite);
        if (n3 < 0 || !crypto.hasEncryptionAlgorithm(n3)) {
            return false;
        }
        int n4 = TlsUtils.getMACAlgorithm(cipherSuite);
        return n4 == 0 || n4 >= 0 && crypto.hasMacAlgorithm(n4);
    }

    public static boolean isSupportedKeyExchange(TlsCrypto crypto, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return crypto.hasDHAgreement();
            }
            case 3: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm((short)2);
            }
            case 5: {
                return crypto.hasDHAgreement() && TlsUtils.a(crypto);
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                return crypto.hasECDHAgreement();
            }
            case 17: {
                return crypto.hasECDHAgreement() && (crypto.hasSignatureAlgorithm((short)3) || crypto.hasSignatureAlgorithm((short)7) || crypto.hasSignatureAlgorithm((short)8));
            }
            case 19: {
                return crypto.hasECDHAgreement() && TlsUtils.a(crypto);
            }
            case 0: 
            case 13: {
                return true;
            }
            case 1: 
            case 15: {
                return crypto.hasRSAEncryption();
            }
            case 21: {
                return crypto.hasSRPAuthentication();
            }
            case 22: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm((short)2);
            }
            case 23: {
                return crypto.hasSRPAuthentication() && TlsUtils.a(crypto);
            }
        }
        return false;
    }

    static boolean a(TlsCrypto tlsCrypto) {
        return tlsCrypto.hasSignatureAlgorithm((short)1) || tlsCrypto.hasSignatureAlgorithm((short)4) || tlsCrypto.hasSignatureAlgorithm((short)5) || tlsCrypto.hasSignatureAlgorithm((short)6) || tlsCrypto.hasSignatureAlgorithm((short)9) || tlsCrypto.hasSignatureAlgorithm((short)10) || tlsCrypto.hasSignatureAlgorithm((short)11);
    }

    static byte[] a(TlsHandshakeHash tlsHandshakeHash) {
        return tlsHandshakeHash.forkPRFHash().calculateHash();
    }

    private static TlsHash a(TlsCrypto tlsCrypto, short s2) {
        return tlsCrypto.createHash(TlsCryptoUtils.getHash(s2));
    }

    private static TlsHash a(TlsCrypto tlsCrypto, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return tlsCrypto.createHash(SignatureScheme.getCryptoHashAlgorithm(signatureAndHashAlgorithm));
    }

    private static TlsKeyExchange a(TlsClient tlsClient, int n2) throws IOException {
        TlsKeyExchangeFactory tlsKeyExchangeFactory = tlsClient.getKeyExchangeFactory();
        switch (n2) {
            case 11: {
                return tlsKeyExchangeFactory.createDHanonKeyExchangeClient(n2, tlsClient.getDHGroupVerifier());
            }
            case 7: 
            case 9: {
                return tlsKeyExchangeFactory.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return tlsKeyExchangeFactory.createDHEKeyExchangeClient(n2, tlsClient.getDHGroupVerifier());
            }
            case 20: {
                return tlsKeyExchangeFactory.createECDHanonKeyExchangeClient(n2);
            }
            case 16: 
            case 18: {
                return tlsKeyExchangeFactory.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return tlsKeyExchangeFactory.createECDHEKeyExchangeClient(n2);
            }
            case 1: {
                return tlsKeyExchangeFactory.createRSAKeyExchange(n2);
            }
            case 14: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeClient(n2, tlsClient.getPSKIdentity(), tlsClient.getDHGroupVerifier());
            }
            case 13: 
            case 15: 
            case 24: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeClient(n2, tlsClient.getPSKIdentity(), null);
            }
            case 21: 
            case 22: 
            case 23: {
                return tlsKeyExchangeFactory.createSRPKeyExchangeClient(n2, tlsClient.getSRPIdentity(), tlsClient.getSRPConfigVerifier());
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange a(TlsServer tlsServer, int n2) throws IOException {
        TlsKeyExchangeFactory tlsKeyExchangeFactory = tlsServer.getKeyExchangeFactory();
        switch (n2) {
            case 11: {
                return tlsKeyExchangeFactory.createDHanonKeyExchangeServer(n2, tlsServer.getDHConfig());
            }
            case 7: 
            case 9: {
                return tlsKeyExchangeFactory.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return tlsKeyExchangeFactory.createDHEKeyExchangeServer(n2, tlsServer.getDHConfig());
            }
            case 20: {
                return tlsKeyExchangeFactory.createECDHanonKeyExchangeServer(n2, tlsServer.getECDHConfig());
            }
            case 16: 
            case 18: {
                return tlsKeyExchangeFactory.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return tlsKeyExchangeFactory.createECDHEKeyExchangeServer(n2, tlsServer.getECDHConfig());
            }
            case 1: {
                return tlsKeyExchangeFactory.createRSAKeyExchange(n2);
            }
            case 14: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n2, tlsServer.getPSKIdentityManager(), tlsServer.getDHConfig(), null);
            }
            case 24: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n2, tlsServer.getPSKIdentityManager(), null, tlsServer.getECDHConfig());
            }
            case 13: 
            case 15: {
                return tlsKeyExchangeFactory.createPSKKeyExchangeServer(n2, tlsServer.getPSKIdentityManager(), null, null);
            }
            case 21: 
            case 22: 
            case 23: {
                return tlsKeyExchangeFactory.createSRPKeyExchangeServer(n2, tlsServer.getSRPLoginParameters());
            }
        }
        throw new TlsFatalAlert(80);
    }

    static TlsKeyExchange a(TlsClientContext tlsClientContext, TlsClient tlsClient) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        TlsKeyExchange tlsKeyExchange = TlsUtils.a(tlsClient, securityParameters.getKeyExchangeAlgorithm());
        tlsKeyExchange.init(tlsClientContext);
        return tlsKeyExchange;
    }

    static TlsKeyExchange a(TlsServerContext tlsServerContext, TlsServer tlsServer) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        TlsKeyExchange tlsKeyExchange = TlsUtils.a(tlsServer, securityParameters.getKeyExchangeAlgorithm());
        tlsKeyExchange.init(tlsServerContext);
        return tlsKeyExchange;
    }

    static TlsCipher c(TlsContext tlsContext) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        int n2 = securityParameters.getCipherSuite();
        int n3 = TlsUtils.getEncryptionAlgorithm(n2);
        int n4 = TlsUtils.getMACAlgorithm(n2);
        if (n3 < 0 || n4 < 0) {
            throw new TlsFatalAlert(80);
        }
        return tlsContext.getCrypto().createCipher(new TlsCryptoParameters(tlsContext), n3, n4);
    }

    public static void checkPeerSigAlgs(TlsContext context, TlsCertificate[] peerCertPath) throws IOException {
        if (context.isServer()) {
            TlsUtils.a(context, peerCertPath);
        } else {
            TlsUtils.b(context, peerCertPath);
        }
    }

    private static void a(TlsContext tlsContext, TlsCertificate[] tlsCertificateArray) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        short[] sArray = securityParameters.getClientCertTypes();
        Vector vector = securityParameters.getServerSigAlgsCert();
        int n2 = tlsCertificateArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            TlsCertificate tlsCertificate = tlsCertificateArray[i2];
            TlsCertificate tlsCertificate2 = tlsCertificateArray[i2 + 1];
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.a(tlsCertificate, tlsCertificate2);
            boolean bl = false;
            if (null != signatureAndHashAlgorithm) {
                if (null == vector) {
                    if (null != sArray) {
                        for (int i3 = 0; i3 < sArray.length; ++i3) {
                            short s2 = TlsUtils.getLegacySignatureAlgorithmClientCert(sArray[i3]);
                            if (signatureAndHashAlgorithm.getSignature() != s2) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm);
                }
            }
            if (bl) continue;
            throw new TlsFatalAlert(42);
        }
    }

    private static void b(TlsContext tlsContext, TlsCertificate[] tlsCertificateArray) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        Vector vector = securityParameters.getClientSigAlgsCert();
        Vector vector2 = securityParameters.getClientSigAlgs();
        if (vector2 == vector || TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            vector2 = null;
        }
        int n2 = tlsCertificateArray.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            TlsCertificate tlsCertificate = tlsCertificateArray[i2];
            TlsCertificate tlsCertificate2 = tlsCertificateArray[i2 + 1];
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.a(tlsCertificate, tlsCertificate2);
            boolean bl = false;
            if (null != signatureAndHashAlgorithm) {
                if (null == vector) {
                    short s2 = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm());
                    bl = s2 == signatureAndHashAlgorithm.getSignature();
                } else {
                    boolean bl2 = bl = TlsUtils.containsSignatureAlgorithm(vector, signatureAndHashAlgorithm) || null != vector2 && TlsUtils.containsSignatureAlgorithm(vector2, signatureAndHashAlgorithm);
                }
            }
            if (bl) continue;
            throw new TlsFatalAlert(42);
        }
    }

    static void a(Certificate certificate, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        byte[] byArray = certificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (byArray != null) {
            int n2;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)TlsUtils.readASN1Object(byArray);
            for (n2 = 0; n2 < aSN1Sequence.size(); ++n2) {
                if (aSN1Sequence.getObjectAt(n2) instanceof ASN1Integer) continue;
                throw new TlsFatalAlert(42);
            }
            TlsUtils.requireDEREncoding(aSN1Sequence, byArray);
            for (n2 = 0; n2 < aSN1Sequence.size(); ++n2) {
                Integer n3;
                BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(n2)).getPositiveValue();
                if (bigInteger.bitLength() > 16 || !hashtable.containsKey(n3 = Integers.valueOf(bigInteger.intValue())) || hashtable2.containsKey(n3)) continue;
                throw new TlsFatalAlert(46);
            }
        }
    }

    static void a(TlsServerContext tlsServerContext, Certificate certificate, TlsKeyExchange tlsKeyExchange, TlsServer tlsServer) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        boolean bl = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!bl) {
            if (certificate.isEmpty()) {
                tlsKeyExchange.skipClientCredentials();
            } else {
                tlsKeyExchange.processClientCertificate(certificate);
            }
        }
        securityParameters.S = certificate;
        tlsServer.notifyClientCertificate(certificate);
    }

    static void a(TlsClientContext tlsClientContext, CertificateStatus certificateStatus, TlsKeyExchange tlsKeyExchange, TlsAuthentication tlsAuthentication, Hashtable hashtable, Hashtable hashtable2) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        boolean bl = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (null == tlsAuthentication) {
            if (bl) {
                throw new TlsFatalAlert(80);
            }
            if (securityParameters.isRenegotiating()) {
                throw new TlsFatalAlert(40);
            }
            tlsKeyExchange.skipServerCredentials();
            securityParameters.A = EMPTY_BYTES;
            return;
        }
        Certificate certificate = securityParameters.getPeerCertificate();
        TlsUtils.a(certificate, hashtable, hashtable2);
        if (!bl) {
            tlsKeyExchange.processServerCertificate(certificate);
        }
        tlsAuthentication.notifyServerCertificate(new r(certificate, certificateStatus));
    }

    static SignatureAndHashAlgorithm a(TlsCertificate tlsCertificate, TlsCertificate tlsCertificate2) throws IOException {
        String string = tlsCertificate.getSigAlgOID();
        if (null != string) {
            if (!PKCSObjectIdentifiers.id_RSASSA_PSS.getId().equals(string)) {
                return (SignatureAndHashAlgorithm)c.get(string);
            }
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(tlsCertificate.getSigAlgParams());
            if (null != rSASSAPSSparams) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = rSASSAPSSparams.getHashAlgorithm().getAlgorithm();
                if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)9)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha256;
                    }
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)4)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha256;
                    }
                } else if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)10)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha384;
                    }
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)5)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha384;
                    }
                } else if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)11)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha512;
                    }
                    if (tlsCertificate2.supportsSignatureAlgorithmCA((short)6)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha512;
                    }
                }
            }
        }
        return null;
    }

    static CertificateRequest a(CertificateRequest certificateRequest, TlsKeyExchange tlsKeyExchange) throws IOException {
        short[] sArray = tlsKeyExchange.getClientCertificateTypes();
        if (TlsUtils.isNullOrEmpty(sArray)) {
            throw new TlsFatalAlert(10);
        }
        if ((certificateRequest = TlsUtils.a(certificateRequest, sArray)) == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest a(CertificateRequest certificateRequest, short[] sArray) {
        if (TlsUtils.a(sArray, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] sArray2 = TlsUtils.b(certificateRequest.getCertificateTypes(), sArray);
        if (sArray2.length < 1) {
            return null;
        }
        return new CertificateRequest(sArray2, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean a(short[] sArray, int n2, int n3, short s2) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (s2 != sArray[n2 + i2]) continue;
            return true;
        }
        return false;
    }

    static boolean a(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n4 != nArray[n2 + i2]) continue;
            return true;
        }
        return false;
    }

    static boolean a(short[] sArray, short[] sArray2) {
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            if (Arrays.contains(sArray, sArray2[i2])) continue;
            return false;
        }
        return true;
    }

    static boolean b(short[] sArray, int n2, int n3, short s2) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (s2 == sArray[n2 + i2]) continue;
            return true;
        }
        return false;
    }

    static short[] b(short[] sArray, short[] sArray2) {
        short[] sArray3 = new short[Math.min(sArray.length, sArray2.length)];
        int n2 = 0;
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            if (!Arrays.contains(sArray, sArray2[i2])) continue;
            sArray3[n2++] = sArray2[i2];
        }
        return TlsUtils.a(sArray3, n2);
    }

    static short[] a(short[] sArray, int n2) {
        if (n2 >= sArray.length) {
            return sArray;
        }
        short[] sArray2 = new short[n2];
        System.arraycopy(sArray, 0, sArray2, 0, n2);
        return sArray2;
    }

    static int[] b(int[] nArray, int n2) {
        if (n2 >= nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    static TlsCredentialedAgreement a(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedAgreement)tlsCredentials;
    }

    static TlsCredentialedDecryptor b(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedDecryptor)tlsCredentials;
    }

    static TlsCredentialedSigner c(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)tlsCredentials;
    }

    private static void a(CertificateRequest certificateRequest, short s2, short s3) throws IOException {
        if (s2 < 0 || !Arrays.contains(certificateRequest.getCertificateTypes(), s2)) {
            throw new TlsFatalAlert(s3);
        }
    }

    private static void b(byte[] byArray, byte[] byArray2) throws IOException {
        int n2 = byArray2.length;
        if (TlsUtils.constantTimeAreEqual(n2, byArray2, 0, byArray, byArray.length - n2)) {
            throw new TlsFatalAlert(47);
        }
    }

    static void a(ProtocolVersion protocolVersion, byte[] byArray) throws IOException {
        if ((protocolVersion = protocolVersion.getEquivalentTLSVersion()).isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            TlsUtils.b(byArray, a);
        }
        if (protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv12)) {
            TlsUtils.b(byArray, b);
        }
    }

    static void b(ProtocolVersion protocolVersion, byte[] byArray) throws IOException {
        byte[] byArray2;
        if (ProtocolVersion.TLSv12 == (protocolVersion = protocolVersion.getEquivalentTLSVersion())) {
            byArray2 = b;
        } else if (protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            byArray2 = a;
        } else {
            throw new TlsFatalAlert(80);
        }
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
    }

    private static boolean a(Certificate certificate, Certificate certificate2) {
        int n2 = certificate.getLength();
        if (certificate2.getLength() == n2) {
            try {
                for (int i2 = 0; i2 < n2; ++i2) {
                    TlsCertificate tlsCertificate = certificate.getCertificateAt(i2);
                    TlsCertificate tlsCertificate2 = certificate2.getCertificateAt(i2);
                    if (Arrays.areEqual(tlsCertificate.getEncoded(), tlsCertificate2.getEncoded())) continue;
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean a(TlsClientContext tlsClientContext, Certificate certificate) {
        Certificate certificate2;
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersConnection();
        if (securityParameters != null && null != (certificate2 = securityParameters.getPeerCertificate())) {
            return TlsUtils.a(certificate2, certificate);
        }
        return false;
    }

    static TlsAuthentication a(TlsClientContext tlsClientContext, TlsClient tlsClient, ByteArrayInputStream byteArrayInputStream, Hashtable hashtable) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (KeyExchangeAlgorithm.isAnonymous(securityParameters.getKeyExchangeAlgorithm()) || null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(securityParameters.getServerCertificateType()).setMaxChainLength(tlsClient.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, tlsClientContext, byteArrayInputStream, byteArrayOutputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(50);
        }
        if (securityParameters.isRenegotiating() && !TlsUtils.a(tlsClientContext, certificate)) {
            throw new TlsFatalAlert(46, "Server certificate changed unsafely in renegotiation handshake");
        }
        securityParameters.S = certificate;
        securityParameters.A = byteArrayOutputStream.toByteArray();
        TlsAuthentication tlsAuthentication = tlsClient.getAuthentication();
        if (null == tlsAuthentication) {
            throw new TlsFatalAlert(80);
        }
        return tlsAuthentication;
    }

    static TlsAuthentication b(TlsClientContext tlsClientContext, TlsClient tlsClient, ByteArrayInputStream byteArrayInputStream, Hashtable hashtable) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions parseOptions = new Certificate.ParseOptions().setCertificateType(securityParameters.getServerCertificateType()).setMaxChainLength(tlsClient.getMaxCertificateChainLength());
        Certificate certificate = Certificate.parse(parseOptions, tlsClientContext, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (certificate.getCertificateRequestContext().length > 0) {
            throw new TlsFatalAlert(47);
        }
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(50);
        }
        securityParameters.S = certificate;
        securityParameters.A = null;
        TlsAuthentication tlsAuthentication = tlsClient.getAuthentication();
        if (null == tlsAuthentication) {
            throw new TlsFatalAlert(80);
        }
        return tlsAuthentication;
    }

    static TlsAuthentication a(TlsClientContext tlsClientContext) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        if (null != securityParameters.getPeerCertificate()) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.S = null;
        securityParameters.A = null;
        return null;
    }

    public static boolean containsNonAscii(byte[] bs) {
        for (int i2 = 0; i2 < bs.length; ++i2) {
            int n2 = bs[i2] & 0xFF;
            if (n2 < 128) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonAscii(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0080') continue;
            return true;
        }
        return false;
    }

    static Hashtable a(TlsClientContext tlsClientContext, TlsClient tlsClient, Hashtable hashtable) throws IOException {
        if (!TlsUtils.isTLSv13(tlsClientContext.getClientVersion()) || !hashtable.containsKey(TlsExtensionsUtils.EXT_supported_groups)) {
            return null;
        }
        int[] nArray = TlsExtensionsUtils.getSupportedGroupsExtension(hashtable);
        Vector vector = tlsClient.getEarlyKeyShareGroups();
        Hashtable hashtable2 = new Hashtable(3);
        Vector vector2 = new Vector(2);
        TlsUtils.a(tlsClientContext.getCrypto(), nArray, vector, hashtable2, vector2);
        TlsExtensionsUtils.addKeyShareClientHello(hashtable, vector2);
        return hashtable2;
    }

    static Hashtable a(TlsClientContext tlsClientContext, Hashtable hashtable, int n2) throws IOException {
        int[] nArray = new int[]{n2};
        Vector vector = TlsUtils.vectorOfOne(Integers.valueOf(n2));
        Hashtable hashtable2 = new Hashtable(1, 1.0f);
        Vector vector2 = new Vector(1);
        TlsUtils.a(tlsClientContext.getCrypto(), nArray, vector, hashtable2, vector2);
        TlsExtensionsUtils.addKeyShareClientHello(hashtable, vector2);
        if (hashtable2.isEmpty() || vector2.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        return hashtable2;
    }

    private static void a(TlsCrypto tlsCrypto, int[] nArray, Vector vector, Hashtable hashtable, Vector vector2) throws IOException {
        if (TlsUtils.isNullOrEmpty(nArray)) {
            return;
        }
        if (null == vector || vector.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            Integer n3 = Integers.valueOf(n2);
            if (!vector.contains(n3) || hashtable.containsKey(n3) || !tlsCrypto.hasNamedGroup(n2)) continue;
            TlsAgreement tlsAgreement = null;
            if (NamedGroup.refersToASpecificCurve(n2)) {
                if (tlsCrypto.hasECDHAgreement()) {
                    tlsAgreement = tlsCrypto.createECDomain(new TlsECConfig(n2)).createECDH();
                }
            } else if (NamedGroup.refersToASpecificFiniteField(n2) && tlsCrypto.hasDHAgreement()) {
                tlsAgreement = tlsCrypto.createDHDomain(new TlsDHConfig(n2, true)).createDH();
            }
            if (null == tlsAgreement) continue;
            byte[] byArray = tlsAgreement.generateEphemeral();
            KeyShareEntry keyShareEntry = new KeyShareEntry(n2, byArray);
            vector2.addElement(keyShareEntry);
            hashtable.put(n3, tlsAgreement);
        }
    }

    static KeyShareEntry a(Vector vector, int n2) {
        KeyShareEntry keyShareEntry;
        if (null != vector && 1 == vector.size() && null != (keyShareEntry = (KeyShareEntry)vector.elementAt(0)) && keyShareEntry.getNamedGroup() == n2) {
            return keyShareEntry;
        }
        return null;
    }

    static KeyShareEntry a(TlsCrypto tlsCrypto, ProtocolVersion protocolVersion, Vector vector, int[] nArray, int[] nArray2) {
        if (null != vector && !TlsUtils.isNullOrEmpty(nArray) && !TlsUtils.isNullOrEmpty(nArray2)) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                KeyShareEntry keyShareEntry = (KeyShareEntry)vector.elementAt(i2);
                int n2 = keyShareEntry.getNamedGroup();
                if (!NamedGroup.canBeNegotiated(n2, protocolVersion) || !Arrays.contains(nArray2, n2) || !Arrays.contains(nArray, n2) || !tlsCrypto.hasNamedGroup(n2) || NamedGroup.refersToASpecificCurve(n2) && !tlsCrypto.hasECDHAgreement() || NamedGroup.refersToASpecificFiniteField(n2) && !tlsCrypto.hasDHAgreement()) continue;
                return keyShareEntry;
            }
        }
        return null;
    }

    static int a(TlsCrypto tlsCrypto, ProtocolVersion protocolVersion, int[] nArray, int[] nArray2) {
        if (!TlsUtils.isNullOrEmpty(nArray) && !TlsUtils.isNullOrEmpty(nArray2)) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                if (!NamedGroup.canBeNegotiated(n2, protocolVersion) || !Arrays.contains(nArray2, n2) || !tlsCrypto.hasNamedGroup(n2) || NamedGroup.refersToASpecificCurve(n2) && !tlsCrypto.hasECDHAgreement() || NamedGroup.refersToASpecificFiniteField(n2) && !tlsCrypto.hasDHAgreement()) continue;
                return n2;
            }
        }
        return -1;
    }

    static byte[] a(TlsContext tlsContext, InputStream inputStream) throws IOException {
        if (TlsUtils.isSSL(tlsContext)) {
            return m.a(inputStream);
        }
        return TlsUtils.readOpaque16(inputStream);
    }

    static void a(TlsContext tlsContext, byte[] byArray, OutputStream outputStream) throws IOException {
        if (TlsUtils.isSSL(tlsContext)) {
            m.a(byArray, outputStream);
        } else {
            TlsUtils.writeOpaque16(byArray, outputStream);
        }
    }

    static byte[] a(TlsSession tlsSession) {
        byte[] byArray;
        if (null != tlsSession && null != (byArray = tlsSession.getSessionID()) && byArray.length > 0 && byArray.length <= 32) {
            return byArray;
        }
        return EMPTY_BYTES;
    }

    static void b(TlsHandshakeHash tlsHandshakeHash) throws IOException {
        byte[] byArray = TlsUtils.a(tlsHandshakeHash);
        tlsHandshakeHash.reset();
        int n2 = byArray.length;
        TlsUtils.checkUint8(n2);
        byte[] byArray2 = new byte[4 + n2];
        TlsUtils.writeUint8((short)254, byArray2, 0);
        TlsUtils.writeUint24(n2, byArray2, 1);
        System.arraycopy(byArray, 0, byArray2, 4, n2);
        tlsHandshakeHash.update(byArray2, 0, byArray2.length);
    }

    static TlsCredentials a(TlsAuthentication tlsAuthentication, CertificateRequest certificateRequest) throws IOException {
        return TlsUtils.d(tlsAuthentication.getClientCredentials(certificateRequest));
    }

    static TlsCredentialedSigner b(TlsAuthentication tlsAuthentication, CertificateRequest certificateRequest) throws IOException {
        return TlsUtils.e(tlsAuthentication.getClientCredentials(certificateRequest));
    }

    static void a(SecurityParameters securityParameters, Hashtable hashtable) throws IOException {
        securityParameters.K = TlsExtensionsUtils.getSignatureAlgorithmsExtension(hashtable);
        securityParameters.L = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(hashtable);
    }

    static TlsCredentials a(TlsServer tlsServer) throws IOException {
        return TlsUtils.d(tlsServer.getCredentials());
    }

    static TlsCredentialedSigner b(TlsServer tlsServer) throws IOException {
        return TlsUtils.e(tlsServer.getCredentials());
    }

    static void a(SecurityParameters securityParameters, CertificateRequest certificateRequest) throws IOException {
        securityParameters.I = certificateRequest.getCertificateTypes();
        securityParameters.N = certificateRequest.getSupportedSignatureAlgorithms();
        securityParameters.O = certificateRequest.getSupportedSignatureAlgorithmsCert();
        if (null == securityParameters.getServerSigAlgsCert()) {
            securityParameters.O = securityParameters.getServerSigAlgs();
        }
    }

    static TlsCredentials d(TlsCredentials tlsCredentials) throws IOException {
        if (null != tlsCredentials) {
            int n2 = 0;
            n2 += tlsCredentials instanceof TlsCredentialedAgreement ? 1 : 0;
            n2 += tlsCredentials instanceof TlsCredentialedDecryptor ? 1 : 0;
            if ((n2 += tlsCredentials instanceof TlsCredentialedSigner ? 1 : 0) != 1) {
                throw new TlsFatalAlert(80);
            }
        }
        return tlsCredentials;
    }

    static TlsCredentialedSigner e(TlsCredentials tlsCredentials) throws IOException {
        if (null == tlsCredentials) {
            return null;
        }
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)tlsCredentials;
    }

    static void b(SecurityParameters securityParameters, int n2) throws IOException {
        int n3;
        securityParameters.e = n2;
        securityParameters.Q = TlsUtils.getKeyExchangeAlgorithm(n2);
        securityParameters.g = n3 = TlsUtils.a(securityParameters, n2);
        switch (n3) {
            case 0: 
            case 1: {
                securityParameters.h = -1;
                securityParameters.i = (short)-1;
                securityParameters.j = -1;
                break;
            }
            default: {
                int n4;
                securityParameters.h = n4 = TlsCryptoUtils.getHashForPRF(n3);
                securityParameters.i = TlsUtils.getHashAlgorithmForPRFAlgorithm(n3);
                securityParameters.j = TlsCryptoUtils.getHashOutputSize(n4);
                break;
            }
        }
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        securityParameters.k = TlsUtils.isTLSv13(protocolVersion) ? securityParameters.getPRFHashLength() : (protocolVersion.isSSL() ? 36 : 12);
    }

    static void a(SecurityParameters securityParameters) throws IOException {
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(securityParameters.getNegotiatedVersion())) {
            securityParameters.K = null;
            securityParameters.L = null;
            return;
        }
        if (null == securityParameters.getClientSigAlgs()) {
            securityParameters.K = TlsUtils.getLegacySupportedSignatureAlgorithms();
        }
        if (null == securityParameters.getClientSigAlgsCert()) {
            securityParameters.L = securityParameters.getClientSigAlgs();
        }
    }

    static void b(TlsClientContext tlsClientContext, TlsClient tlsClient) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.a(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a(securityParameters);
        tlsClient.notifyServerVersion(protocolVersion);
    }

    static void a(TlsServerContext tlsServerContext) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.b(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a(securityParameters);
    }

    static void c(TlsClientContext tlsClientContext, TlsClient tlsClient) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.c(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a(securityParameters);
        tlsClient.notifyServerVersion(protocolVersion);
    }

    static void b(TlsServerContext tlsServerContext) throws IOException {
        SecurityParameters securityParameters = tlsServerContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.d(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.a(securityParameters);
    }

    static TlsSecret a(SecurityParameters securityParameters, TlsSecret tlsSecret, String string, byte[] byArray) throws IOException {
        int n2 = securityParameters.getPRFCryptoHashAlgorithm();
        int n3 = securityParameters.getPRFHashLength();
        return TlsUtils.a(n2, n3, tlsSecret, string, byArray);
    }

    static TlsSecret a(int n2, int n3, TlsSecret tlsSecret, String string, byte[] byArray) throws IOException {
        if (byArray.length != n3) {
            throw new TlsFatalAlert(80);
        }
        return TlsCryptoUtils.hkdfExpandLabel(tlsSecret, n2, string, byArray, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TlsSecret a(TlsCrypto tlsCrypto, TlsSecret tlsSecret) {
        if (null != tlsSecret) {
            TlsSecret tlsSecret2 = tlsSecret;
            synchronized (tlsSecret2) {
                if (tlsSecret.isAlive()) {
                    return tlsCrypto.adoptSecret(tlsSecret);
                }
            }
        }
        return null;
    }

    static boolean a(int n2, int n3) {
        switch (n3) {
            case 0: 
            case 1: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                switch (n2) {
                    case 1: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 5: 
            case 18: {
                switch (n2) {
                    case 1: 
                    case 11: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 13: 
            case 27: 
            case 47: 
            case 50: {
                switch (n2) {
                    case 1: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 21: 
            case 45: 
            case 49: {
                switch (n2) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
            case 43: 
            case 51: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 6: {
                        return true;
                    }
                }
                return false;
            }
            case 41: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
            case 42: {
                switch (n2) {
                    case 1: 
                    case 4: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 44: {
                switch (n2) {
                    case 1: 
                    case 6: {
                        return true;
                    }
                }
                return false;
            }
            case 48: {
                switch (n2) {
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
        }
        return !ExtensionType.isRecognized(n3);
    }

    static void a(Hashtable hashtable, int n2, short s2) throws IOException {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            if (null != n3 && TlsUtils.a(n2, (int)n3)) continue;
            throw new TlsFatalAlert(s2, "Invalid extension: " + ExtensionType.getText(n3));
        }
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsEncryptor encryptor, OutputStream output) throws IOException {
        ProtocolVersion protocolVersion = context.getRSAPreMasterSecretVersion();
        TlsSecret tlsSecret = context.getCrypto().generateRSAPreMasterSecret(protocolVersion);
        byte[] byArray = tlsSecret.encrypt(encryptor);
        TlsUtils.a(context, byArray, output);
        return tlsSecret;
    }

    static void a(TlsPSK[] tlsPSKArray, Hashtable hashtable) throws IOException {
        Vector<PskIdentity> vector = new Vector<PskIdentity>(tlsPSKArray.length);
        for (int i2 = 0; i2 < tlsPSKArray.length; ++i2) {
            TlsPSK tlsPSK = tlsPSKArray[i2];
            vector.add(new PskIdentity(tlsPSK.getIdentity(), 0L));
        }
        TlsExtensionsUtils.addPreSharedKeyClientHello(hashtable, new OfferedPsks(vector));
    }

    static OfferedPsks.a a(TlsClientContext tlsClientContext, TlsClient tlsClient, Hashtable hashtable, int[] nArray) throws IOException {
        if (!TlsUtils.isTLSv13(tlsClientContext.getClientVersion())) {
            return null;
        }
        TlsPSK[] tlsPSKArray = TlsUtils.a(tlsClient, nArray);
        if (null == tlsPSKArray) {
            return null;
        }
        short[] sArray = tlsClient.getPskKeyExchangeModes();
        if (TlsUtils.isNullOrEmpty(sArray)) {
            throw new TlsFatalAlert(80, "External PSKs configured but no PskKeyExchangeMode available");
        }
        TlsSecret[] tlsSecretArray = TlsUtils.a(tlsClientContext.getCrypto(), tlsPSKArray);
        int n2 = OfferedPsks.a(tlsPSKArray);
        TlsUtils.a(tlsPSKArray, hashtable);
        TlsExtensionsUtils.addPSKKeyExchangeModesExtension(hashtable, sArray);
        return new OfferedPsks.a(tlsPSKArray, sArray, tlsSecretArray, n2);
    }

    static OfferedPsks.a a(TlsClientContext tlsClientContext, OfferedPsks.a a2, Hashtable hashtable) throws IOException {
        SecurityParameters securityParameters = tlsClientContext.getSecurityParametersHandshake();
        int n2 = TlsUtils.a(securityParameters.getCipherSuite());
        Vector vector = TlsUtils.a(a2.a, n2);
        if (vector.isEmpty()) {
            return null;
        }
        OfferedPsks.a a3 = a2;
        int n3 = vector.size();
        if (n3 < a2.a.length) {
            int n4;
            TlsPSK[] tlsPSKArray = new TlsPSK[n3];
            TlsSecret[] tlsSecretArray = new TlsSecret[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = (Integer)vector.elementAt(n4);
                tlsPSKArray[n4] = a2.a[n5];
                tlsSecretArray[n4] = a2.c[n5];
            }
            n4 = OfferedPsks.a(tlsPSKArray);
            a3 = new OfferedPsks.a(tlsPSKArray, a2.b, tlsSecretArray, n4);
        }
        TlsUtils.a(a3.a, hashtable);
        return a3;
    }

    static OfferedPsks.b a(TlsServerContext tlsServerContext, TlsServer tlsServer, Hashtable hashtable, HandshakeMessageInput handshakeMessageInput, TlsHandshakeHash tlsHandshakeHash, boolean bl) throws IOException {
        boolean bl2 = false;
        OfferedPsks offeredPsks = TlsExtensionsUtils.getPreSharedKeyClientHello(hashtable);
        if (null != offeredPsks) {
            int n2;
            TlsPSKExternal tlsPSKExternal;
            short[] sArray = TlsExtensionsUtils.getPSKKeyExchangeModesExtension(hashtable);
            if (TlsUtils.isNullOrEmpty(sArray)) {
                throw new TlsFatalAlert(109);
            }
            if (Arrays.contains(sArray, (short)1) && null != (tlsPSKExternal = tlsServer.getExternalPSK(offeredPsks.getIdentities())) && (n2 = offeredPsks.getIndexOfIdentity(new PskIdentity(tlsPSKExternal.getIdentity(), 0L))) >= 0) {
                byte[] byArray;
                byte[] byArray2 = (byte[])offeredPsks.getBinders().elementAt(n2);
                TlsCrypto tlsCrypto = tlsServerContext.getCrypto();
                TlsSecret tlsSecret = TlsUtils.a(tlsCrypto, tlsPSKExternal);
                boolean bl3 = true;
                int n3 = TlsCryptoUtils.getHashForPRF(tlsPSKExternal.getPRFAlgorithm());
                bl2 = true;
                int n4 = offeredPsks.getBindersSize();
                handshakeMessageInput.a(tlsHandshakeHash, n4);
                if (bl) {
                    byArray = tlsHandshakeHash.getFinalHash(n3);
                } else {
                    TlsHash tlsHash = tlsCrypto.createHash(n3);
                    tlsHandshakeHash.copyBufferTo(new TlsHashOutputStream(tlsHash));
                    byArray = tlsHash.calculateHash();
                }
                handshakeMessageInput.b(tlsHandshakeHash, n4);
                byte[] byArray3 = TlsUtils.a(tlsCrypto, bl3, n3, tlsSecret, byArray);
                if (Arrays.constantTimeAreEqual(byArray3, byArray2)) {
                    return new OfferedPsks.b(n2, tlsPSKExternal, sArray, tlsSecret);
                }
            }
        }
        if (!bl2) {
            handshakeMessageInput.updateHash(tlsHandshakeHash);
        }
        return null;
    }

    static TlsSecret a(TlsCrypto tlsCrypto, TlsPSK tlsPSK) {
        int n2 = TlsCryptoUtils.getHashForPRF(tlsPSK.getPRFAlgorithm());
        return tlsCrypto.hkdfInit(n2).hkdfExtract(n2, tlsPSK.getKey());
    }

    static TlsSecret[] a(TlsCrypto tlsCrypto, TlsPSK[] tlsPSKArray) {
        int n2 = tlsPSKArray.length;
        TlsSecret[] tlsSecretArray = new TlsSecret[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            tlsSecretArray[i2] = TlsUtils.a(tlsCrypto, tlsPSKArray[i2]);
        }
        return tlsSecretArray;
    }

    static TlsPSKExternal[] a(TlsClient tlsClient, int[] nArray) throws IOException {
        Vector vector = tlsClient.getExternalPSKs();
        if (TlsUtils.isNullOrEmpty(vector)) {
            return null;
        }
        int[] nArray2 = TlsUtils.a(nArray);
        int n2 = vector.size();
        TlsPSKExternal[] tlsPSKExternalArray = new TlsPSKExternal[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = vector.elementAt(i2);
            if (!(e2 instanceof TlsPSKExternal)) {
                throw new TlsFatalAlert(80, "External PSKs element is not a TlsPSKExternal");
            }
            TlsPSKExternal tlsPSKExternal = (TlsPSKExternal)e2;
            if (!Arrays.contains(nArray2, tlsPSKExternal.getPRFAlgorithm())) {
                throw new TlsFatalAlert(80, "External PSK incompatible with offered cipher suites");
            }
            tlsPSKExternalArray[i2] = tlsPSKExternal;
        }
        return tlsPSKExternalArray;
    }

    static Vector a(TlsPSK[] tlsPSKArray, int n2) {
        Vector<Integer> vector = new Vector<Integer>(tlsPSKArray.length);
        for (int i2 = 0; i2 < tlsPSKArray.length; ++i2) {
            if (tlsPSKArray[i2].getPRFAlgorithm() != n2) continue;
            vector.add(Integers.valueOf(i2));
        }
        return vector;
    }

    static short a(Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable2);
        if (s3 >= 0 && (!MaxFragmentLength.isValid(s3) || hashtable != null && s3 != TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable))) {
            throw new TlsFatalAlert(s2);
        }
        return s3;
    }

    static short b(Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsExtensionsUtils.getClientCertificateTypeExtensionServer(hashtable2);
        if (s3 < 0) {
            return 0;
        }
        if (!CertificateType.isValid(s3)) {
            throw new TlsFatalAlert(s2, "Unknown value for client_certificate_type");
        }
        short[] sArray = TlsExtensionsUtils.getClientCertificateTypeExtensionClient(hashtable);
        if (sArray == null || !TlsUtils.a(sArray, 0, sArray.length, s3)) {
            throw new TlsFatalAlert(s2, "Invalid selection for client_certificate_type");
        }
        return s3;
    }

    static short c(Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsUtils.b(hashtable, hashtable2, s2);
        return TlsUtils.a(s3, s2);
    }

    static short d(Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsExtensionsUtils.getServerCertificateTypeExtensionServer(hashtable2);
        if (s3 < 0) {
            return 0;
        }
        if (!CertificateType.isValid(s3)) {
            throw new TlsFatalAlert(s2, "Unknown value for server_certificate_type");
        }
        short[] sArray = TlsExtensionsUtils.getServerCertificateTypeExtensionClient(hashtable);
        if (sArray == null || !TlsUtils.a(sArray, 0, sArray.length, s3)) {
            throw new TlsFatalAlert(s2, "Invalid selection for server_certificate_type");
        }
        return s3;
    }

    static short e(Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsUtils.d(hashtable, hashtable2, s2);
        return TlsUtils.a(s3, s2);
    }

    private static short a(short s2, short s3) throws IOException {
        if (1 == s2) {
            throw new TlsFatalAlert(s3, "The OpenPGP certificate type MUST NOT be used with TLS 1.3");
        }
        return s2;
    }
}

