/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPeer;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import com.enterprisedt.bouncycastle.util.Times;
import java.io.IOException;

abstract class a
implements TlsContext {
    private static long a = Times.nanoTime();
    private TlsCrypto b;
    private int c;
    private TlsNonceGenerator d;
    private SecurityParameters e = null;
    private SecurityParameters f = null;
    private ProtocolVersion[] g = null;
    private ProtocolVersion h = null;
    private ProtocolVersion i = null;
    private TlsSession j = null;
    private Object k = null;

    private static synchronized long c() {
        return ++a;
    }

    private static TlsNonceGenerator a(TlsCrypto tlsCrypto, int n2) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(com.enterprisedt.bouncycastle.tls.a.c(), byArray, 0);
        Pack.longToBigEndian(Times.nanoTime(), byArray, 8);
        byArray[0] = (byte)(byArray[0] & 0x7F);
        byArray[0] = (byte)(byArray[0] | (byte)(n2 << 7));
        return tlsCrypto.createNonceGenerator(byArray);
    }

    a(TlsCrypto tlsCrypto, int n2) {
        this.b = tlsCrypto;
        this.c = n2;
        this.d = com.enterprisedt.bouncycastle.tls.a.a(tlsCrypto, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(TlsPeer tlsPeer) throws IOException {
        a a2 = this;
        synchronized (a2) {
            if (null != this.e) {
                throw new TlsFatalAlert(80, "Handshake already started");
            }
            this.e = new SecurityParameters();
            this.e.a = this.c;
            if (null != this.f) {
                this.e.c = true;
                this.e.d = this.f.isSecureRenegotiation();
                this.e.T = this.f.getNegotiatedVersion();
            }
        }
        tlsPeer.notifyHandshakeBeginning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(TlsPeer tlsPeer, TlsSession tlsSession) throws IOException {
        a a2 = this;
        synchronized (a2) {
            if (null == this.e) {
                throw new TlsFatalAlert(80);
            }
            this.j = tlsSession;
            this.f = this.e;
            this.e = null;
        }
        tlsPeer.notifyHandshakeComplete();
    }

    synchronized boolean a() {
        return null != this.f;
    }

    synchronized boolean b() {
        return null != this.e;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.b;
    }

    @Override
    public TlsNonceGenerator getNonceGenerator() {
        return this.d;
    }

    @Override
    public synchronized SecurityParameters getSecurityParameters() {
        return null != this.e ? this.e : this.f;
    }

    @Override
    public synchronized SecurityParameters getSecurityParametersConnection() {
        return this.f;
    }

    @Override
    public synchronized SecurityParameters getSecurityParametersHandshake() {
        return this.e;
    }

    @Override
    public ProtocolVersion[] getClientSupportedVersions() {
        return this.g;
    }

    void a(ProtocolVersion[] protocolVersionArray) {
        this.g = protocolVersionArray;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.h;
    }

    void a(ProtocolVersion protocolVersion) {
        this.h = protocolVersion;
    }

    @Override
    public ProtocolVersion getRSAPreMasterSecretVersion() {
        return this.i;
    }

    void b(ProtocolVersion protocolVersion) {
        this.i = protocolVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.getSecurityParameters().getNegotiatedVersion();
    }

    @Override
    public TlsSession getResumableSession() {
        TlsSession tlsSession = this.getSession();
        if (tlsSession == null || !tlsSession.isResumable()) {
            return null;
        }
        return tlsSession;
    }

    @Override
    public TlsSession getSession() {
        return this.j;
    }

    @Override
    public Object getUserObject() {
        return this.k;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.k = userObject;
    }

    @Override
    public byte[] exportChannelBinding(int channelBinding) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of channel bindings unavailable before handshake completion");
        }
        if (3 == channelBinding) {
            return this.exportKeyingMaterial("EXPORTER-Channel-Binding", TlsUtils.EMPTY_BYTES, 32);
        }
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            return null;
        }
        switch (channelBinding) {
            case 0: {
                byte[] byArray = securityParameters.getTLSServerEndPoint();
                return TlsUtils.isNullOrEmpty(byArray) ? null : Arrays.clone(byArray);
            }
            case 1: {
                return Arrays.clone(securityParameters.getTLSUnique());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] exportEarlyKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters securityParameters = this.getSecurityParametersHandshake();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of early key material only available during handshake");
        }
        return this.a(this.a(securityParameters.getEarlyExporterMasterSecret()), securityParameters.getPRFCryptoHashAlgorithm(), asciiLabel, context, length);
    }

    @Override
    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of key material unavailable before handshake completion");
        }
        if (!securityParameters.isExtendedMasterSecret()) {
            throw new IllegalStateException("Export of key material requires extended_master_secret");
        }
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            return this.a(this.b(securityParameters.getExporterMasterSecret()), securityParameters.getPRFCryptoHashAlgorithm(), asciiLabel, context, length);
        }
        byte[] byArray = TlsUtils.calculateExporterSeed(securityParameters, context);
        return TlsUtils.PRF(securityParameters, this.b(securityParameters.getMasterSecret()), asciiLabel, byArray, length).extract();
    }

    protected byte[] a(TlsSecret tlsSecret, int n2, String string, byte[] byArray, int n3) {
        if (null == byArray) {
            byArray = TlsUtils.EMPTY_BYTES;
        } else if (!TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'context' must have length less than 2^16 (or be null)");
        }
        try {
            TlsHash tlsHash = this.getCrypto().createHash(n2);
            byte[] byArray2 = tlsHash.calculateHash();
            TlsSecret tlsSecret2 = TlsUtils.a(this.getSecurityParametersConnection(), tlsSecret, string, byArray2);
            byte[] byArray3 = byArray2;
            if (byArray.length > 0) {
                tlsHash.update(byArray, 0, byArray.length);
                byArray3 = tlsHash.calculateHash();
            }
            return TlsCryptoUtils.hkdfExpandLabel(tlsSecret2, n2, "exporter", byArray3, n3).extract();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected TlsSecret a(TlsSecret tlsSecret) {
        if (null == tlsSecret) {
            throw new IllegalStateException("Export of early key material not available for this handshake");
        }
        return tlsSecret;
    }

    protected TlsSecret b(TlsSecret tlsSecret) {
        if (null == tlsSecret) {
            throw new IllegalStateException("Export of key material only available from notifyHandshakeComplete()");
        }
        return tlsSecret;
    }
}

