/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Client;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Server;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;

public interface TlsCrypto {
    public boolean hasAnyStreamVerifiers(Vector var1);

    public boolean hasAnyStreamVerifiersLegacy(short[] var1);

    public boolean hasCryptoHashAlgorithm(int var1);

    public boolean hasCryptoSignatureAlgorithm(int var1);

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasHKDFAlgorithm(int var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedGroup(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(short var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSignatureScheme(int var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsCertificate createCertificate(short var1, byte[] var2) throws IOException;

    public TlsCipher createCipher(TlsCryptoParameters var1, int var2, int var3) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(int var1);

    public TlsHMAC createHMAC(int var1);

    public TlsHMAC createHMACForHash(int var1);

    public TlsNonceGenerator createNonceGenerator(byte[] var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);

    public TlsSecret hkdfInit(int var1);
}

