/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDecodeResult;
import com.enterprisedt.bouncycastle.tls.crypto.TlsEncodeResult;
import java.io.IOException;

public class TlsNullNullCipher
implements TlsCipher {
    public static final TlsNullNullCipher INSTANCE = new TlsNullNullCipher();

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        return plaintextLimit;
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        return plaintextLimit;
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        return ciphertextLimit;
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        return ciphertextLimit;
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        byte[] byArray = new byte[headerAllocation + len];
        System.arraycopy(plaintext, offset, byArray, headerAllocation, len);
        return new TlsEncodeResult(byArray, 0, byArray.length, contentType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        return new TlsDecodeResult(ciphertext, offset, len, recordType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return false;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return false;
    }
}

