/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.Tls13Verifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import java.io.IOException;
import java.io.OutputStream;

public final class LegacyTls13Verifier
implements TlsVerifier {
    private final int a;
    private final Tls13Verifier b;

    public LegacyTls13Verifier(int signatureScheme, Tls13Verifier tls13Verifier) {
        if (!TlsUtils.isValidUint16(signatureScheme)) {
            throw new IllegalArgumentException("'signatureScheme'");
        }
        if (tls13Verifier == null) {
            throw new NullPointerException("'tls13Verifier' cannot be null");
        }
        this.a = signatureScheme;
        this.b = tls13Verifier;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.a) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        final byte[] byArray = digitallySigned.getSignature();
        return new TlsStreamVerifier(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                return LegacyTls13Verifier.this.b.getOutputStream();
            }

            @Override
            public boolean isVerified() throws IOException {
                return LegacyTls13Verifier.this.b.verifySignature(byArray);
            }
        };
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }
}

