/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Null;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class RSAUtil {
    private static final byte[] a;
    private static final byte[] b;
    private static final byte[] c;
    private static final byte[] d;
    private static final byte[] e;
    private static final byte[] f;

    public static boolean supportsPKCS1(AlgorithmIdentifier pubKeyAlgID) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = pubKeyAlgID.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals(aSN1ObjectIdentifier) || X509ObjectIdentifiers.id_ea_rsa.equals(aSN1ObjectIdentifier);
    }

    public static boolean supportsPSS_PSS(short signatureAlgorithm, AlgorithmIdentifier pubKeyAlgID) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = pubKeyAlgID.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals(aSN1ObjectIdentifier)) {
            return false;
        }
        ASN1Encodable aSN1Encodable = pubKeyAlgID.getParameters();
        if (null == aSN1Encodable || aSN1Encodable instanceof ASN1Null) {
            switch (signatureAlgorithm) {
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }
        try {
            byArray3 = aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception exception) {
            return false;
        }
        switch (signatureAlgorithm) {
            case 9: {
                byArray2 = a;
                byArray = d;
                break;
            }
            case 10: {
                byArray2 = b;
                byArray = e;
                break;
            }
            case 11: {
                byArray2 = c;
                byArray = f;
                break;
            }
            default: {
                return false;
            }
        }
        return Arrays.areEqual(byArray2, byArray3) || Arrays.areEqual(byArray, byArray3);
    }

    public static boolean supportsPSS_RSAE(AlgorithmIdentifier pubKeyAlgID) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = pubKeyAlgID.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals(aSN1ObjectIdentifier);
    }

    static {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
        AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512);
        AlgorithmIdentifier algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier6 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier7 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier);
        AlgorithmIdentifier algorithmIdentifier8 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier2);
        AlgorithmIdentifier algorithmIdentifier9 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier3);
        AlgorithmIdentifier algorithmIdentifier10 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier4);
        AlgorithmIdentifier algorithmIdentifier11 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier5);
        AlgorithmIdentifier algorithmIdentifier12 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier6);
        ASN1Integer aSN1Integer = new ASN1Integer(TlsCryptoUtils.getHashOutputSize(4));
        ASN1Integer aSN1Integer2 = new ASN1Integer(TlsCryptoUtils.getHashOutputSize(5));
        ASN1Integer aSN1Integer3 = new ASN1Integer(TlsCryptoUtils.getHashOutputSize(6));
        ASN1Integer aSN1Integer4 = new ASN1Integer(1L);
        try {
            a = new RSASSAPSSparams(algorithmIdentifier, algorithmIdentifier7, aSN1Integer, aSN1Integer4).getEncoded("DER");
            b = new RSASSAPSSparams(algorithmIdentifier2, algorithmIdentifier8, aSN1Integer2, aSN1Integer4).getEncoded("DER");
            c = new RSASSAPSSparams(algorithmIdentifier3, algorithmIdentifier9, aSN1Integer3, aSN1Integer4).getEncoded("DER");
            d = new RSASSAPSSparams(algorithmIdentifier4, algorithmIdentifier10, aSN1Integer, aSN1Integer4).getEncoded("DER");
            e = new RSASSAPSSparams(algorithmIdentifier5, algorithmIdentifier11, aSN1Integer2, aSN1Integer4).getEncoded("DER");
            f = new RSASSAPSSparams(algorithmIdentifier6, algorithmIdentifier12, aSN1Integer3, aSN1Integer4).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }
}

