/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDecodeResult;
import com.enterprisedt.bouncycastle.tls.crypto.TlsEncodeResult;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Integers;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public final class TlsBlockCipher
implements TlsCipher {
    private final TlsCryptoParameters a;
    private final byte[] b;
    private final boolean c;
    private final boolean d;
    private final boolean e;
    private final boolean f;
    private final TlsBlockCipherImpl g;
    private final TlsBlockCipherImpl h;
    private final TlsSuiteMac i;
    private final TlsSuiteMac j;
    private final byte[] k;
    private final byte[] l;
    private final boolean m;
    private final boolean n;

    public TlsBlockCipher(TlsCryptoParameters cryptoParams, TlsBlockCipherImpl encryptCipher, TlsBlockCipherImpl decryptCipher, TlsHMAC clientMac, TlsHMAC serverMac, int cipherKeySize) throws IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl;
        TlsBlockCipherImpl tlsBlockCipherImpl2;
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.k = securityParameters.getConnectionIDPeer();
        this.l = securityParameters.getConnectionIDLocal();
        this.m = !Arrays.isNullOrEmpty(this.k);
        this.n = !Arrays.isNullOrEmpty(this.l);
        this.a = cryptoParams;
        this.b = cryptoParams.getNonceGenerator().generateNonce(256);
        this.c = securityParameters.isEncryptThenMAC();
        this.d = TlsImplUtils.isTLSv11(protocolVersion);
        this.e = !protocolVersion.isSSL();
        this.f = securityParameters.isExtendedPadding() && ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion) && (this.c || !securityParameters.isTruncatedHMac());
        this.h = encryptCipher;
        this.g = decryptCipher;
        if (cryptoParams.isServer()) {
            tlsBlockCipherImpl2 = decryptCipher;
            tlsBlockCipherImpl = encryptCipher;
        } else {
            tlsBlockCipherImpl2 = encryptCipher;
            tlsBlockCipherImpl = decryptCipher;
        }
        int n2 = 2 * cipherKeySize + clientMac.getMacLength() + serverMac.getMacLength();
        if (!this.d) {
            n2 += tlsBlockCipherImpl2.getBlockSize() + tlsBlockCipherImpl.getBlockSize();
        }
        byte[] byArray = TlsImplUtils.calculateKeyBlock(cryptoParams, n2);
        int n3 = 0;
        clientMac.setKey(byArray, n3, clientMac.getMacLength());
        serverMac.setKey(byArray, n3 += clientMac.getMacLength(), serverMac.getMacLength());
        tlsBlockCipherImpl2.setKey(byArray, n3 += serverMac.getMacLength(), cipherKeySize);
        tlsBlockCipherImpl.setKey(byArray, n3 += cipherKeySize, cipherKeySize);
        n3 += cipherKeySize;
        int n4 = tlsBlockCipherImpl2.getBlockSize();
        int n5 = tlsBlockCipherImpl.getBlockSize();
        if (this.d) {
            tlsBlockCipherImpl2.init(new byte[n4], 0, n4);
            tlsBlockCipherImpl.init(new byte[n5], 0, n5);
        } else {
            tlsBlockCipherImpl2.init(byArray, n3, n4);
            tlsBlockCipherImpl.init(byArray, n3 += n4, n5);
            n3 += n5;
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.j = new TlsSuiteHMac(cryptoParams, serverMac);
            this.i = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.j = new TlsSuiteHMac(cryptoParams, clientMac);
            this.i = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        int n2 = this.g.getBlockSize();
        int n3 = this.i.getSize();
        int n4 = 256;
        int n5 = plaintextLimit + (this.m ? 1 : 0);
        return this.a(n2, n3, n4, n5);
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        int n2 = this.h.getBlockSize();
        int n3 = this.j.getSize();
        int n4 = this.f ? 256 : n2;
        int n5 = plaintextLimit + (this.n ? 1 : 0);
        return this.a(n2, n3, n4, n5);
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        int n2 = this.g.getBlockSize();
        int n3 = this.i.getSize();
        int n4 = this.a(n2, n3, ciphertextLimit);
        return n4 - (this.m ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        int n2 = this.h.getBlockSize();
        int n3 = this.j.getSize();
        int n4 = this.a(n2, n3, ciphertextLimit);
        return n4 - (this.n ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        int n2;
        int n3;
        int n4 = this.h.getBlockSize();
        int n5 = this.j.getSize();
        int n6 = n3 = len + (this.n ? 1 : 0);
        if (!this.c) {
            n6 += n5;
        }
        int n7 = n4 - n6 % n4;
        if (this.f) {
            n2 = (256 - n7) / n4;
            int n8 = this.a(n2);
            n7 += n8 * n4;
        }
        n2 = n3 + n5 + n7;
        if (this.d) {
            n2 += n4;
        }
        byte[] byArray = new byte[headerAllocation + n2];
        int n9 = headerAllocation;
        if (this.d) {
            byte[] byArray2 = this.a.getNonceGenerator().generateNonce(n4);
            System.arraycopy(byArray2, 0, byArray, n9, n4);
            n9 += n4;
        }
        int n10 = n9;
        System.arraycopy(plaintext, offset, byArray, n9, len);
        n9 += len;
        short s2 = contentType;
        if (this.n) {
            byArray[n9++] = (byte)contentType;
            s2 = 25;
        }
        if (!this.c) {
            byte[] byArray3 = this.j.calculateMac(seqNo, s2, this.l, byArray, n10, n3);
            System.arraycopy(byArray3, 0, byArray, n9, byArray3.length);
            n9 += byArray3.length;
        }
        byte by = (byte)(n7 - 1);
        for (int i2 = 0; i2 < n7; ++i2) {
            byArray[n9++] = by;
        }
        this.h.doFinal(byArray, headerAllocation, n9 - headerAllocation, byArray, headerAllocation);
        if (this.c) {
            byte[] byArray4 = this.j.calculateMac(seqNo, s2, this.l, byArray, headerAllocation, n9 - headerAllocation);
            System.arraycopy(byArray4, 0, byArray, n9, byArray4.length);
            n9 += byArray4.length;
        }
        if (n9 != byArray.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray, 0, byArray.length, s2);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        int n2;
        short s2;
        block9: {
            byte by;
            byte[] byArray;
            boolean bl;
            int n3 = this.g.getBlockSize();
            int n4 = this.i.getSize();
            int n5 = n3;
            n5 = this.c ? (n5 += n4) : Math.max(n5, n4 + 1);
            if (this.d) {
                n5 += n3;
            }
            if (len < n5) {
                throw new TlsFatalAlert(50);
            }
            int n6 = len;
            if (this.c) {
                n6 -= n4;
            }
            if (n6 % n3 != 0) {
                throw new TlsFatalAlert(21);
            }
            if (this.c && !(bl = TlsUtils.constantTimeAreEqual(n4, byArray = this.i.calculateMac(seqNo, recordType, this.k, ciphertext, offset, len - n4), 0, ciphertext, offset + len - n4))) {
                throw new TlsFatalAlert(20);
            }
            this.g.doFinal(ciphertext, offset, n6, ciphertext, offset);
            if (this.d) {
                offset += n3;
                n6 -= n3;
            }
            int n7 = this.a(ciphertext, offset, n6, n3, this.c ? 0 : n4);
            bl = n7 == 0;
            int n8 = n6 - n7;
            if (!this.c) {
                byte[] byArray2 = this.i.calculateMacConstantTime(seqNo, recordType, this.k, ciphertext, offset, n8 -= n4, n6 - n4, this.b);
                bl |= !TlsUtils.constantTimeAreEqual(n4, byArray2, 0, ciphertext, offset + n8);
            }
            if (bl) {
                throw new TlsFatalAlert(20);
            }
            s2 = recordType;
            n2 = n8;
            if (!this.m) break block9;
            do {
                if (--n2 >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (by = ciphertext[offset + n2]));
            s2 = (short)(by & 0xFF);
        }
        return new TlsDecodeResult(ciphertext, offset, n2, s2);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.m;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.n;
    }

    private int a(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n3;
        byte by = byArray[n6 - 1];
        int n7 = by & 0xFF;
        int n8 = n7 + 1;
        int n9 = 0;
        int n10 = 0;
        int n11 = Math.min(this.e ? 256 : n4, n3 - n5);
        if (n8 > n11) {
            n8 = 0;
        } else {
            int n12 = n6 - n8;
            do {
                n10 = (byte)(n10 | byArray[n12++] ^ by);
            } while (n12 < n6);
            n9 = n8;
            if (n10 != 0) {
                n8 = 0;
            }
        }
        byte[] byArray2 = this.b;
        while (n9 < 256) {
            n10 = (byte)(n10 | byArray2[n9++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n10);
        return n8;
    }

    private int a(int n2) {
        byte[] byArray = this.a.getNonceGenerator().generateNonce(4);
        int n3 = Pack.littleEndianToInt(byArray, 0);
        int n4 = Integers.numberOfTrailingZeros(n3);
        return Math.min(n4, n2);
    }

    private int a(int n2, int n3, int n4, int n5) {
        int n6 = n5;
        if (this.d) {
            n6 += n2;
        }
        n6 += n4;
        if (this.c) {
            n6 -= n6 % n2;
            n6 += n3;
        } else {
            n6 += n3;
            n6 -= n6 % n2;
        }
        return n6;
    }

    private int a(int n2, int n3, int n4) {
        int n5 = n4;
        if (this.c) {
            n5 -= n3;
            n5 -= n5 % n2;
        } else {
            n5 -= n5 % n2;
            n5 -= n3;
        }
        --n5;
        if (this.d) {
            n5 -= n2;
        }
        return n5;
    }
}

