/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsMAC;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import com.enterprisedt.bouncycastle.util.Arrays;

public final class TlsSuiteHMac
implements TlsSuiteMac {
    private final TlsCryptoParameters a;
    private final TlsHMAC b;
    private final int c;
    private final int d;
    private final int e;

    private static int a(TlsCryptoParameters tlsCryptoParameters, TlsMAC tlsMAC) {
        int n2 = tlsMAC.getMacLength();
        if (tlsCryptoParameters.getSecurityParametersHandshake().isTruncatedHMac()) {
            n2 = Math.min(n2, 10);
        }
        return n2;
    }

    public TlsSuiteHMac(TlsCryptoParameters cryptoParams, TlsHMAC mac) {
        this.a = cryptoParams;
        this.b = mac;
        this.e = TlsSuiteHMac.a(cryptoParams, mac);
        this.c = mac.getInternalBlockSize();
        this.d = TlsImplUtils.isSSL(cryptoParams) && mac.getMacLength() == 20 ? 4 : this.c / 8;
    }

    @Override
    public int getSize() {
        return this.e;
    }

    @Override
    public byte[] calculateMac(long seqNo, short type, byte[] connectionID, byte[] msg, int msgOff, int msgLen) {
        ProtocolVersion protocolVersion = this.a.getServerVersion();
        if (!Arrays.isNullOrEmpty(connectionID)) {
            int n2 = connectionID.length;
            byte[] byArray = new byte[23 + n2];
            TlsUtils.writeUint64(-1L, byArray, 0);
            TlsUtils.writeUint8((short)25, byArray, 8);
            TlsUtils.writeUint8(n2, byArray, 9);
            TlsUtils.writeUint8((short)25, byArray, 10);
            TlsUtils.writeVersion(protocolVersion, byArray, 11);
            TlsUtils.writeUint64(seqNo, byArray, 13);
            System.arraycopy(connectionID, 0, byArray, 21, n2);
            TlsUtils.writeUint16(msgLen, byArray, 21 + n2);
            this.b.update(byArray, 0, byArray.length);
        } else {
            byte[] byArray = new byte[13];
            TlsUtils.writeUint64(seqNo, byArray, 0);
            TlsUtils.writeUint8(type, byArray, 8);
            TlsUtils.writeVersion(protocolVersion, byArray, 9);
            TlsUtils.writeUint16(msgLen, byArray, 11);
            this.b.update(byArray, 0, byArray.length);
        }
        this.b.update(msg, msgOff, msgLen);
        return this.b(this.b.calculateMAC());
    }

    @Override
    public byte[] calculateMacConstantTime(long seqNo, short type, byte[] connectionID, byte[] msg, int msgOff, int msgLen, int fullLength, byte[] dummyData) {
        byte[] byArray = this.calculateMac(seqNo, type, connectionID, msg, msgOff, msgLen);
        int n2 = this.a(connectionID);
        int n3 = this.a(n2 + fullLength) - this.a(n2 + msgLen);
        while (--n3 >= 0) {
            this.b.update(dummyData, 0, this.c);
        }
        this.b.update(dummyData, 0, 1);
        this.b.reset();
        return byArray;
    }

    private int a(int n2) {
        return (n2 + this.d) / this.c;
    }

    private int a(byte[] byArray) {
        if (TlsImplUtils.isSSL(this.a)) {
            return 11;
        }
        if (!Arrays.isNullOrEmpty(byArray)) {
            return 23 + byArray.length;
        }
        return 13;
    }

    private byte[] b(byte[] byArray) {
        if (byArray.length <= this.e) {
            return byArray;
        }
        return Arrays.copyOf(byArray, this.e);
    }
}

