/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.enterprisedt.bouncycastle.crypto.engines.RSABlindedEngine;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.SecureRandom;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, (RSAKeyParameters)this.privateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, RSAKeyParameters rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion protocolVersion = cryptoParams.getRSAPreMasterSecretVersion();
        boolean bl = false;
        byte[] byArray = new byte[48];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = Arrays.clone(byArray);
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), byArray);
            pKCS1Encoding.init(false, new ParametersWithRandom(rsaServerPrivateKey, secureRandom));
            byArray2 = pKCS1Encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl || TlsImplUtils.isTLSv11(protocolVersion)) {
            int n2 = protocolVersion.getMajorVersion() ^ byArray2[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray2[1] & 0xFF;
            n2 = n2 - 1 >> 31;
            for (int i2 = 0; i2 < 48; ++i2) {
                byArray2[i2] = (byte)(byArray2[i2] & n2 | byArray[i2] & ~n2);
            }
        }
        return this.crypto.createSecret(byArray2);
    }
}

