/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.KeyUsage;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRawKeyCertificate;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsCertificate
extends BcTlsRawKeyCertificate {
    protected final Certificate certificate;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(encoding);
            return Certificate.getInstance(aSN1Primitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TlsFatalAlert(42, (Throwable)illegalArgumentException);
        }
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificate.parseCertificate(encoding));
    }

    public BcTlsCertificate(BcTlsCrypto crypto, Certificate certificate) {
        super(crypto, certificate.getSubjectPublicKeyInfo());
        this.certificate = certificate;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public ASN1Encodable getSigAlgParams() {
        return this.certificate.getSignatureAlgorithm().getParameters();
    }

    @Override
    protected boolean supportsKeyUsage(int keyUsageBits) {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        return extensions == null || (keyUsage = KeyUsage.fromExtensions(extensions)) == null || ((n2 = keyUsage.getBytes()[0] & 0xFF) & keyUsageBits) == keyUsageBits;
    }
}

