/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import java.io.IOException;

public class BcTlsDH
implements TlsAgreement {
    protected final BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateDHAgreement((DHPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

