/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig config;
    protected DHParameters domainParameters;

    private static byte[] a(DHParameters dHParameters, boolean bl, BigInteger bigInteger) {
        return bl ? BigIntegers.asUnsignedByteArray(BcTlsDHDomain.a(dHParameters), bigInteger) : BigIntegers.asUnsignedByteArray(bigInteger);
    }

    private static int a(DHParameters dHParameters) {
        return (dHParameters.getP().bitLength() + 7) / 8;
    }

    public static BcTlsSecret calculateDHAgreement(BcTlsCrypto crypto, DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey, boolean padded) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(privateKey);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(publicKey);
        byte[] byArray = BcTlsDHDomain.a(privateKey.getParameters(), padded, bigInteger);
        return crypto.a(byArray);
    }

    public static DHParameters getDomainParameters(TlsDHConfig dhConfig) {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (dHGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameters(dHGroup.getP(), dHGroup.getG(), dHGroup.getQ(), dHGroup.getL());
    }

    public BcTlsDHDomain(BcTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.config = dhConfig;
        this.domainParameters = BcTlsDHDomain.getDomainParameters(dhConfig);
    }

    public BcTlsSecret calculateDHAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        return BcTlsDHDomain.calculateDHAgreement(this.crypto, privateKey, publicKey, this.config.isPadded());
    }

    @Override
    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] encoding) throws IOException {
        if (this.config.isPadded() && BcTlsDHDomain.a(this.domainParameters) != encoding.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, encoding);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger bigInteger = this.decodeParameter(encoding);
            return new DHPublicKeyParameters(bigInteger, this.domainParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(40, (Throwable)runtimeException);
        }
    }

    public byte[] encodeParameter(BigInteger x) {
        return BcTlsDHDomain.a(this.domainParameters, this.config.isPadded(), x);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters publicKey) {
        return BcTlsDHDomain.a(this.domainParameters, true, publicKey.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.domainParameters));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }
}

