/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.digests.NullDigest;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.DSADigestSigner;
import com.enterprisedt.bouncycastle.crypto.signers.ECDSASigner;
import com.enterprisedt.bouncycastle.crypto.signers.HMacDSAKCalculator;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsECDSA13Signer
extends BcTlsSigner {
    private final int a;

    public BcTlsECDSA13Signer(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey, int signatureScheme) {
        super(crypto, privateKey);
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.a = signatureScheme;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.a) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int n2 = SignatureScheme.getCryptoHashAlgorithm(this.a);
        ECDSASigner eCDSASigner = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(n2)));
        DSADigestSigner dSADigestSigner = new DSADigestSigner(eCDSASigner, new NullDigest());
        dSADigestSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        dSADigestSigner.update(hash, 0, hash.length);
        try {
            return dSADigestSigner.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
    }
}

