/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.engines.RSAEngine;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.PSSSigner;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import java.io.IOException;

public class BcTlsRSAPSSVerifier
extends BcTlsVerifier {
    private final int a;

    public BcTlsRSAPSSVerifier(BcTlsCrypto crypto, RSAKeyParameters publicKey, int signatureScheme) {
        super(crypto, publicKey);
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.a = signatureScheme;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] hash) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.a) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n2 = SignatureScheme.getCryptoHashAlgorithm(this.a);
        Digest digest = this.crypto.createDigest(n2);
        PSSSigner pSSSigner = PSSSigner.createRawSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest, digest.getDigestSize(), (byte)-68);
        pSSSigner.init(false, this.publicKey);
        pSSSigner.update(hash, 0, hash.length);
        return pSSSigner.verifySignature(digitallySigned.getSignature());
    }
}

