/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.engines.RSAEngine;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.DSADigestSigner;
import com.enterprisedt.bouncycastle.crypto.signers.ECDSASigner;
import com.enterprisedt.bouncycastle.crypto.signers.Ed25519Signer;
import com.enterprisedt.bouncycastle.crypto.signers.Ed448Signer;
import com.enterprisedt.bouncycastle.crypto.signers.PSSSigner;
import com.enterprisedt.bouncycastle.crypto.signers.RSADigestSigner;
import com.enterprisedt.bouncycastle.crypto.util.PublicKeyFactory;
import com.enterprisedt.bouncycastle.tls.SignatureScheme;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.Tls13Verifier;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsEncryptor;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.LegacyTls13Verifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.RSAUtil;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.b;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.h;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsRawKeyCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final SubjectPublicKeyInfo keyInfo;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected Ed25519PublicKeyParameters pubKeyEd25519 = null;
    protected Ed448PublicKeyParameters pubKeyEd448 = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public BcTlsRawKeyCertificate(BcTlsCrypto crypto, byte[] keyInfo) {
        this(crypto, SubjectPublicKeyInfo.getInstance(keyInfo));
    }

    public BcTlsRawKeyCertificate(BcTlsCrypto crypto, SubjectPublicKeyInfo keyInfo) {
        this.crypto = crypto;
        this.keyInfo = keyInfo;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.keyInfo;
    }

    @Override
    public TlsEncryptor createEncryptor(int tlsCertificateRole) throws IOException {
        this.validateKeyUsage(32);
        switch (tlsCertificateRole) {
            case 3: {
                this.pubKeyRSA = this.getPubKeyRSA();
                return new h(this.crypto, this.pubKeyRSA);
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 7: 
            case 8: {
                int n2 = SignatureScheme.from((short)8, signatureAlgorithm);
                Tls13Verifier tls13Verifier = this.createVerifier(n2);
                return new LegacyTls13Verifier(n2, tls13Verifier);
            }
        }
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                this.validateRSA_PKCS1();
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 9: 
            case 10: 
            case 11: {
                this.validateRSA_PSS_PSS(signatureAlgorithm);
                int n3 = SignatureScheme.from((short)8, signatureAlgorithm);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n3);
            }
            case 4: 
            case 5: 
            case 6: {
                this.validateRSA_PSS_RSAE();
                int n4 = SignatureScheme.from((short)8, signatureAlgorithm);
                return new BcTlsRSAPSSVerifier(this.crypto, this.getPubKeyRSA(), n4);
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public Tls13Verifier createVerifier(int signatureScheme) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureScheme) {
            case 515: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                int n2 = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(n2);
                DSADigestSigner dSADigestSigner = new DSADigestSigner(new ECDSASigner(), digest);
                dSADigestSigner.init(false, this.getPubKeyEC());
                return new b(dSADigestSigner);
            }
            case 2055: {
                Ed25519Signer ed25519Signer = new Ed25519Signer();
                ed25519Signer.init(false, this.getPubKeyEd25519());
                return new b(ed25519Signer);
            }
            case 2056: {
                Ed448Signer ed448Signer = new Ed448Signer(TlsUtils.EMPTY_BYTES);
                ed448Signer.init(false, this.getPubKeyEd448());
                return new b(ed448Signer);
            }
            case 513: 
            case 1025: 
            case 1281: 
            case 1537: {
                this.validateRSA_PKCS1();
                int n3 = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(n3);
                RSADigestSigner rSADigestSigner = new RSADigestSigner(digest, TlsCryptoUtils.getOIDForHash(n3));
                rSADigestSigner.init(false, this.getPubKeyRSA());
                return new b(rSADigestSigner);
            }
            case 2057: 
            case 2058: 
            case 2059: {
                this.validateRSA_PSS_PSS(SignatureScheme.getSignatureAlgorithm(signatureScheme));
                int n4 = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(n4);
                PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                pSSSigner.init(false, this.getPubKeyRSA());
                return new b(pSSSigner);
            }
            case 2052: 
            case 2053: 
            case 2054: {
                this.validateRSA_PSS_RSAE();
                int n5 = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                Digest digest = this.crypto.createDigest(n5);
                PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
                pSSSigner.init(false, this.getPubKeyRSA());
                return new b(pSSSigner);
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.keyInfo.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return null;
    }

    @Override
    public String getSigAlgOID() {
        return null;
    }

    @Override
    public ASN1Encodable getSigAlgParams() {
        return null;
    }

    @Override
    public short getLegacySignatureAlgorithm() throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        if (asymmetricKeyParameter.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        if (!this.supportsKeyUsage(128)) {
            return -1;
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            return 1;
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            return 2;
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            return 3;
        }
        return -1;
    }

    public DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        try {
            return (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        try {
            return (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public Ed25519PublicKeyParameters getPubKeyEd25519() throws IOException {
        try {
            return (Ed25519PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public Ed448PublicKeyParameters getPubKeyEd448() throws IOException {
        try {
            return (Ed448PublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        try {
            return (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
    }

    @Override
    public boolean supportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 128);
    }

    @Override
    public boolean supportsSignatureAlgorithmCA(short signatureAlgorithm) throws IOException {
        return this.supportsSignatureAlgorithm(signatureAlgorithm, 4);
    }

    @Override
    public TlsCertificate checkUsageInRole(int tlsCertificateRole) throws IOException {
        switch (tlsCertificateRole) {
            case 1: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 2: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        try {
            return PublicKeyFactory.createKey(this.keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    protected boolean supportsKeyUsage(int keyUsageBits) {
        return true;
    }

    protected boolean supportsRSA_PKCS1() {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPKCS1(algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_PSS(short signatureAlgorithm) {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_PSS(signatureAlgorithm, algorithmIdentifier);
    }

    protected boolean supportsRSA_PSS_RSAE() {
        AlgorithmIdentifier algorithmIdentifier = this.keyInfo.getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(algorithmIdentifier);
    }

    protected boolean supportsSignatureAlgorithm(short signatureAlgorithm, int keyUsage) throws IOException {
        if (!this.supportsKeyUsage(keyUsage)) {
            return false;
        }
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        switch (signatureAlgorithm) {
            case 1: {
                return this.supportsRSA_PKCS1() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 2: {
                return asymmetricKeyParameter instanceof DSAPublicKeyParameters;
            }
            case 3: 
            case 26: 
            case 27: 
            case 28: {
                return asymmetricKeyParameter instanceof ECPublicKeyParameters;
            }
            case 7: {
                return asymmetricKeyParameter instanceof Ed25519PublicKeyParameters;
            }
            case 8: {
                return asymmetricKeyParameter instanceof Ed448PublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(signatureAlgorithm) && asymmetricKeyParameter instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    public void validateKeyUsage(int keyUsageBits) throws IOException {
        if (!this.supportsKeyUsage(keyUsageBits)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        if (!this.supportsRSA_PSS_PSS(signatureAlgorithm)) {
            throw new TlsFatalAlert(46);
        }
    }

    protected void validateRSA_PSS_RSAE() throws IOException {
        if (!this.supportsRSA_PSS_RSAE()) {
            throw new TlsFatalAlert(46);
        }
    }
}

