/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    private static final byte[] a = BcTlsSecret.b();
    protected final BcTlsCrypto crypto;

    public static BcTlsSecret convert(BcTlsCrypto crypto, TlsSecret secret) {
        if (secret instanceof BcTlsSecret) {
            return (BcTlsSecret)secret;
        }
        if (secret instanceof AbstractTlsSecret) {
            AbstractTlsSecret abstractTlsSecret = (AbstractTlsSecret)secret;
            return crypto.a(BcTlsSecret.copyData(abstractTlsSecret));
        }
        throw new IllegalArgumentException("unrecognized TlsSecret - cannot copy data: " + secret.getClass().getName());
    }

    private static byte[] b() {
        int n2 = 15;
        byte[] byArray = new byte[n2 * (n2 + 1) / 2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = (byte)(65 + i2);
            for (int i3 = 0; i3 <= i2; ++i3) {
                byArray[n3++] = by;
            }
        }
        return byArray;
    }

    public BcTlsSecret(BcTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        try {
            switch (prfAlgorithm) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 4, label, seed, length);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 5, label, seed, length);
                }
                case 7: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 7, label, seed, length);
                }
            }
            return this.crypto.a(this.prf(prfAlgorithm, label, seed, length));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public synchronized TlsSecret hkdfExpand(int cryptoHashAlgorithm, byte[] info, int length) {
        int n2;
        if (length < 1) {
            return this.crypto.a(TlsUtils.EMPTY_BYTES);
        }
        int n3 = TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm);
        if (length > 255 * n3) {
            throw new IllegalArgumentException("'length' must be <= 255 * (output size of 'hashAlgorithm')");
        }
        this.checkAlive();
        byte[] byArray = this.data;
        HMac hMac = new HMac(this.crypto.createDigest(cryptoHashAlgorithm));
        hMac.init(new KeyParameter(byArray));
        byte[] byArray2 = new byte[length];
        byte[] byArray3 = new byte[n3];
        byte by = 0;
        int n4 = 0;
        while (true) {
            hMac.update(info, 0, info.length);
            by = (byte)(by + 1);
            hMac.update(by);
            hMac.doFinal(byArray3, 0);
            n2 = length - n4;
            if (n2 <= n3) break;
            System.arraycopy(byArray3, 0, byArray2, n4, n3);
            n4 += n3;
            hMac.update(byArray3, 0, byArray3.length);
        }
        System.arraycopy(byArray3, 0, byArray2, n4, n2);
        return this.crypto.a(byArray2);
    }

    @Override
    public synchronized TlsSecret hkdfExtract(int cryptoHashAlgorithm, TlsSecret ikm) {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        HMac hMac = new HMac(this.crypto.createDigest(cryptoHashAlgorithm));
        hMac.init(new KeyParameter(byArray));
        BcTlsSecret.convert(this.crypto, ikm).updateMac(hMac);
        byte[] byArray2 = new byte[hMac.getMacSize()];
        hMac.doFinal(byArray2, 0);
        return this.crypto.a(byArray2);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(int cryptoHashAlgorithm, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) {
        Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
        HMac hMac = new HMac(digest);
        hMac.init(new KeyParameter(secret, secretOff, secretLen));
        byte[] byArray = seed;
        int n2 = hMac.getMacSize();
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        for (int i2 = 0; i2 < output.length; i2 += n2) {
            hMac.update(byArray, 0, byArray.length);
            hMac.doFinal(byArray2, 0);
            byArray = byArray2;
            hMac.update(byArray, 0, byArray.length);
            hMac.update(seed, 0, seed.length);
            hMac.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, output, i2, Math.min(n2, output.length - i2));
        }
    }

    protected byte[] prf(int prfAlgorithm, String label, byte[] seed, int length) {
        if (0 == prfAlgorithm) {
            return this.prf_SSL(seed, length);
        }
        byte[] byArray = Arrays.concatenate(Strings.toByteArray(label), seed);
        if (1 == prfAlgorithm) {
            return this.prf_1_0(byArray, length);
        }
        return this.prf_1_2(prfAlgorithm, byArray, length);
    }

    protected byte[] prf_SSL(byte[] seed, int length) {
        Digest digest = this.crypto.createDigest(1);
        Digest digest2 = this.crypto.createDigest(2);
        int n2 = digest.getDigestSize();
        int n3 = digest2.getDigestSize();
        byte[] byArray = new byte[Math.max(n2, n3)];
        byte[] byArray2 = new byte[length];
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < length) {
            digest2.update(a, n5, n4);
            n5 += n4++;
            digest2.update(this.data, 0, this.data.length);
            digest2.update(seed, 0, seed.length);
            digest2.doFinal(byArray, 0);
            digest.update(this.data, 0, this.data.length);
            digest.update(byArray, 0, n3);
            int n7 = length - n6;
            if (n7 < n2) {
                digest.doFinal(byArray, 0);
                System.arraycopy(byArray, 0, byArray2, n6, n7);
                n6 += n7;
                continue;
            }
            digest.doFinal(byArray2, n6);
            n6 += n2;
        }
        return byArray2;
    }

    protected byte[] prf_1_0(byte[] labelSeed, int length) {
        int n2 = (this.data.length + 1) / 2;
        byte[] byArray = new byte[length];
        this.hmacHash(1, this.data, 0, n2, labelSeed, byArray);
        byte[] byArray2 = new byte[length];
        this.hmacHash(2, this.data, this.data.length - n2, n2, labelSeed, byArray2);
        for (int i2 = 0; i2 < length; ++i2) {
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
        }
        return byArray;
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] labelSeed, int length) {
        int n2 = TlsCryptoUtils.getHashForPRF(prfAlgorithm);
        byte[] byArray = new byte[length];
        this.hmacHash(n2, this.data, 0, this.data.length, labelSeed, byArray);
        return byArray;
    }

    protected synchronized void updateMac(Mac mac) {
        this.checkAlive();
        mac.update(this.data, 0, this.data.length);
    }
}

