/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

public abstract class Pack {
    public static short bigEndianToShort(byte[] bs, int off) {
        int n2 = (bs[off] & 0xFF) << 8;
        return (short)(n2 |= bs[++off] & 0xFF);
    }

    public static int bigEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] << 24;
        n2 |= (bs[++off] & 0xFF) << 16;
        n2 |= (bs[++off] & 0xFF) << 8;
        return n2 |= bs[++off] & 0xFF;
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.bigEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns, int nsOff, int nsLen) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            ns[nsOff + i2] = Pack.bigEndianToInt(bs, off);
            off += 4;
        }
    }

    public static byte[] intToBigEndian(int n2) {
        byte[] byArray = new byte[4];
        Pack.intToBigEndian(n2, byArray, 0);
        return byArray;
    }

    public static void intToBigEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)(n2 >>> 24);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)n2;
    }

    public static byte[] intToBigEndian(int[] ns) {
        byte[] byArray = new byte[4 * ns.length];
        Pack.intToBigEndian(ns, byArray, 0);
        return byArray;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.intToBigEndian(ns[i2], bs, off);
            off += 4;
        }
    }

    public static void intToBigEndian(int[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            Pack.intToBigEndian(ns[nsOff + i2], bs, bsOff);
            bsOff += 4;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int n2 = Pack.bigEndianToInt(bs, off);
        int n3 = Pack.bigEndianToInt(bs, off + 4);
        return ((long)n2 & 0xFFFFFFFFL) << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    public static void bigEndianToLong(byte[] bs, int off, long[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.bigEndianToLong(bs, off);
            off += 8;
        }
    }

    public static void bigEndianToLong(byte[] bs, int bsOff, long[] ns, int nsOff, int nsLen) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            ns[nsOff + i2] = Pack.bigEndianToLong(bs, bsOff);
            bsOff += 8;
        }
    }

    public static byte[] longToBigEndian(long n2) {
        byte[] byArray = new byte[8];
        Pack.longToBigEndian(n2, byArray, 0);
        return byArray;
    }

    public static void longToBigEndian(long n2, byte[] bs, int off) {
        Pack.intToBigEndian((int)(n2 >>> 32), bs, off);
        Pack.intToBigEndian((int)(n2 & 0xFFFFFFFFL), bs, off + 4);
    }

    public static byte[] longToBigEndian(long[] ns) {
        byte[] byArray = new byte[8 * ns.length];
        Pack.longToBigEndian(ns, byArray, 0);
        return byArray;
    }

    public static void longToBigEndian(long[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.longToBigEndian(ns[i2], bs, off);
            off += 8;
        }
    }

    public static void longToBigEndian(long[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            Pack.longToBigEndian(ns[nsOff + i2], bs, bsOff);
            bsOff += 8;
        }
    }

    public static void longToBigEndian(long value, byte[] bs, int off, int bytes) {
        for (int i2 = bytes - 1; i2 >= 0; --i2) {
            bs[i2 + off] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
    }

    public static short littleEndianToShort(byte[] bs, int off) {
        int n2 = bs[off] & 0xFF;
        return (short)(n2 |= (bs[++off] & 0xFF) << 8);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] & 0xFF;
        n2 |= (bs[++off] & 0xFF) << 8;
        n2 |= (bs[++off] & 0xFF) << 16;
        return n2 |= bs[++off] << 24;
    }

    public static int littleEndianToInt_High(byte[] bs, int off, int len) {
        return Pack.littleEndianToInt_Low(bs, off, len) << (4 - len << 3);
    }

    public static int littleEndianToInt_Low(byte[] bs, int off, int len) {
        int n2 = bs[off] & 0xFF;
        int n3 = 0;
        for (int i2 = 1; i2 < len; ++i2) {
            n2 |= (bs[off + i2] & 0xFF) << (n3 += 8);
        }
        return n2;
    }

    public static void littleEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.littleEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void littleEndianToInt(byte[] bs, int bOff, int[] ns, int nOff, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            ns[nOff + i2] = Pack.littleEndianToInt(bs, bOff);
            bOff += 4;
        }
    }

    public static int[] littleEndianToInt(byte[] bs, int off, int count) {
        int[] nArray = new int[count];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Pack.littleEndianToInt(bs, off);
            off += 4;
        }
        return nArray;
    }

    public static byte[] shortToLittleEndian(short n2) {
        byte[] byArray = new byte[2];
        Pack.shortToLittleEndian(n2, byArray, 0);
        return byArray;
    }

    public static void shortToLittleEndian(short n2, byte[] bs, int off) {
        bs[off] = (byte)n2;
        bs[++off] = (byte)(n2 >>> 8);
    }

    public static byte[] shortToBigEndian(short n2) {
        byte[] byArray = new byte[2];
        Pack.shortToBigEndian(n2, byArray, 0);
        return byArray;
    }

    public static void shortToBigEndian(short n2, byte[] bs, int off) {
        bs[off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)n2;
    }

    public static byte[] intToLittleEndian(int n2) {
        byte[] byArray = new byte[4];
        Pack.intToLittleEndian(n2, byArray, 0);
        return byArray;
    }

    public static void intToLittleEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)n2;
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 24);
    }

    public static byte[] intToLittleEndian(int[] ns) {
        byte[] byArray = new byte[4 * ns.length];
        Pack.intToLittleEndian(ns, byArray, 0);
        return byArray;
    }

    public static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.intToLittleEndian(ns[i2], bs, off);
            off += 4;
        }
    }

    public static void intToLittleEndian(int[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            Pack.intToLittleEndian(ns[nsOff + i2], bs, bsOff);
            bsOff += 4;
        }
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int n2 = Pack.littleEndianToInt(bs, off);
        int n3 = Pack.littleEndianToInt(bs, off + 4);
        return ((long)n3 & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static void littleEndianToLong(byte[] bs, int off, long[] ns) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            ns[i2] = Pack.littleEndianToLong(bs, off);
            off += 8;
        }
    }

    public static void littleEndianToLong(byte[] bs, int bsOff, long[] ns, int nsOff, int nsLen) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            ns[nsOff + i2] = Pack.littleEndianToLong(bs, bsOff);
            bsOff += 8;
        }
    }

    public static void longToLittleEndian_High(long n2, byte[] bs, int off, int len) {
        int n3 = 56;
        bs[off] = (byte)(n2 >>> n3);
        for (int i2 = 1; i2 < len; ++i2) {
            bs[off + i2] = (byte)(n2 >>> (n3 -= 8));
        }
    }

    public static long littleEndianToLong_High(byte[] bs, int off, int len) {
        return Pack.littleEndianToLong_Low(bs, off, len) << (8 - len << 3);
    }

    public static long littleEndianToLong_Low(byte[] bs, int off, int len) {
        long l2 = bs[off] & 0xFF;
        for (int i2 = 1; i2 < len; ++i2) {
            l2 <<= 8;
            l2 |= (long)(bs[off + i2] & 0xFF);
        }
        return l2;
    }

    public static byte[] longToLittleEndian(long n2) {
        byte[] byArray = new byte[8];
        Pack.longToLittleEndian(n2, byArray, 0);
        return byArray;
    }

    public static void longToLittleEndian(long n2, byte[] bs, int off) {
        Pack.intToLittleEndian((int)(n2 & 0xFFFFFFFFL), bs, off);
        Pack.intToLittleEndian((int)(n2 >>> 32), bs, off + 4);
    }

    public static byte[] longToLittleEndian(long[] ns) {
        byte[] byArray = new byte[8 * ns.length];
        Pack.longToLittleEndian(ns, byArray, 0);
        return byArray;
    }

    public static void longToLittleEndian(long[] ns, byte[] bs, int off) {
        for (int i2 = 0; i2 < ns.length; ++i2) {
            Pack.longToLittleEndian(ns[i2], bs, off);
            off += 8;
        }
    }

    public static void longToLittleEndian(long[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        for (int i2 = 0; i2 < nsLen; ++i2) {
            Pack.longToLittleEndian(ns[nsOff + i2], bs, bsOff);
            bsOff += 8;
        }
    }
}

