/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import com.enterprisedt.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Properties {
    public static final String EMULATE_ORACLE = "com.enterprisedt.bouncycastle.emulate.oracle";
    private static final ThreadLocal a = new ThreadLocal();

    private Properties() {
    }

    public static boolean isOverrideSet(String propertyName) {
        try {
            return Properties.b(Properties.getPropertyValue(propertyName));
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean isOverrideSetTo(String propertyName, boolean isTrue) {
        try {
            String string = Properties.getPropertyValue(propertyName);
            if (isTrue) {
                return Properties.b(string);
            }
            return Properties.a(string);
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean setThreadOverride(String propertyName, boolean enable) {
        boolean bl = Properties.isOverrideSet(propertyName);
        HashMap<String, String> hashMap = (HashMap<String, String>)a.get();
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            a.set(hashMap);
        }
        hashMap.put(propertyName, enable ? "true" : "false");
        return bl;
    }

    public static boolean removeThreadOverride(String propertyName) {
        String string;
        Map map = (Map)a.get();
        if (map != null && (string = (String)map.remove(propertyName)) != null) {
            if (map.isEmpty()) {
                a.remove();
            }
            return "true".equals(Strings.toLowerCase(string));
        }
        return false;
    }

    public static int asInteger(String propertyName, int defaultValue) {
        String string = Properties.getPropertyValue(propertyName);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return defaultValue;
    }

    public static BigInteger asBigInteger(String propertyName) {
        String string = Properties.getPropertyValue(propertyName);
        if (string != null) {
            return new BigInteger(string);
        }
        return null;
    }

    public static Set<String> asKeySet(String propertyName) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = Properties.getPropertyValue(propertyName);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                hashSet.add(Strings.toLowerCase(stringTokenizer.nextToken()).trim());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static String getPropertyValue(final String propertyName) {
        String string;
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(propertyName);
            }
        });
        if (string2 != null) {
            return string2;
        }
        Map map = (Map)a.get();
        if (map != null && (string = (String)map.get(propertyName)) != null) {
            return string;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        });
    }

    public static String getPropertyValue(String propertyName, String defValue) {
        String string = Properties.getPropertyValue(propertyName);
        if (string == null) {
            return defValue;
        }
        return string;
    }

    private static boolean a(String string) {
        if (string == null || string.length() != 5) {
            return false;
        }
        return !(string.charAt(0) != 'f' && string.charAt(0) != 'F' || string.charAt(1) != 'a' && string.charAt(1) != 'A' || string.charAt(2) != 'l' && string.charAt(2) != 'L' || string.charAt(3) != 's' && string.charAt(3) != 'S' || string.charAt(4) != 'e' && string.charAt(4) != 'E');
    }

    private static boolean b(String string) {
        if (string == null || string.length() != 4) {
            return false;
        }
        return !(string.charAt(0) != 't' && string.charAt(0) != 'T' || string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
    }
}

