/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class Base32Encoder
implements Encoder {
    private static final byte[] a = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private final byte[] b;
    private final byte c;
    private final byte[] d = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.d.length; ++n2) {
            this.d[n2] = -1;
        }
        for (n2 = 0; n2 < this.b.length; ++n2) {
            this.d[this.b[n2]] = (byte)n2;
        }
    }

    public Base32Encoder() {
        this.b = a;
        this.c = (byte)61;
        this.initialiseDecodingTable();
    }

    public Base32Encoder(byte[] encodingTable, byte padding) {
        if (encodingTable.length != 32) {
            throw new IllegalArgumentException("encoding table needs to be length 32");
        }
        this.b = Arrays.clone(encodingTable);
        this.c = padding;
        this.initialiseDecodingTable();
    }

    public int encode(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) throws IOException {
        int n2 = inOff;
        int n3 = inOff + inLen - 4;
        int n4 = outOff;
        while (n2 < n3) {
            this.a(inBuf, n2, outBuf, n4);
            n2 += 5;
            n4 += 8;
        }
        int n5 = inLen - (n2 - inOff);
        if (n5 > 0) {
            byte[] byArray = new byte[5];
            System.arraycopy(inBuf, n2, byArray, 0, n5);
            this.a(byArray, 0, outBuf, n4);
            switch (n5) {
                case 1: {
                    outBuf[n4 + 2] = this.c;
                    outBuf[n4 + 3] = this.c;
                    outBuf[n4 + 4] = this.c;
                    outBuf[n4 + 5] = this.c;
                    outBuf[n4 + 6] = this.c;
                    outBuf[n4 + 7] = this.c;
                    break;
                }
                case 2: {
                    outBuf[n4 + 4] = this.c;
                    outBuf[n4 + 5] = this.c;
                    outBuf[n4 + 6] = this.c;
                    outBuf[n4 + 7] = this.c;
                    break;
                }
                case 3: {
                    outBuf[n4 + 5] = this.c;
                    outBuf[n4 + 6] = this.c;
                    outBuf[n4 + 7] = this.c;
                    break;
                }
                case 4: {
                    outBuf[n4 + 7] = this.c;
                }
            }
            n4 += 8;
        }
        return n4 - outOff;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byte by = byArray[n2++];
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        int n7 = byArray[n2] & 0xFF;
        byArray2[n3++] = this.b[by >>> 3 & 0x1F];
        byArray2[n3++] = this.b[(by << 2 | n4 >>> 6) & 0x1F];
        byArray2[n3++] = this.b[n4 >>> 1 & 0x1F];
        byArray2[n3++] = this.b[(n4 << 4 | n5 >>> 4) & 0x1F];
        byArray2[n3++] = this.b[(n5 << 1 | n6 >>> 7) & 0x1F];
        byArray2[n3++] = this.b[n6 >>> 2 & 0x1F];
        byArray2[n3++] = this.b[(n6 << 3 | n7 >>> 5) & 0x1F];
        byArray2[n3] = this.b[n7 & 0x1F];
    }

    @Override
    public int getEncodedLength(int inputLength) {
        return (inputLength + 4) / 5 * 8;
    }

    @Override
    public int getMaxDecodedLength(int inputLength) {
        return inputLength / 8 * 5;
    }

    @Override
    public int encode(byte[] buf, int off, int len, OutputStream out) throws IOException {
        int n2;
        if (len < 0) {
            return 0;
        }
        byte[] byArray = new byte[72];
        for (int i2 = len; i2 > 0; i2 -= n2) {
            n2 = Math.min(45, i2);
            int n3 = this.encode(buf, off, n2, byArray, 0);
            out.write(byArray, 0, n3);
            off += n2;
        }
        return (len + 2) / 3 * 4;
    }

    private boolean a(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[55];
        int n4 = 0;
        int n5 = 0;
        for (n3 = off + length; n3 > off && this.a((char)data[n3 - 1]); --n3) {
        }
        if (n3 == 0) {
            return 0;
        }
        int n6 = 0;
        for (n2 = n3; n2 > off && n6 != 8; --n2) {
            if (this.a((char)data[n2 - 1])) continue;
            ++n6;
        }
        n6 = this.a(data, off, n2);
        while (n6 < n2) {
            byte by;
            byte by2 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by3 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by4 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by5 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by6 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by7 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by8 = this.d[data[n6++]];
            n6 = this.a(data, n6, n2);
            if ((by2 | by3 | by4 | by5 | by6 | by7 | by8 | (by = this.d[data[n6++]])) < 0) {
                throw new IOException("invalid characters encountered in base32 data");
            }
            byArray[n4++] = (byte)(by2 << 3 | by3 >> 2);
            byArray[n4++] = (byte)(by3 << 6 | by4 << 1 | by5 >> 4);
            byArray[n4++] = (byte)(by5 << 4 | by6 >> 1);
            byArray[n4++] = (byte)(by6 << 7 | by7 << 2 | by8 >> 3);
            byArray[n4++] = (byte)(by8 << 5 | by);
            if (n4 == byArray.length) {
                out.write(byArray);
                n4 = 0;
            }
            n5 += 5;
            n6 = this.a(data, n6, n2);
        }
        if (n4 > 0) {
            out.write(byArray, 0, n4);
        }
        int n7 = this.a(data, n6, n3);
        int n8 = this.a(data, n7 + 1, n3);
        int n9 = this.a(data, n8 + 1, n3);
        int n10 = this.a(data, n9 + 1, n3);
        int n11 = this.a(data, n10 + 1, n3);
        int n12 = this.a(data, n11 + 1, n3);
        int n13 = this.a(data, n12 + 1, n3);
        int n14 = this.a(data, n13 + 1, n3);
        return n5 += this.a(out, (char)data[n7], (char)data[n8], (char)data[n9], (char)data[n10], (char)data[n11], (char)data[n12], (char)data[n13], (char)data[n14]);
    }

    private int a(byte[] byArray, int n2, int n3) {
        while (n2 < n3 && this.a((char)byArray[n2])) {
            ++n2;
        }
        return n2;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        byte[] byArray = Strings.toByteArray(data);
        return this.decode(byArray, 0, byArray.length, out);
    }

    private int a(OutputStream outputStream, char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) throws IOException {
        if (c9 == this.c) {
            if (c8 != this.c) {
                byte by = this.d[c2];
                byte by2 = this.d[c3];
                byte by3 = this.d[c4];
                byte by4 = this.d[c5];
                byte by5 = this.d[c6];
                byte by6 = this.d[c7];
                byte by7 = this.d[c8];
                if ((by | by2 | by3 | by4 | by5 | by6 | by7) < 0) {
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                outputStream.write(by << 3 | by2 >> 2);
                outputStream.write(by2 << 6 | by3 << 1 | by4 >> 4);
                outputStream.write(by4 << 4 | by5 >> 1);
                outputStream.write(by5 << 7 | by6 << 2 | by7 >> 3);
                return 4;
            }
            if (c7 != this.c) {
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            if (c6 != this.c) {
                byte by = this.d[c2];
                byte by8 = this.d[c3];
                byte by9 = this.d[c4];
                byte by10 = this.d[c5];
                byte by11 = this.d[c6];
                if ((by | by8 | by9 | by10 | by11) < 0) {
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                outputStream.write(by << 3 | by8 >> 2);
                outputStream.write(by8 << 6 | by9 << 1 | by10 >> 4);
                outputStream.write(by10 << 4 | by11 >> 1);
                return 3;
            }
            if (c5 != this.c) {
                byte by = this.d[c2];
                byte by12 = this.d[c3];
                byte by13 = this.d[c4];
                byte by14 = this.d[c5];
                if ((by | by12 | by13 | by14) < 0) {
                    throw new IOException("invalid characters encountered at end of base32 data");
                }
                outputStream.write(by << 3 | by12 >> 2);
                outputStream.write(by12 << 6 | by13 << 1 | by14 >> 4);
                return 2;
            }
            if (c4 != this.c) {
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            byte by = this.d[c2];
            byte by15 = this.d[c3];
            if ((by | by15) < 0) {
                throw new IOException("invalid characters encountered at end of base32 data");
            }
            outputStream.write(by << 3 | by15 >> 2);
            return 1;
        }
        byte by = this.d[c2];
        byte by16 = this.d[c3];
        byte by17 = this.d[c4];
        byte by18 = this.d[c5];
        byte by19 = this.d[c6];
        byte by20 = this.d[c7];
        byte by21 = this.d[c8];
        byte by22 = this.d[c9];
        if ((by | by16 | by17 | by18 | by19 | by20 | by21 | by22) < 0) {
            throw new IOException("invalid characters encountered at end of base32 data");
        }
        outputStream.write(by << 3 | by16 >> 2);
        outputStream.write(by16 << 6 | by17 << 1 | by18 >> 4);
        outputStream.write(by18 << 4 | by19 >> 1);
        outputStream.write(by19 << 7 | by20 << 2 | by21 >> 3);
        outputStream.write(by21 << 5 | by22);
        return 5;
    }
}

