/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.decodingTable.length; ++n2) {
            this.decodingTable[n2] = -1;
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.decodingTable[this.encodingTable[n2]] = (byte)n2;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) throws IOException {
        int n2;
        int n3;
        int n4 = inOff;
        int n5 = inOff + inLen - 2;
        int n6 = outOff;
        while (n4 < n5) {
            n3 = inBuf[n4++];
            n2 = inBuf[n4++] & 0xFF;
            int n7 = inBuf[n4++] & 0xFF;
            outBuf[n6++] = this.encodingTable[n3 >>> 2 & 0x3F];
            outBuf[n6++] = this.encodingTable[(n3 << 4 | n2 >>> 4) & 0x3F];
            outBuf[n6++] = this.encodingTable[(n2 << 2 | n7 >>> 6) & 0x3F];
            outBuf[n6++] = this.encodingTable[n7 & 0x3F];
        }
        switch (inLen - (n4 - inOff)) {
            case 1: {
                n3 = inBuf[n4++] & 0xFF;
                outBuf[n6++] = this.encodingTable[n3 >>> 2 & 0x3F];
                outBuf[n6++] = this.encodingTable[n3 << 4 & 0x3F];
                outBuf[n6++] = this.padding;
                outBuf[n6++] = this.padding;
                break;
            }
            case 2: {
                n3 = inBuf[n4++] & 0xFF;
                n2 = inBuf[n4++] & 0xFF;
                outBuf[n6++] = this.encodingTable[n3 >>> 2 & 0x3F];
                outBuf[n6++] = this.encodingTable[(n3 << 4 | n2 >>> 4) & 0x3F];
                outBuf[n6++] = this.encodingTable[n2 << 2 & 0x3F];
                outBuf[n6++] = this.padding;
                break;
            }
        }
        return n6 - outOff;
    }

    @Override
    public int getEncodedLength(int inputLength) {
        return (inputLength + 2) / 3 * 4;
    }

    @Override
    public int getMaxDecodedLength(int inputLength) {
        return inputLength / 4 * 3;
    }

    @Override
    public int encode(byte[] buf, int off, int len, OutputStream out) throws IOException {
        int n2;
        if (len < 0) {
            return 0;
        }
        byte[] byArray = new byte[72];
        for (int i2 = len; i2 > 0; i2 -= n2) {
            n2 = Math.min(54, i2);
            int n3 = this.encode(buf, off, n2, byArray, 0);
            out.write(byArray, 0, n3);
            off += n2;
        }
        return (len + 2) / 3 * 4;
    }

    private boolean a(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[54];
        int n4 = 0;
        int n5 = 0;
        for (n3 = off + length; n3 > off && this.a((char)data[n3 - 1]); --n3) {
        }
        if (n3 == 0) {
            return 0;
        }
        int n6 = 0;
        for (n2 = n3; n2 > off && n6 != 4; --n2) {
            if (this.a((char)data[n2 - 1])) continue;
            ++n6;
        }
        n6 = this.a(data, off, n2);
        while (n6 < n2) {
            byte by;
            byte by2 = this.decodingTable[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by3 = this.decodingTable[data[n6++]];
            n6 = this.a(data, n6, n2);
            byte by4 = this.decodingTable[data[n6++]];
            n6 = this.a(data, n6, n2);
            if ((by2 | by3 | by4 | (by = this.decodingTable[data[n6++]])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            byArray[n4++] = (byte)(by2 << 2 | by3 >> 4);
            byArray[n4++] = (byte)(by3 << 4 | by4 >> 2);
            byArray[n4++] = (byte)(by4 << 6 | by);
            if (n4 == byArray.length) {
                out.write(byArray);
                n4 = 0;
            }
            n5 += 3;
            n6 = this.a(data, n6, n2);
        }
        if (n4 > 0) {
            out.write(byArray, 0, n4);
        }
        int n7 = this.a(data, n6, n3);
        int n8 = this.a(data, n7 + 1, n3);
        int n9 = this.a(data, n8 + 1, n3);
        int n10 = this.a(data, n9 + 1, n3);
        return n5 += this.a(out, (char)data[n7], (char)data[n8], (char)data[n9], (char)data[n10]);
    }

    private int a(byte[] byArray, int n2, int n3) {
        while (n2 < n3 && this.a((char)byArray[n2])) {
            ++n2;
        }
        return n2;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[54];
        int n4 = 0;
        int n5 = 0;
        for (n3 = data.length(); n3 > 0 && this.a(data.charAt(n3 - 1)); --n3) {
        }
        if (n3 == 0) {
            return 0;
        }
        int n6 = 0;
        for (n2 = n3; n2 > 0 && n6 != 4; --n2) {
            if (this.a(data.charAt(n2 - 1))) continue;
            ++n6;
        }
        n6 = this.a(data, 0, n2);
        while (n6 < n2) {
            byte by;
            byte by2 = this.decodingTable[data.charAt(n6++)];
            n6 = this.a(data, n6, n2);
            byte by3 = this.decodingTable[data.charAt(n6++)];
            n6 = this.a(data, n6, n2);
            byte by4 = this.decodingTable[data.charAt(n6++)];
            n6 = this.a(data, n6, n2);
            if ((by2 | by3 | by4 | (by = this.decodingTable[data.charAt(n6++)])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            byArray[n4++] = (byte)(by2 << 2 | by3 >> 4);
            byArray[n4++] = (byte)(by3 << 4 | by4 >> 2);
            byArray[n4++] = (byte)(by4 << 6 | by);
            n5 += 3;
            if (n4 == byArray.length) {
                out.write(byArray);
                n4 = 0;
            }
            n6 = this.a(data, n6, n2);
        }
        if (n4 > 0) {
            out.write(byArray, 0, n4);
        }
        int n7 = this.a(data, n6, n3);
        int n8 = this.a(data, n7 + 1, n3);
        int n9 = this.a(data, n8 + 1, n3);
        int n10 = this.a(data, n9 + 1, n3);
        return n5 += this.a(out, data.charAt(n7), data.charAt(n8), data.charAt(n9), data.charAt(n10));
    }

    private int a(OutputStream outputStream, char c2, char c3, char c4, char c5) throws IOException {
        if (c4 == this.padding) {
            if (c5 != this.padding) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            byte by = this.decodingTable[c2];
            byte by2 = this.decodingTable[c3];
            if ((by | by2) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by2 >> 4);
            return 1;
        }
        if (c5 == this.padding) {
            byte by = this.decodingTable[c2];
            byte by3 = this.decodingTable[c3];
            byte by4 = this.decodingTable[c4];
            if ((by | by3 | by4) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by4 >> 2);
            return 2;
        }
        byte by = this.decodingTable[c2];
        byte by5 = this.decodingTable[c3];
        byte by6 = this.decodingTable[c4];
        byte by7 = this.decodingTable[c5];
        if ((by | by5 | by6 | by7) < 0) {
            throw new IOException("invalid characters encountered at end of base64 data");
        }
        outputStream.write(by << 2 | by5 >> 4);
        outputStream.write(by5 << 4 | by6 >> 2);
        outputStream.write(by6 << 6 | by7);
        return 3;
    }

    private int a(String string, int n2, int n3) {
        while (n2 < n3 && this.a(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }
}

