/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.decodingTable.length; ++n2) {
            this.decodingTable[n2] = -1;
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.decodingTable[this.encodingTable[n2]] = (byte)n2;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) throws IOException {
        int n2 = inOff;
        int n3 = inOff + inLen;
        int n4 = outOff;
        while (n2 < n3) {
            int n5 = inBuf[n2++] & 0xFF;
            outBuf[n4++] = this.encodingTable[n5 >>> 4];
            outBuf[n4++] = this.encodingTable[n5 & 0xF];
        }
        return n4 - outOff;
    }

    @Override
    public int getEncodedLength(int inputLength) {
        return inputLength * 2;
    }

    @Override
    public int getMaxDecodedLength(int inputLength) {
        return inputLength / 2;
    }

    @Override
    public int encode(byte[] buf, int off, int len, OutputStream out) throws IOException {
        int n2;
        if (len < 0) {
            return 0;
        }
        byte[] byArray = new byte[72];
        for (int i2 = len; i2 > 0; i2 -= n2) {
            n2 = Math.min(36, i2);
            int n3 = this.encode(buf, off, n2, byArray, 0);
            out.write(byArray, 0, n3);
            off += n2;
        }
        return len * 2;
    }

    private static boolean a(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[36];
        int n4 = 0;
        for (n2 = off + length; n2 > off && HexEncoder.a((char)data[n2 - 1]); --n2) {
        }
        int n5 = off;
        while (n5 < n2) {
            byte by;
            while (n5 < n2 && HexEncoder.a((char)data[n5])) {
                ++n5;
            }
            byte by2 = this.decodingTable[data[n5++]];
            while (n5 < n2 && HexEncoder.a((char)data[n5])) {
                ++n5;
            }
            if ((by2 | (by = this.decodingTable[data[n5++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            byArray[n4++] = (byte)(by2 << 4 | by);
            if (n4 == byArray.length) {
                out.write(byArray);
                n4 = 0;
            }
            ++n3;
        }
        if (n4 > 0) {
            out.write(byArray, 0, n4);
        }
        return n3;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[36];
        int n4 = 0;
        for (n2 = data.length(); n2 > 0 && HexEncoder.a(data.charAt(n2 - 1)); --n2) {
        }
        int n5 = 0;
        while (n5 < n2) {
            byte by;
            while (n5 < n2 && HexEncoder.a(data.charAt(n5))) {
                ++n5;
            }
            byte by2 = this.decodingTable[data.charAt(n5++)];
            while (n5 < n2 && HexEncoder.a(data.charAt(n5))) {
                ++n5;
            }
            if ((by2 | (by = this.decodingTable[data.charAt(n5++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            byArray[n4++] = (byte)(by2 << 4 | by);
            if (n4 == byArray.length) {
                out.write(byArray);
                n4 = 0;
            }
            ++n3;
        }
        if (n4 > 0) {
            out.write(byArray, 0, n4);
        }
        return n3;
    }

    byte[] a(String string, int n2, int n3) throws IOException {
        if (null == string) {
            throw new NullPointerException("'str' cannot be null");
        }
        if (n2 < 0 || n3 < 0 || n2 > string.length() - n3) {
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        if (0 != (n3 & 1)) {
            throw new IOException("a hexadecimal encoding must have an even number of characters");
        }
        int n4 = n3 >>> 1;
        byte[] byArray = new byte[n4];
        int n5 = n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by;
            byte by2;
            int n6;
            if ((n6 = (by2 = this.decodingTable[string.charAt(n5++)]) << 4 | (by = this.decodingTable[string.charAt(n5++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            byArray[i2] = (byte)n6;
        }
        return byArray;
    }
}

